@extends('backend.layouts.split')

@section('title', __('labels.backend.access.emails.management') . ' | ' . app_name())

@section('content')
<div class="row row-top-margin">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-envelope font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> Email Templates </span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-toolbar">
                    <div class="row">
                       <div class="col-md-6"></div>
                        <div class="col-md-6">
                            <div class="btn-group float-end">
                                <!-- @include('backend.auth.templates.includes.header-buttons') -->
                            </div>
                        </div>
                    </div>
                </div>
                <table class="table table-striped table-bordered table-hover table-checkable order-column table-data_table">
                    <thead>
                        <tr role="row" class="heading">
                            <th width="5%"> # </th>
                            <th width="25%"> Label </th>
                            <th width="25%"> Subject </th>
                            <th width="30%"> Description </th>
                            <th width="10%">@lang('labels.general.actions')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($templates as $template)
                        <tr>
                            <td>{{ $template->id }}</td>
                            <td>{{ $template->title }}</td>
                            <td>{{ $template->subject }}</td>
                            <td>{{ strip_tags($template->description) }}</td>
                            <td>{!! $template->action_buttons !!}</td>
                        </tr>                                
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>
@endsection