@extends('backend.layouts.split')

@section('title', __('labels.backend.access.users.create') . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('breadcrumb-links')
    @include('backend.auth.user.includes.breadcrumb-links')
@endsection

@section('content')
    {{ html()->form('POST', route('admin.auth.user.store'))->class('form-actions top')->open() }}
    <input type="hidden" name="active" value="1">
    <div class="row" style="margin-top:25px">
        <div class="col-md-12">
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <h4 class="card-title mb-0 caption-subject bold">
                        @lang('labels.backend.access.users.management')
                        <small class="text-muted">@lang('labels.backend.access.users.create')</small>
                    </h4>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.backend.access.users.first_name'))->class('control-label')->for('first_name') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-user"></i>
                                        </span>
                                        {{ html()->text('first_name')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.backend.access.users.first_name'))
                                            ->attribute('maxlength', 191)
                                            ->required()
                                            ->autofocus() }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.backend.access.users.last_name'))->class('control-label')->for('last_name') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-user"></i>
                                        </span>
                                        {{ html()->text('last_name')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.backend.access.users.last_name'))
                                            ->attribute('maxlength', 191)
                                            ->required() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.backend.access.users.email'))->class('control-label')->for('email') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-envelope"></i>
                                        </span>
                                        {{ html()->email('email')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.backend.access.users.email'))
                                            ->attribute('maxlength', 191)
                                            ->required() }}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.backend.access.users.password'))->class('control-label')->for('password') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-unlock-alt" aria-hidden="true"></i>
                                        </span>
                                        {{ html()->password('password')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.backend.access.users.password'))
                                            ->required() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group lable-style">
                                    {{ html()->label(__('validation.attributes.backend.access.users.password_confirmation'))->class('control-label')->for('password_confirmation') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-unlock-alt" aria-hidden="true"></i>
                                        </span>
                                        {{ html()->password('password_confirmation')
                                            ->class('form-control input-circle-right')
                                            ->placeholder(__('validation.attributes.backend.access.users.password_confirmation'))
                                            ->required() }}
                                    </div>
                                </div>
                            </div>                            
                            <div class="col-md-6">
                                <div class="form-group lable-style">
                                    {{ html()->label(__('labels.backend.access.users.table.roles'))->class('col-md-12 control-label')->for('roles') }}
                                    <div class="input-group">
                                        <span class="input-group-text input-circle-left">
                                            <i class="fa fa-tasks" aria-hidden="true"></i>
                                        </span>
                                        <select name="roles" id="role" class="form-control input-circle-right user-roles" required="required">
                                            @foreach ($roles as $role)
                                                <option value="{{ $role->id }}" <?= (old('roles') == $role->id) ? 'selected' : '' ?>>{{ ucwords(str_replace('_', ' ', $role->name)) }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="customer-profile-container" style="display:none">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Business Name'))->class('control-label')->for('business_name') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-building" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('business_name')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Business Name'))
                                                ->attribute('maxlength', 191)
                                                    }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Customer Code'))->class('control-label')->for('ac_code') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-building" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('ac_code')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Customer Code'))
                                                ->attribute('maxlength', 191)
                                                    }}
                                        </div>
                                    </div>
                                </div>                              
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Address Line 1'))->class('control-label')->for('address1') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-map-marker" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('address1')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Address'))
                                                ->attribute('maxlength', 191)
                                                 }}
                                        </div>
                                    </div>
                                </div>                            
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Address Line 2'))->class('col-md-12 control-label')->for('address2') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-map-marker" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('address2')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Address'))
                                                ->attribute('maxlength', 191)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('City'))->class('control-label')->for('city') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-building-o" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('city')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('city'))
                                                ->attribute('maxlength', 191)
                                                 }}
                                        </div>
                                    </div>
                                </div>                            
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('State'))->class('col-md-12 control-label')->for('state') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-location-arrow" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('state')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('state'))
                                                ->attribute('maxlength', 191)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Country'))->class('control-label')->for('country') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-globe" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('country')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('country'))
                                                ->attribute('maxlength', 191)
                                                 }}
                                        </div>
                                    </div>
                                </div>                            
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Zip Code'))->class('col-md-12 control-label')->for('zip_code') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-list-ol" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('zip_code')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Zip Code'))
                                                ->attribute('maxlength', 191)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Phone'))->class('control-label')->for('phone') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-phone-square" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('phone')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Phone'))
                                                ->attribute('maxlength', 191)
                                                 }}
                                        </div>
                                    </div>
                                </div>                            
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Fax'))->class('col-md-12 control-label')->for('fax') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-fax" aria-hidden="true"></i>
                                            </span>
                                            {{ html()->text('fax')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Fax'))
                                                ->attribute('maxlength', 191)
                                                 }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Date of Birth'))->class('control-label')->for('date_of_birth') }}
                                        <div class="input-group date-picker">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-calendar"></i>
                                            </span>
                                            {{ html()->text('date_of_birth')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Date of Birth')) }}
                                        </div>
                                    </div>
                                </div>                            
                                <div class="col-md-6">
                                    <div class="form-group lable-style">
                                        {{ html()->label(__('Religion'))->class('control-label')->for('religion') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-globe"></i>
                                            </span>
                                            {{ html()->text('religion')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Religion'))
                                                ->attribute('maxlength', 191) }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ html()->label(__('Ethnicity'))->class('control-label')->for('ethnicity') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-globe"></i>
                                            </span>
                                            {{ html()->text('ethnicity')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Ethnicity'))
                                                ->attribute('maxlength', 191) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        {{ html()->label(__('Notes'))->class('control-label')->for('notes') }}
                                        <div class="input-group">
                                            <span class="input-group-text input-circle-left">
                                                <i class="fa fa-sticky-note-o"></i>
                                            </span>
                                            {{ html()->text('notes')
                                                ->class('form-control input-circle-right')
                                                ->placeholder(__('Notes'))
                                                ->attribute('maxlength', 191) }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row" style="margin-top:30px">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label('Enabled')->class('col-md-4 control-label style-lable')->for('confirmed') }}
                                    <div class="input-group">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            {{ html()->checkbox('confirmed', true)->class('make-switch')->attribute('data-on-color','primary')->attribute('data-off-color','danger')->attribute('data-on-text','Yes')->attribute('data-off-text','No') }}
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{ html()->label(__('validation.attributes.backend.access.users.send_confirmation_email') . '<br/>' . '<small>' .  __('strings.backend.access.users.if_confirmed_off') . '</small>')->class('col-md-4 control-label style-lable')->for('confirmation_email') }}
                                    <div class="input-group">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            {{ html()->checkbox('confirmation_email', true)->class('make-switch')->attribute('data-on-color','primary')->attribute('data-off-color','danger')->attribute('data-on-text','Yes')->attribute('data-off-text','No') }}
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions right">
                        {{ form_cancel(route('admin.auth.user.index'), __('buttons.general.cancel')) }}
                        {{ form_submit(__('buttons.general.crud.create')) }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{ html()->form()->close() }}
@endsection

@push('after-scripts')
    <script>
        $(function() {
            var userType = $('#role').val();
            updateUserTypeDdl(userType);
            $("select.user-roles").change(function(){
               var role = $(this).children("option:selected").val();
               updateUserTypeDdl(role)
            });
        });
        function updateUserTypeDdl(value){
            value == 4 ? $('.customer-profile-container').show() : $('.customer-profile-container').hide();
        }
    </script>
@endpush