@extends('backend.layouts.split')
@section('title', __('labels.backend.access.users.management') . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())
@section('breadcrumb-links')
    @include('backend.auth.user.includes.breadcrumb-links')
@endsection
@section('content')
<div class="row row-top-margin">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable">
            <div class="portlet-body">
                <div style="float:right;">
                    @include('backend.auth.user.includes.header-buttons')
                </div>
                    @include('backend.auth.user.includes.search-form')
                <input type="hidden" id="total-records" value="{{ $totalRecords ?? 0 }}">
                <div class="order-list">
                    <div class="row no-gutters">
                                <div class="col-4 table-data-container adjust_height-container nscroller" style="padding: 0; overflow-y: auto;">
                                    <div class="table-responsive" id="records-container">
                                        @include('partials.user-table', compact('users', 'pageCount'))
                                    </div>
                                </div>
                                <div class="col-8">
                                    <div class="tabbable-custom nav-justified order-details-container box-shadow">
                                        <ul class="nav nav-pills nav-justified">
                                            <li class="nav-item active">
                                                <a href="#tab_order" data-toggle="tab" class="nav-link active tab_order"> Details </a>
                                            </li>
                                        </ul>
                                        <div class="tab-content">
                                            <div class="tab-pane nscroller active" id="tab_order">
                                                <center><h3>Click to view <i class="fa fa-shopping-cart" aria-hidden="true"></i></h3></center>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                    </div>
                </div>
                <div class="dt-more-container text-center">
                    <button type="button" class="btn blue mt-ladda-btn ladda-button btn-outline btn-circle not-allowed" id="load-more-btn" data-style="slide-up" data-spinner-color="#333" data-attr="table-data-container" <?= (!$users->hasMorePages()) ? 'disabled' : '' ?>>
                        <span class="ladda-label"> <i class="icon-arrow-down"></i>  Load More</span>
                        <span class="ladda-spinner"></span>
                    </button>
                </div>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>
@endsection
