<?php 
$notifications = $logged_in_user->notifications();
$unreadNotifications = $logged_in_user->unreadNotifications();
?>
<nav class="navbar navbar-expand-lg mega-menu" role="navigation">
    <div class="container-fluid">
        <div class="clearfix fixed-top">
            <!-- Brand and toggle get grouped for better mobile display -->
            <button type="button" class="navbar-toggler" data-toggle="collapse" data-target=".navbar-responsive-collapse">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
            <!-- End Toggle Button -->
            <!-- BEGIN LOGO -->
            <a id="index" class="page-logo"
                href="{{ auth()->user()->isAdmin() ? route('admin.orders.list') : route('admin.orders.list') }}">
                <img src="{{ URL::asset('img/backend/brand/logo.png') }}" alt="Logo"> </a>
            <!-- END LOGO -->
            <!-- BEGIN HEADER MENU -->
            <div class="nav-collapse collapse navbar-collapse navbar-responsive-collapse">
                <ul class="navbar-nav">
                    @if(auth()->user()->isAcessible(['backend view users','backend admin']) &&  auth()->user()->isAdmin() )
                        <li class="dropdown dropdown-fw dropdown-fw-disabled {{
                            active_class(Active::checkUriPattern('admin/auth/user*'),'selected active open')
                        }}">
                            <a href="{{ route('admin.auth.user.index') }}" class="text-uppercase">
                                <i class="icon-users"></i> Users </a>
                        </li>
                    @endif
                    @can('view backend')
                    <li class="dropdown dropdown-fw dropdown-fw-disabled {{
                        active_class(Active::checkUriPattern('admin/orders'),'selected active open')
                    }}">
                        <a href="{{ route('admin.orders.list') }}" class="text-uppercase">
                            <i class="fa fa-shopping-cart"></i> Orders</a>
                            <!-- {!! svg_image('orders-menu.svg', 'svg-icons', 'Orders') !!} @lang('Orders') -->
                        </a>
                    </li>
                    
                    @endcan      
                    <li class="dropdown dropdown-fw dropdown-fw-disabled {{
                            active_class(Active::checkUriPattern('admin/notifications'),'selected active open')
                        }}" id="notification-header-link">
                        <a href="{{ route('admin.user.notifications') }}" class="text-uppercase">
                             <i class="fa fa-bell"></i> Notifications
                            <!-- {!! svg_image('notification.svg', 'svg-icons', 'Notifications') !!} @lang('Notifications') -->
                            @if(count($unreadNotifications) > 0)
                                <span class="badge badge-danger notifications-badge-counter">{{ count($unreadNotifications) }}</span>
                            @else
                                <span class="badge badge-danger notifications-badge-counter"></span>
                            @endif
                        </a>
                    </li>
                    @if(auth()->user()->isAcessible(['backend admin']))
                        <li class="dropdown dropdown-fw dropdown-fw-disabled {{
                            active_class(Active::checkUriPattern('admin/auth/template*'),'selected active open')
                        }}">
                            <a href="{{ route('admin.auth.template.index') }}" class="text-uppercase">
                                <i class="fa fa-envelope-o"></i> Email Templates </a>
                        </li>
                    @endif
                    @if(auth()->user()->isAcessible(['backend admin']) || auth()->user()->isLabManager())
                    <li class="dropdown dropdown-fw dropdown-fw-disabled {{
                        active_class(Active::checkUriPattern('admin/orders/settings*'),'selected active open')
                    }}">
                        <a href="{{ route('admin.orders.settings') }}" class="text-uppercase">
                            <i class="fa fa-cogs"></i> Setup </a>
                            <!-- {!! svg_image('setting.svg', 'svg-icons', 'Setup') !!} @lang('Setup') -->
                        </a>
                    </li>
                    @endif
                    @if(auth()->user()->isAcessible(['backend admin']))
                    <li class="dropdown dropdown-fw dropdown-fw-disabled {{
                        active_class(Active::checkUriPattern('admin/auth/api-client*'),'selected active open')
                    }}">
                        <a href="{{ route('admin.auth.api-client.index') }}" class="text-uppercase">
                            <i class="fa fa-key"></i> Api Clients </a>
                    </li>
                    @endif
                </ul>
            </div>
            <div class="topbar-actions">
                <!-- BEGIN GROUP NOTIFICATION -->
                <!-- END GROUP NOTIFICATION -->
                <!-- BEGIN USER PROFILE -->
                <div class="btn-group-img btn-group">
                    <button type="button" class="btn btn-sm md-skip dropdown-toggle profile-btn" data-toggle="dropdown">
                        <span class="text-right">
                            {{ $logged_in_user->name }} <i class="fa fa-arrow-down"></i> <br> Admin
                            <!-- {{ $logged_in_user->name }} {!! svg_image('arrow-down.svg', 'svg-icons', 'Arrow Down') !!} -->
                        </span>
                        @if(!$logged_in_user->isGravatar())
                            <img class="avatar" src="{{ $logged_in_user->picture }}" alt="">
                        @endif
                    </button>
                    <ul class="dropdown-menu dropdown-menu-v2" role="menu">
                        @if(auth()->user()->isAcessible(['backend view users','backend admin']) && auth()->user()->isAdmin())
                            <li>
                                <a href="{{ route('admin.auth.user.index') }}">
                                    <i class="icon-users"></i> Users
                                </a>
                            </li>
                        @endif
                        @can('view backend')
                            <li>
                                <a href="{{ route('admin.orders.list') }}">
                                    <i class="fa fa-shopping-cart"></i> Orders
                                    <!-- {!! svg_image('orders-menu.svg', 'svg-icons', 'Orders') !!} @lang('Orders') -->
                                </a>
                            </li>
                        @endcan 
                        <li>
                            <a href="{{ !auth()->user()->isCustomerAdmin() ? route('admin.user.account') : route('frontend.user.account')}}">
                                <i class="icon-user"></i> My Profile
                                <!-- {!! svg_image('account.svg', 'svg-icons', 'My Profile') !!} @lang('My Profile') -->
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('frontend.auth.logout') }}">
                                <i class="icon-key"></i> Log Out </a>
                                <!-- {!! svg_image('logout.svg', 'svg-icons', 'Log Out') !!} @lang('Log Out') -->
                            </a>
                        </li>
                    </ul>
                </div>
                <!-- END USER PROFILE -->
            </div>
            <!-- END TOPBAR ACTIONS -->
        </div>
    </div>
    <!--/container-->
</nav>