<!-- use App\Models\Backend\LabOrders; -->
<?php
use App\Models\Auth\User;
?>

<div class="row row-top-margin">
    <div class="col-md-12">
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-envelope font-green"></i>
                    <span class="caption-subject font-green sbold uppercase">Lab Order Control </span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-toolbar">
                    <div class="row">
                       <div class="col-md-6"></div>
                        <div class="col-md-6">
                            <div class="btn-group float-end">
                            
                            </div>
                        </div>
                    </div>
                </div>
                <table class="table table-striped table-bordered">
                    <thead>
                        <tr role="row" class="heading">
                            <th>Business Account</th>
                            <th>Order Type</th>
                            <th>Enable Control</th>
                        </tr>
                    </thead>
                    <tbody style="visibility: hidden;">
                        <tr>
                            <td width="45%">
                                <select class="form-control select2" id="user_account_select" name="user_accounts[]" multiple data-placeholder="Choose Multiple Accounts...">
                                    @if(isset($usersForSelect))
                                        <option value="all" name="all" @if(isset($savedConfig['user_accounts']) && in_array('all', $savedConfig['user_accounts'])) selected @endif>
                                            000 - Enable for all Accounts
                                        </option>
                                        @foreach($usersForSelect as $value)
                                            <option value="{{ $value->id }}" @if(isset($savedConfig['user_accounts']) && in_array((string)$value->id, $savedConfig['user_accounts'])) selected @endif>
                                                {{ $value->ac_code .' - '. $value->business_name }}
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                            </td>
                            <td width="45%">
                                 <select class="form-control select2" id="order_type_select" name="order_type_select[]" multiple data-placeholder="Choose Multiple Order Types...">
                                    @if(isset($orderType))
                                        @foreach($orderType  as $Key => $type)
                                            <option value="{{ $Key }}" @if(isset($savedConfig['order_types']) && in_array($Key, $savedConfig['order_types'])) selected @endif>
                                                {{ $type }}
                                            </option>
                                        @endforeach
                                    @endif
                                </select>
                            </td>
                            <td width="10%">
                                <input type="checkbox" name="status" id="status_checkbox" @if(isset($savedConfig['status']) && $savedConfig['status'] == "true") checked @endif>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@push('after-scripts')
<script>
$(window).on('load', function() {
    $('tbody').css('visibility', 'visible');
});

$(document).ready(function() {
    function saveConfiguration() {
        var data = {
            _token: '{{ csrf_token() }}',
            user_accounts: $('#user_account_select').val(),
            order_types: $('#order_type_select').val(),
            status: $('#status_checkbox').is(':checked')
        };
        $.post('{{ route("admin.auth.orders.lab.configuration.save") }}', data, function(response) {
            if(response.success) {
                console.log(response.message);
                if (response.user_accounts) {
                    $('#user_account_select').val(response.user_accounts).trigger('change');
                }
            }
        });
    }

    $('#user_account_select, #order_type_select, #status_checkbox').on('change', function() {
        saveConfiguration();
    });
});
</script>
@endpush