@extends('backend.layouts.split')

@section('content')
<div class="lab-order-container">
    <div class="lab-order-header">
        <h3>Lab Orders</h3>
    </div>
    
    <div class="table-responsive" id="records-container">
        <input type="hidden" id="total-records" value="{{ $totalRecords ?? 0 }}">
        <table class="table table-striped table-bordered table-hover order-column box-shadow" data-more="no" data-page="1">
            <thead>
                <tr role="row" class="heading">
                    <th> 
                        <span class="d-block">Order #</span>
                        <span class="d-block">Invoice #</span>
                    </th>
                    <th> 
                        <span class="d-block">Patient Reference</span>
                        <span class="d-block">Order Date</span>
                    </th>
                    <th> 
                        <span class="d-block">Account</span>
                    </th>
                    <th> 
                        <span class="d-block">Status</span>
                    </th>
                    <th>
                        <span class="d-block">Actions</span>
                    </th>
                </tr>
            </thead>
            <tbody>
                @if(isset($orders))
                    @foreach ($orders as $order)
                        <tr data-id="{{ $order->id }}" class="position-relative" id="tr_order-{{ $order->id }}">
                            <td>
                                <span class="d-block">
                                    {!! $order->getMethodIcon() !!} {{ $order->getOrderNumber() }}
                                </span>
                                <span class="d-block">
                                    {{ $order->invoice_no }}
                                </span>
                            </td>
                            <td class="position-relative">
                                <span class="d-block">
                                    {{ $order->getPatient() }}
                                </span>
                                <span class="ship-date">
                                    {{ $order->getOrderDate() }}
                                </span>
                            </td>
                            <td>
                                <span class="d-block">
                                    {{ optional($order->user)->ac_code ? optional($order->user)->ac_code . ' - ' . optional($order->user)->getBusinessName() : '' }}
                                </span>
                            </td>
                            <td>
                                <span class="d-block">
                                    {!! $order->getStatusLabelAttribute(true) !!}
                                </span>
                            </td>
                            <td><span>{{ $order->type }}</span><button class="btn blue float-right" type="submit">Update Order</button>
                            <button class="btn green float-right lab-order-submit" type="submit">Submit Order</button></td>
                        </tr>
                    @endforeach
                @endif
            </tbody>
        </table>
    </div>
</div>
@endsection