<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', app_name())</title>
    <meta name="description" content="@yield('meta_description', 'Lens Shapers')">
    <meta name="author" content="@yield('meta_author', 'Lens Shapers')">
    @yield('meta')
    @stack('before-styles')

    <link rel="shortcut icon" href="{{asset('public/favicon.ico')}}" id="favicon" />

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    @php
    $layoutMode = 'split';
    $sections = $__env->getSections();
    if (isset($sections['layout_mode'])) {
        $layoutMode = trim($sections['layout_mode']);
    }
    @endphp
    @if($layoutMode == 'split')
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
        <script src="https://js.pusher.com/4.1/pusher.min.js"></script>
    @endif
    <script src="{{ asset('assets/global/plugins/bootstrap-select/js/bootstrap-select.min.js') }}"></script>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @if($layoutMode == 'split')
        <script src="//cdn.ckeditor.com/4.22.1/full-all/ckeditor.js"></script>
    @else
        <script src="//cdn.ckeditor.com/4.22.1/full-all/ckeditor.js"></script>
    @endif
        <script src="https://unpkg.com/@popperjs/core@2"></script>
        <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

    @stack('after-styles')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script type="text/javascript">
        var baseUrl = "<?= url('') ?>/admin";
    </script>
</head>
<body class="@if($layoutMode == 'app')page-header-fixed page-sidebar-closed-hide-logo page-content-white @else page-sidebar-closed-hide-logo @endif">
    @if($layoutMode == 'split')
        <div class="chatpageloader loader" style="display: none;">
            <div class="lds-ring">
            </div>
        </div>
    @endif
    @include('includes.partials.messages')
    @if($layoutMode == 'app')
        <div class="page-wrapper">
            @include('backend.includes.header')
            <div class="page-container">
                @include('backend.includes.sidebar')
                <div class="page-content-wrapper">
                    <div class="page-content">
                        @if (!Route::is('frames.index'))
                            {!! Breadcrumbs::render() !!}
                        @endif
                        @yield('content')
                    </div>
                </div>
            </div>
            @include('backend.auth.orders.includes.message-modal')
            @include('backend.includes.footer')
        </div>
    @else
        <div class="wrapper split-wrapper">
            <header class="page-header custom-page-header split-header">
                @include('backend.includes.split-header')
            </header>
            <div class="split-content">
                <div class="container-fluid p-0">
                    <div class="page-content">
                        <div class="breadcrumbs">
                            {{-- {!! Breadcrumbs::render() !!} --}}
                        </div>
                        {!! $content ?? '' !!}@yield('content')
                    </div>
                </div>
            </div>
            <footer class="split-footer">
                @include('backend.includes.footer')
            </footer>
            @include('backend.auth.orders.includes.message-modal')
        </div>
    @endif

    <!-- Scripts -->
    @stack('before-scripts')
    @if($layoutMode == 'app')
        <script type="text/javascript">
            var validateUrl = "<?= route('admin.user.validate') ?>";
            var loginUrl = "<?= route('frontend.auth.login') ?>";
            $(function() {
                $.ajax({
                    url: validateUrl,
                    type: "GET",
                    cache: false,
                    error: function (request, status, error) {
                        window.location.replace(loginUrl);
                    }
                });
            });
        </script>
    @else
        <script type="text/javascript">
            let portalType = 'admin';
        </script>
        <script type="text/javascript">
            var validateUrl = "<?= route('admin.user.validate') ?>";
            var loginUrl = "<?= route('login') ?>";
            var userId = "<?= auth()->user()->id ?>";
            var isSuperAdmin = true;
            var notificationChannel = null;
            var PhoneLog = {
                TYPE_ORDER_CANCELLATION: 'order_cancellation',
                TYPE_REQUEST_CHANGE: 'request_change',
                TYPE_PHONE_LOG: 'phone_log',
                TYPE_NOTE: 'notes',
                TYPE_QUESTION: 'questions'
            };
            var pusher = new Pusher("{{ config('app.pusher.key') }}", {
                cluster: "{{ config('app.pusher.options.cluster') }}",
                encrypted: true
            });
            notificationChannel = pusher.subscribe("{{ Auth::user()->getChannelId() }}");
            window.isLoaderStop = true;
            window.isLoaderFStop = false;
            $(function() {
                $('.chatpageloader').hide();
                $.ajax({
                    url: validateUrl,
                    type: "GET",
                    cache: false,
                    error: function (request, status, error) {
                        window.location.replace(loginUrl);
                    }
                });
            });
        </script>
    @endif
    @stack('after-scripts')
</body>
</html>
