<?php
use App\Models\Backend\PhoneLog;
use App\Models\Backend\Order;
?>
@extends('frontend.layouts.split')

@section('title', 'Orders' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
<div class="row row-top-margin">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable">
            <div class="portlet-body">
                @include('frontend.auth.orders.includes.orders-search-form', compact('orders', 'pageCount'))
                <div class="order-list">
                    <div class="row">
                        <div class="col-lg-6 col-md-12 p-0 table-data-container adjust_height-container" style="padding: 0; overflow-y: auto;">
                            <div class="table-responsive scrollable-container" id="records-container">
                                @include('partials.orderlist', compact('orders', 'pageCount'))
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-12 p-0 adjust_height-container">
                            <div class="tabbable-custom nav-justified order-details-container box-shadow" id="order-details-container">
                                <ul class="nav nav-pills nav-justified">
                                    <li class="nav-item">
                                        <a href="#tab_order" data-toggle="tab" class="nav-link active tab_order" aria-expanded="true"> Order </a>
                                    </li>
                                    @if($pageType == 0)
                                        <li class="nav-item">
                                            <a href="#tab_comments" data-toggle="tab" class="data-tabs nav-link  tab_comments" data-value="comments" data-id="comment-tab-wrapper" aria-expanded="false"> Notifications <span class="badge badge-danger noti_counter-span" style="display:none;">0</span> </a>
                                        </li>
                                        @if(auth()->user()->isOrderPricesInvoicesPermission())
                                        <li class="nav-item">
                                            <a href="#tab_invoice" data-toggle="tab" class="data-tabs nav-link  tab_invoice" data-value="invoice" data-id="tab_invoice" aria-expanded="false"> Invoice </a>
                                        </li>
                                        @endif
                                    @endif
                                </ul>
                                <div class="tab-content" data-height-set="true" style="height: 100%;">
                                    <div class="tab-pane active" id="tab_order">
                                        <center><h3>Choose an order on left to see details...</h3></center>
                                    </div>
                                    <div class="tab-pane" id="tab_comments">
                                        <div id="comment-tab-wrapper">
                                        </div>
                                        <div class="form-group comment-box-container">
                                            <div class="container-extend">
                                                <div class="row" style="padding:0px;">
                                                    <div class="col-12">
                                                        <div id="textarea-header" style="display: none; font-weight: bold;"></div>
                                                        <textarea class="form-control todo-taskbody-taskdesc" id="comment_textarea" placeholder="Type here..." rows="3" cols="10" style="resize: none; display: none;"></textarea>
                                                        <input type="hidden" name="order_id" id="cmt_order_id" value="">
                                                        <!-- Moved buttons inside the same row, right below textarea -->
                                                        <div class="text-end mt-2" id="textarea-buttons" style="display: none;">
                                                            <span class="btn btn-outline-secondary btn-sm me-2 red" id="cancel-comment-btn">Cancel</span>
                                                            <span class="btn btn-primary btn-sm blue" id="send-comment-btn">Send</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Action Buttons (unchanged) -->
                                                <div class="mt-5" id="action-buttons" style="display: block;">
                                                    <div class="d-flex justify-content-between">
                                                        <!-- Left Side Group - Request Cancellation -->
                                                        <div>
                                                            <button class="btn btn-danger add-comment-btn" data-type="order_cancellation" data-placeholder="Please provide a reason for cancelling the order..." data-loading-text="Saving ..." type="button">
                                                                <i class="fa fa-times"></i> Request Cancellation
                                                            </button>
                                                        </div>
                                                        <!-- Right Side Group - Request Change -->
                                                        <div>
                                                            <button class="btn btn-primary add-comment-btn" data-type="request_change" data-placeholder="Describe the changes you'd like to request for this order..." data-loading-text="Saving ..." type="button">
                                                                <i class="fa fa-exchange"></i> Request Change
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="tab_invoice">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>
<div class="modal fade bs-modal-lg" id="start_redo-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            {{ html()->form('POST', route('frontend.user.redo'))->attribute('id','start_redo_order-form')->open() }}
            <input type="hidden" name="id" value="">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>

                <h4 class="modal-title"><i class="fas fa-redo" aria-hidden="true"></i>&nbsp;&nbsp;Start Redo</h4>
            </div>
            <div class="modal-body">
                <div class="form-body">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        <label for="">Reason for Redo</label>
                        <select name="reason" class="form-control select2_custom" required>
                            <option value="">Please Select</option>
                            @foreach (Order::getReasonsArrayList() as $value)
                                <option value="{{$value}}">{{$value}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group form-md-line-input">
                        <label for="">Notes</label>
                        <textarea class="form-control" rows="3" name="notes" placeholder="Add more details..."></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="btn dark btn-outline">Cancel</button>
                <button type="submit" class="btn blue btn-outline">Next</button>
            </div>
            {{ html()->form()->close() }}
        </div>
    </div>
</div>
@push('after-scripts')
<script>
    window.isLoaderFStop = true;
</script>
@endpush
@endsection
