@extends('frontend.layouts.split')

@section('title', 'All Orders' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')<div class="clearfix"></div>
<div class="row" style="margin-top: 15px;">
    <div class="col-lg-12 col-12 col-sm-12">
        <div class="portlet light portlet-fit bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-microphone font-dark hide"></i>
                    <span class="caption-subject bold font-dark uppercase"> Orders</span>
                    <span class="caption-helper">Choose any order...</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="row">
                    <div class="col-md-4 col-sm-6 col-12" style="height: 183px;margin-bottom: 10px;">                        
                        <div class="mt-widget-2">
                            <div class="mt-head" style="background-image: url({{ URL::asset('public/assets/pages/img/background/eye3.jpg') }});">
                                <div class="mt-head-label">
                                    <a href="{{ route('frontend.user.rx-lens-orders') }}" class="btn btn-success">Order Rx Lenses</a>
                                </div>
                                <a href="{{ route('frontend.user.rx-lens-orders') }}">
                                    <div class="mt-head-user">
                                        <div class="mt-head-user-img">
                                        </div>
                                        <div class="mt-head-user-info">
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-12" style="height: 183px;margin-bottom: 10px;">
                        <div class="mt-widget-2">
                            <div class="mt-head" style="background-image: url({{ URL::asset('public/assets/pages/img/background/eye2.jpg') }});">
                                <div class="mt-head-label">
                                    <a href="{{ route('frontend.user.stock-lens-orders') }}" class="btn btn-info">Order Stock Lenses</a>
                                </div>
                                <a href="{{ route('frontend.user.stock-lens-orders') }}">
                                    <div class="mt-head-user">
                                        <div class="mt-head-user-img">
                                        </div>
                                        <div class="mt-head-user-info">
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6 col-12" style="height: 183px;margin-bottom: 10px;">
                        <div class="mt-widget-2">
                            <div class="mt-head" style="background-image: url({{ URL::asset('public/assets/pages/img/background/eye1.jpg') }});">
                                <div class="mt-head-label">
                                    <a href="{{ route('frontend.user.consumables-lens-orders') }}" class="btn btn-danger">Order Consumables</a>
                                </div>
                                <a href="{{ route('frontend.user.consumables-lens-orders') }}">
                                    <div class="mt-head-user">
                                        <div class="mt-head-user-img">
                                        </div>
                                        <div class="mt-head-user-info">
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-12 col-12 col-sm-12">
        <div class="portlet light portlet-fit bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-microphone font-dark hide"></i>
                    <span class="caption-subject bold font-dark uppercase"> Help</span>
                    <span class="caption-helper">How to start...</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="row">
                    <div class="col-sm-2"></div>
                    <div class="col-sm-8">
                        <iframe width="100%" height="315"
                        src="<?= \App\Models\Backend\AppSettings::findByKey(\App\Models\Backend\AppSettings::DEFAULT_HOW_TO_START_VIDEO); ?>">
                        </iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row row-top-margin">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-basket font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> All Orders </span>
                </div>
                <div class="actions">
                    <div class="btn-group">
                        <a class="btn btn-sm blue btn-outline btn-circle" href="javascript:;" data-toggle="dropdown" data-hover="dropdown" data-close-others="true" aria-expanded="false"> Filter By
                            <i class="fa fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu hold-on-click dropdown-checkboxes float-end filter-checbox">
                            <label class="mt-checkbox mt-checkbox-outline">
                                <input type="checkbox" value="rx"> Rx Lenses
                                <span></span>
                            </label>
                            <label class="mt-checkbox mt-checkbox-outline">
                                <input type="checkbox" value="stock"> Stock Lens
                                <span></span>
                            </label>
                            <label class="mt-checkbox mt-checkbox-outline">
                                <input type="checkbox" value="consumables"> Consumables
                                <span></span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-data-container">
                    @include('frontend.auth.orders.includes.all', compact('orders', 'pageCount'))
                </div>
                <div class="dt-more-container text-center">
                    <button type="button" class="btn blue mt-ladda-btn ladda-button btn-outline btn-circle" id="load-more-btn" data-style="slide-up" data-spinner-color="#333" data-attr="table-data-container" <?= (!$orders->hasMorePages()) ? 'disabled' : '' ?>>
                        <span class="ladda-label"> <i class="icon-arrow-down"></i>  Load More</span>
                        <span class="ladda-spinner"></span>
                    </button>
                </div>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>
@endsection