@extends('frontend.layouts.split')
@section('content')
<div class="col-md-12">
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption">
                <span class="caption-subject font-dark bold uppercase">{{$order->getType()}} Order</span>
            </div>
        </div>
        <div class="portlet-body">
            <div class="">
                <h1>Thank you for your Order</h1>
                Your Order Number <strong>{{$order->getOrderNumber()}}</strong> has been placed.<br>
                <div id="body-text">
                    If you are sending the frame for edging, please <a href="javascript:void(0);" data-url="{{route('frontend.user.orders.print',$order)}}" class="print_order-btn">print the order</a> and attach the bottom part of the printout with the frame for reference.
                    <br><br> <br>    
                    Made an Error on this order? 
                    <a href="{{ route('frontend.user.orders') }}?order={{ $order->id }}">
                        Request Change
                    </a> 
                </div>
            </div>
            @if(!$order->is_feedback)
                <div id="feedback-section" class="feebback d-flex">
                    <h4><strong>How was your Ordering Experience?</strong></h4>
                    <textarea id="feedback-text" cols="100" rows="6" placeholder="Your feedback makes a difference. Let us know how we can improve your ordering experience."></textarea>
                    <button onclick="submitOrderFeedback()" class="btn blue text-uppercase" style="margin-top: 10px;">Send Feedback</button>
                </div>
            @endif
            <div id="feedback-success-message" style="display: none;">
                <h4 style="color: #009900;">Thank you for your feedback!</h4>
            </div>
            <div class="text-center" style="margin-top: 50px;">
                <button class="btn btn-danger print_order-btn text-uppercase" data-url="{{route('frontend.user.orders.print',$order)}}">Print Order</button>
                <a class="btn blue text-uppercase" href="{{ route('frontend.user.orders') }}?order={{ $order->id }}&tab=view">View Order</a>
                @php
                    $nextOrderRoute = 'frontend.user.new-rx-lens-order';
                    if ($order->type === 'stock') {
                        $nextOrderRoute = 'frontend.user.new-stock-lens-order';
                    } elseif ($order->type === 'consumables') {
                        $nextOrderRoute = 'frontend.user.new-consumables-lens-order';
                    }
                @endphp
                <a class="btn btn-warning text-uppercase" href="{{ route($nextOrderRoute) }}">Place Next Order</a>
            </div>
        </div>
    </div>
</div>
@endsection
@push('after-scripts')
<script>
        function submitOrderFeedback() {
            let feedbackText =  document.querySelector('#feedback-text');
            let feedbackValue = feedbackText.value.trim();
            let sendFeedbackButton = document.querySelector('.btn.blue.text-uppercase');
            let errorMessage = document.createElement('div');
            errorMessage.style.color = 'red';
            errorMessage.style.marginTop = '10px';
            errorMessage.style.transition = 'opacity 0.5s';
            errorMessage.innerText  = 'Feedback cannot be empty';
            
            if(feedbackValue == '') {
                feedbackText.parentNode.insertBefore(errorMessage, feedbackText.nextSibling);
                setTimeout(() => {
                    errorMessage.style.opacity = '0';
                    setTimeout(() => {
                        errorMessage.remove();
                    }, 500);
                }, 1000);
            } else {
                sendFeedbackButton.disabled = true;
                fetch('{{ route('frontend.user.orders.orderFeedback') }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({ feedback: feedbackValue, orderId: {{$order->id}}  })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const element = document.getElementById('feedback-section');
                        element.style.cssText = 'display: none !important';
                        document.getElementById('feedback-success-message').style.display = 'block';
                        // toastr.success(data.message);
                        feedbackText.value = '';
                        setTimeout(() => {
                            document.getElementById('feedback-success-message').style.display = 'none';
                        }, 2000);
                    } else {
                        toastr.error(data.message || "Failed to submit feedback. Please try again later.");
                    }
                    sendFeedbackButton.disabled = false;
                })
                .catch(error => {
                    sendFeedbackButton.disabled = false;
                });
            }
        }
</script>
@endpush
