<?php
    use App\Models\Backend\UserSettings;
    
    $userSettings = UserSettings::getSettings();
    ?>
<input type="hidden" name="data[rx][distance][right_sph_new]" id="right_sph_new" value="">
<input type="hidden" name="data[rx][distance][left_sph_new]" id="left_sph_new" value="">
<div class="form-body form-container rx-form-container">
    <h4 class="form-section bold m-0" style="margin-bottom:15px;">Patient Reference</h4>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group form-md-line-input form-md-floating-label">
                    {{ html()->text('first_name')
                    ->class('form-control required')
                    ->attribute('name', 'data[first_name]')
                    ->attribute('maxlength', 191)
                    ->autofocus() }}
                    {{ html()->label('First Name <span class="label-asterick">*</span>')->class('control-label')->for('data[first_name]') }}
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group form-md-line-input form-md-floating-label">
                    {{ html()->text('last_name')
                    ->class('form-control required')
                    ->attribute('maxlength', 191)
                    ->attribute('name', 'data[last_name]')
                    ->autofocus() }}
                    {{ html()->label('Last Name <span class="label-asterick">*</span>')->class('control-label')->for('data[last_name]') }}
                </div>
            </div>
           
    </div>
    <div class="row">
            <div class="col-md-2">
                <div class="md-checkbox-list single-checkbox">
                    <div class="md-checkbox">
                        <input type="checkbox" id="is_multipair" class="md-check" name="data[is_multipair]" data-attr="is_multipair">
                        <label class="control-label" for="is_multipair">
                        <span></span>
                        <span class="check"></span>
                        <span class="box"></span> Multi-Pair </label>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group form-md-line-input form-md-floating-label multipair_ref-container" style="margin-top: 18px !important;display: none;">
                    <select class="form-control edited select2_fixed" data-placeholder="" name="data[multipair_ref]" id="multipair_ref" data-name="multipair_ref" data-allow-clear="true" data-tags="true">
                        @php
                        $multiPlairList = auth()->user()->getMultiPlairList();
                        @endphp
                        @if(!empty($multiPlairList))
                        <option></option>
                        @foreach ($multiPlairList as $key => $value)
                        <option value="{{ $value }}">{{ $value }}</option>
                        @endforeach
                        @else
                        <option value=""></option>
                        @endif
                    </select>
                    <label class="control-label" for="data[multipair_ref]">Enter Reference for first pair</label>
                </div>
            </div>
            <div class="col-md-2">
                <div class="md-checkbox-list single-checkbox">
                    <div class="md-checkbox">
                        <input type="checkbox" id="package" class="md-check" name="data[package]" data-attr="package">
                        <label class="control-label" for="package">
                        <span></span>
                        <span class="check"></span>
                        <span class="box"></span> Package </label>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group form-md-line-input form-md-floating-label package-container" style="margin-top: 18px !important;display: none;">
                    <select class="form-control edited select2_fixed" data-placeholder="" name="data[package]" id="packageList" data-name="packages" data-allow-clear="false" data-tags="false">
                        <option></option>
                    </select>
                    <label class="control-label" for="data[package]">Select Package</label>
                </div>
            </div>
    </div>
    <h4 class="form-section bold">Lens</h4>
    <div class="row shadow p-b-10 p-t-10 rx-section">
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][lens_type]">Lens Type</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="1" id="lens_type" name="data[lens][lens_type]" data-name="lens_type" size="5" data-attr="lens_type">
                            <!-- @foreach($combinationArray['lens_type'] as $key =>$value)
                                <option value="{{ $key }}">{{ $value['label'] }}</option>
                                @endforeach -->
                        </select>
                    </div>
                </div>
            </div>
            <!-- <div class="col-md-12 clearfix" style="padding-bottom: 9px;" id="aspheric">
                <div class="md-checkbox-list">
                    <div class="md-checkbox">
                        <input type="checkbox" id="lens_information" class="md-check" name="data[lens][aspheric]">
                        <label class="control-label" for="lens_information">
                            <span></span>
                            <span class="check"></span>
                            <span class="box"></span> {{ $combinationArray['lens_information']['aspheric']['label'] }} </label>
                    </div>
                </div>
                </div> -->
        </div>
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][sub_type]">Sub-Type</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="2" id="sub_type" data-name="sub_type" name="data[lens][sub_type]" size="5" data-attr="sub_type">
                            @foreach($combinationArray['lens_information']['sub_type'] as $key =>$value)
                            <option value="{{ $key }}">{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <!-- <div class="col-md-4 mid-section lens-options" style="height: 222px;">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="lens_type">Lens Manufacturer</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                    <select class="form-control lens-data is-required" data-index="3" id="lens_manufacturer" data-name="lens_manufacturer" name="data[lens][lens_manufacturer]" size="5">
                        @foreach($combinationArray['lens_information']['lens_manufacturer'] as $key =>$value)
                            <option value="{{ $key }}">{{ $value }}</option>
                        @endforeach
                    </select>
                    </div>
                </div>
            </div>
            </div>  -->
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][lens_name]">Lens Name</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="4" id="lens_name" data-name="lens_name" name="data[lens][lens_name]" size="5" data-attr="lens_name">
                            @foreach($combinationArray['lens_information']['lens_name'] as $key =>$value)
                            <option value="{{ $key }}">{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <!-- <div class="col-md-4 mid-section lens-options" style="height: 170px;">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="lens_type">Base Curve</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                    <select class="form-control lens-data is-required" data-index="5" id="base_curve" data-name="base_curve" name="data[lens][base_curve]">
                        @foreach($combinationArray['lens_information']['base_curve'] as $key =>$value)
                            <option value="{{ $key }}">{{ $value }}</option>
                        @endforeach
                    </select>
                    </div>
                </div>
            </div>
            </div>    -->
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][lens_material]">Material</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="6" id="lens_material" data-name="lens_material" name="data[lens][lens_material]" size="5" data-attr="lens_material">
                            @foreach($combinationArray['lens_information']['lens_material'] as $key =>$value)
                            <option value="{{ $key }}">{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][lens_filter]">Filter</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="7" id="lens_filter" data-name="lens_filter" name="data[lens][lens_filter]" size="5" data-attr="lens_filter">
                            @foreach($combinationArray['lens_information']['lens_filter'] as $key =>$value)
                            <option value="{{ $key }}">{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][lens_colour]" id="label-colour">Colour</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="8" id="lens_colour" data-name="lens_colour" name="data[lens][lens_colour]" size="5" data-attr="lens_colour">
                            @foreach($combinationArray['lens_information']['lens_colour'] as $key =>$value)
                            <option value="{{ $key }}">{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="preview-large" style="top:initial !important;text-align:right;"></div>
            </div>
        </div>
        <!-- <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="lens_type">Coating Manufacturer</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                    <select class="form-control lens-data is-required" data-index="9" id="coating_made" data-name="coating_made" name="data[lens][coating_made]" size="5">
                        @foreach($combinationArray['lens_information']['coating_made'] as $key =>$value)
                            <option value="{{ $key }}">{{ $value }}</option>
                        @endforeach
                    </select>
                    </div>
                </div>
            </div>
            </div>   -->
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][coating_name]">Coating</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="10" id="coating_name" data-name="coating_name" name="data[lens][coating_name]" size="5" data-attr="coating_name">
                            @foreach($combinationArray['lens_information']['coating_name'] as $key =>$value)
                            <option value="{{ $key }}">{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 mid-section lens-options">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <label class="control-label" for="data[lens][coating_colour]">Coating Colour</label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    <div class="form-group">
                        <select class="form-control lens-data is-required" data-index="11" id="coating_colour" data-name="coating_colour" name="data[lens][coating_colour]" size="5" data-attr="coating_colour">
                            @foreach($combinationArray['lens_information']['coating_colour'] as $key =>$value)
                            <option value="{{ $key }}">{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="preview-large coating-preview-color" style="top:initial !important;right: -110px;bottom: 10px;"></div>
            </div>
        </div>
    </div>
    @foreach($combinationArray['lens_type'] as $key =>$value)
    @if(!empty($value['options']))
    <div class="row p-t-20 initHide chide rx-section" id="{{ $key }}">
        <div class="col-md-12">
            <div class="clearfix">
                <div class="btn-group btn-group-circle lens_type lens_type_sv w-100" data-toggle="buttons">
                    @foreach($value['options'] as $key2 =>$value2)
                    <label class="btn btn-secondary btn-segment_choice" style="width:<?= 100/count($value['options']) ?>%;" data-index="{{ $key }}">
                        <input type="radio" class="toggle" name="data[lens][lens_type][{{$key}}]" value="{{ $key2 }}">
                        <div class="label-txt">{{ $value2 }} </div>
                    </label>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    @endif
    @endforeach
    <div class="row shadow p-b-10 p-t-10 rx-section">
        <div class="col-md-12 mid-section left_space">
            <h4 class="form-section bold title">Rx</h4>
        </div>
        <!-- Distance Start Section -->
        <div class="col-md-12 mid-section left_space">
            <!-- <h5>Distance</h5> -->
            <div class="row">
                <div class="labels-indicator">
                    <a href="javascript:void(0);" tabindex="-1">
                        <h3><span class="badge bg-primary ind-label">R</span></h3>
                    </a>
                </div>
                @foreach($combinationArray['rx']['distance'] as $key =>$value)
                @if($value['type'] == 'dropdown')
                @if($value['single'])
                <div class="{{ $value['class'] }}" id="right-{{ $key }}">
                    <div class="form-group form-md-line-input form-md-floating-label single-item">
                        <select class="form-control edited trigger-value select2_fixed single-field {{ isset($value['inputClass']) ? $value['inputClass'] : '' }}" data-placeholder="" data-trigger="r_sph,r_cyl" name="{{ $value['name_base'] }}[right_{{ $key }}]" id="right_{{ $key }}" data-name="{{ $value['data-name'] }}" data-required_if="{{ $value['required_if'] }}" data-allow-clear="{{ $value['allow-clear'] }}">
                            @if(!empty($value['values']))
                            @foreach ($value['values'] as $key2 => $value2)
                            <option value="{{ $key2 }}" <?= ($key2 == '50') ? 'selected' : '' ?>>{{ $value2 }}</option>
                            @endforeach
                            @else
                            <option value=""></option>
                            @endif
                        </select>
                        <label class="control-label" for="{{ $value['name_base'] }}[right_{{ $key }}]">{{ $value['label'] }}</label>
                    </div>
                </div>
                @else
                <div class="{{ $value['class'] }}" id="right-{{ $key }}">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        <select class="form-control edited trigger-value select2_fixed {{ isset($value['inputClass']) ? $value['inputClass'] : '' }}" data-placeholder="" data-trigger="r_sph,r_cyl" name="{{ $value['name_base'] }}[right_{{ $key }}]" id="right_{{ $key }}" data-name="{{ $value['data-name'] }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}" data-required_if="{{ $value['required_if'] }}" data-allow-clear="{{ $value['allow-clear'] }}">
                            @if(!empty($value['values']))
                            @foreach ($value['values'] as $key2 => $value2)
                            <option value="{{ $key2 }}" <?= ($key2 == '50') ? 'selected' : '' ?>>{{ $value2 }}</option>
                            @endforeach
                            @else
                            <option value=""></option>
                            @endif
                        </select>
                        <label class="control-label" for="{{ $value['name_base'] }}[right_{{ $key }}]">{{ $value['label'] }}</label>
                    </div>
                </div>
                @endif
                @elseif($value['type'] != 'label')
                <div class="{{ $value['class'] }}" id="right-{{ $key }}">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        @if(!empty($value['symbol']))
                        <span class="input-symbol" style="display:none;">{{$value['symbol']}}</span>
                        @endif
                        @if($value['indicator'])
                        <span class="input-m-indicator" style="display:none;"></span>
                        @endif
                        <input type="{{ $value['type']}}" class="form-control crawl-mx numeric-value distance-input add-symbol" data-attr="r_{{$key}}" name="{{ $value['name_base'] }}[right_{{ $key }}]" data-name="{{ $value['data-name'] }}" step="{{ $value['step'] }}" id="right_{{ $key }}" data-pad="{{ $value['pad'] }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}" data-required_if="{{ $value['required_if'] }}" data-allow-clear="{{ $value['allow-clear'] }}">
                        <label class="control-label" for="{{ $value['name_base'] }}[right_{{ $key }}]">{{ $value['label'] }}</label>
                    </div>
                </div>
                @else
                <div class="{{ $value['class'] }}" id="right-{{ $key }}">
                    <h4><span class="badge bg-warning">0</span></h4>
                </div>
                @endif
                @endforeach
            </div>
            <div class="row" style="height:28px;">
                <div class="labels-indicator labels-indicator-middle">
                    <!-- <a href="javascript:void(0);" class="copy-all-r-l" tabindex="-1">
                        <h4><span class="label label-danger ind-middle-label">OU</span></h4>
                        </a> -->
                </div>
                <?php $count = 0; ?>
                @foreach($combinationArray['rx']['distance'] as $key =>$value)
                @if($value['type'] != 'label')
                @if(!$value['single'])
                <div class="{{ $value['class'] }} text-center copy-distance" id="copy-{{ $key }}">
                    <a href="javascript:void(0);" tabindex="-1">
                    <i
                        class="fa fa-arrow-down"></i>
                    </a>
                </div>
                @else
                <div class="{{ $value['class'] }} text-center copy-distance v-hidden"></div>
                @endif
                @endif
                @endforeach
            </div>
            <div class="row">
                <div class="labels-indicator">
                    <a href="javascript:void(0);" tabindex="-1">
                        <h3><span class="badge bg-primary ind-label">L</span></h3>
                    </a>
                </div>
                <!-- <div class="col-md-2">
                    <h3><span class="label label-info ind-label">L</span></h3>
                    </div> -->
                @foreach($combinationArray['rx']['distance'] as $key =>$value)
                @if($value['type'] == 'dropdown')
                @if(!$value['single'])
                <div class="{{ $value['class'] }}" id="left-{{ $key }}">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        <select class="form-control edited trigger-value select2_fixed {{ isset($value['inputClass']) ? $value['inputClass'] : '' }}" data-placeholder="" data-trigger="r_sph,r_cyl" name="{{ $value['name_base'] }}[left_{{ $key }}]" id="left_{{ $key }}" data-name="{{ $value['data-name'] }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}" data-required_if="{{ $value['required_if'] }}" data-allow-clear="{{ $value['allow-clear'] }}">
                            <!-- <option value=""></option> -->
                            @foreach ($value['values'] as $key2 => $value2)
                            <option value="{{ $key2 }}" <?= ($key2 == '50') ? 'selected' : '' ?>>{{ $value2 }}</option>
                            @endforeach
                        </select>
                        <label class="control-label" for="{{ $value['name_base'] }}[left_{{ $key }}]">{{ $value['label'] }}</label>
                    </div>
                </div>
                @else
                <div class="{{ $value['class'] }}" id="left-{{ $key }}"></div>
                @endif
                @elseif($value['type'] != 'label')
                <div class="{{ $value['class'] }}" id="left-{{ $key }}">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        @if(!empty($value['symbol']))
                        <span class="input-symbol" style="display:none">{{$value['symbol']}}</span>
                        @endif
                        @if($value['indicator'])
                        <span class="input-m-indicator" style="display:none;"></span>
                        @endif
                        <input type="{{ $value['type']}}" class="form-control crawl-mx numeric-value distance-input add-symbol" data-attr="l_{{$key}}" data-name="{{ $value['data-name'] }}" name="{{ $value['name_base'] }}[left_{{ $key }}]" step="{{ $value['step']}}" id="left_{{ $key }}" data-pad="{{ $value['pad'] }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}" data-required_if="{{ $value['required_if'] }}" data-allow-clear="{{ $value['allow-clear'] }}">
                        <label class="control-label" for="{{ $value['name_base'] }}[left_{{ $key }}]">{{ $value['label'] }}</label>
                    </div>
                </div>
                @else
                <div class="{{ $value['class'] }}" id="left-{{ $key }}">
                    <h4><span class="badge bg-warning">0</span></h4>
                </div>
                @endif
                @endforeach
            </div>
        </div>
        <!-- Distance END Section -->
        <!-- Extended info Section -->
        <div class="col-md-12 mid-section left_space rx-container-default_height">
            <!-- <div class="row">
                <div class="col-md-8 no-padding">
                        <h5>Extended Info</h5>
                </div>
                </div> -->
            <div class="extended-info-container" id="extended-info_module">
                <div class="row" id="right-extended-info-row">
                    <div class="labels-indicator">
                        <a href="javascript:void(0);" tabindex="-1">
                            <h3><span class="badge bg-primary ind-label">R</span></h3>
                        </a>
                    </div>
                    @foreach($combinationArray['rx']['extended_info'] as $key =>$value)
                    @if($value['type'] == 'dropdown')
                    @if(isset($value['button']) && $value['button'])
                    <div class="col-sm p-2 show_hide-container" style="max-width:15%;" id="{{ $value['button-class'] }}_field-btn">
                        <a href="javascript:;" class="btn btn-info btn-circle show_hide-abtn single-item" data-element="{{ $value['button-class'] }}_field-container" tabindex="0" style="right: 0%;top: 56px;"><i class="fa fa-plus"></i> {{ $value['button-label'] }}</a>
                    </div>
                    @endif
                    @if($value['single'])
                    <div class="{{ $value['class'] }}" id="right-{{ $key }}">
                        <div class="form-group form-md-line-input form-md-floating-label single-item">
                            <select class="form-control {{ $key }} {{ $value['ddl_class'] }} edited single-field" data-placeholder="" name="{{ $value['name_base'] }}[right_{{ $key }}]" data-name="{{ $value['data-name'] }}" data-attr="r_{{$key}}" id="right_{{ $key }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}">
                                <option value=""></option>
                                @foreach ($value['values'] as $key2 => $value2)
                                <option value="{{ $key2 }}">
                                    {{ $value2 }}
                                </option>
                                @endforeach
                            </select>
                            <label class="control-label" for="{{ $value['name_base'] }}[right_{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @else
                    <div class="{{ $value['class'] }}" id="right-{{ $key }}" style="display: {{ isset($value['button']) && $value['button'] ? 'none' : ''  }}">
                        @if(isset($value['button']) && $value['button'])
                        <div class="text-right showhide-container-btn" style="padding: 0px;">
                            <a href="javascript:void(0);" class="" data-attr="{{ $value['button-class'] }}_field" title="Hide" tabindex="0"><i class="fa fa-remove color-red"></i></a>
                        </div>
                        @endif
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control {{ $key }} {{ $value['ddl_class'] }} edited" data-placeholder="" name="{{ $value['name_base'] }}[right_{{ $key }}]" data-name="{{ $value['data-name'] }}" data-attr="r_{{$key}}" id="right_{{ $key }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}" data-allow-clear="{{ $value['allow-clear'] }}">
                                <option value=""></option>
                                @foreach ($value['values'] as $key2 => $value2)
                                <option value="{{ $key2 }}">
                                    {{ $value2 }}
                                </option>
                                @endforeach
                            </select>
                            <label class="control-label" for="{{ $value['name_base'] }}[right_{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @endif
                    @else
                    <div class="col-sm <?= (!$value['display']) ? 'hide_'.$key.' hide' : '' ?>" id="right-{{ $key }}">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            @if(!empty($value['symbol']))
                            <span class="input-symbol" style="display:none">{{$value['symbol']}}</span>
                            @endif
                            <input type="{{$value['type']}}" class="form-control crawl-mx numeric-value add-symbol {{ $key }}" data-attr="r_{{$key}}" data-name="{{ $value['data-name'] }}" name="{{ $value['name_base'] }}[right_{{ $key }}]" data-pad="{{ $value['pad'] }}" step="{{ $value['step'] }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}" id="right_{{ $key }}">
                            <label class="control-label" for="{{ $value['name_base'] }}[right_{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @endif
                    @endforeach
                </div>
                <div class="row">
                    <div class="labels-indicator labels-indicator-middle">
                        <!-- <a href="javascript:void(0);" class="copy-all-r-l" tabindex="-1">
                            <h4><span class="label label-danger ind-middle-label">OU</span></h4>
                            </a> -->
                    </div>
                    @foreach($combinationArray['rx']['extended_info'] as $key =>$value)
                    @if(!$value['single'])
                    <div class="col-sm text-center copy-distance <?= (!$value['display']) ? 'hide_'.$key.' hide' : '' ?>" id="copy-{{ $key }}">
                        <a href="javascript:void(0);" tabindex="-1">
                        <i
                            class="fa fa-arrow-down"></i>
                        </a>
                    </div>
                    @else
                    <div class="{{ $value['class'] }} text-center copy-distance v-hidden"></div>
                    @endif
                    @endforeach
                </div>
                <div class="row" id="left-extended-info-row">
                    <div class="labels-indicator">
                        <a href="javascript:void(0);" tabindex="-1">
                            <h3><span class="badge bg-primary ind-label">L</span></h3>
                        </a>
                    </div>
                    @foreach($combinationArray['rx']['extended_info'] as $key =>$value)
                    @if($value['type'] == 'dropdown')
                    @if(!$value['single'])
                    <div class="{{ $value['class'] }}" id="left-{{ $key }}" style="display: {{ isset($value['button']) && $value['button'] ? 'none' : ''  }}">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control {{ $key }} {{ $value['ddl_class'] }} edited" data-placeholder="" name="{{ $value['name_base'] }}[left_{{ $key }}]" data-name="{{ $value['data-name'] }}" id="left_{{ $key }}" data-attr="l_{{$key}}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}" data-allow-clear="{{ $value['allow-clear'] }}">
                                <option value=""></option>
                                @foreach ($value['values'] as $key2 => $value2)
                                <option value="{{ $key2 }}">
                                    {{ $value2 }}
                                </option>
                                @endforeach
                            </select>
                            <label class="control-label" for="{{ $value['name_base'] }}[left_{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @else
                    <div class="{{ $value['class'] }}" id="left-{{ $key }}"></div>
                    @endif
                    @else
                    <div class="col-sm<?= (!$value['display']) ? 'hide_'.$key.' hide' : '' ?>" id="left-{{ $key }}">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            @if(!empty($value['symbol']))
                            <span class="input-symbol" style="display:none">{{$value['symbol']}}</span>
                            @endif
                            <span class="input-m-indicator" style="display:none;"></span>
                            <input type="{{$value['type']}}" class="form-control crawl-mx numeric-value add-symbol {{ $key }}" data-attr="l_{{$key}}" name="{{ $value['name_base'] }}[left_{{ $key }}]" data-pad="{{$value['pad'] }}" step="{{ $value['step'] }}" id="left_{{ $key }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}" data-name="{{ $value['data-name'] }}">
                            <label class="control-label" for="{{ $value['name_base'] }}[left_{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @endif
                    @endforeach
                </div>
            </div>
        </div>
        <!-- Prism Start Section -->
        <div class="col-md-12 mid-section left_space" id="prism_container" style="position: relative;">
            <div class="row cancel-button">
                <!-- <div class="col-md-8 no-padding">
                    <h5>Prism</h5>
                    </div> -->
                <div class="col-md-12 text-right remove_prism-content" style="display: none;padding: 0;">
                    <a href="javascript:void(0);" id="remove_prism-link" title="Remove Prism" tabindex="-1"><i class="fa fa-remove color-red"></i></a>
                </div>
            </div>
            <div class="prism-container" style="display: none;">
                <div class="row">
                    <div class="labels-indicator">
                        <a href="javascript:void(0);" tabindex="-1">
                            <h3><span class="badge bg-primary ind-label">R: Prism</span></h3>
                        </a>
                    </div>
                    <div class="col-md-2 col-6"></div>
                    @foreach($combinationArray['rx']['prism'] as $key =>$value)
                    @if($value['type'] == 'dropdown')
                    <div class="col-md-2 col-6 prism-list p-2 {{ $value['class'] }}" id="right-{{ $key }}">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control prism_base select2_fixed edited {{ isset($value['inputClass']) ? $value['inputClass'] : '' }}" data-placeholder="" name="data[rx][prism][right_{{ $key }}]" id="right_{{ $key }}" data-attr="r_{{ $key }}" data-name="{{ $value['data-name'] }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}" data-empty-check="{{ $value['empty_check'] }}" data-required_if="{{ $value['required_if'] }}">
                                <option value=""></option>
                                @foreach ($value['values'] as $key2 => $value2)
                                <option value="{{ $key2 }}">{{ $value2 }}</option>
                                @endforeach
                            </select>
                            <label class="control-label" for="data[rx][prism][right_{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @else
                    <div class="col-md-2 col-6 prism-list" id="right-{{ $key }}">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            @if(!empty($value['symbol']))
                            <span class="input-symbol" style="display:none">{{$value['symbol']}}</span>
                            @endif
                            <span class="input-m-indicator" style="display:none;"></span>
                            <input type="{{$value['type']}}" class="form-control crawl-mx numeric-value add-symbol" data-attr="r_{{$key}}" data-name="{{ $key }}" name="data[rx][prism][right_{{ $key }}]" data-pad="{{ $value['pad'] }}" step="{{ $value['step'] }}" id="right_{{ $key }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}">
                            <label class="control-label" for="data[rx][prism][right_{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @endif
                    @endforeach
                </div>
                <div class="row">
                    <div class="labels-indicator labels-indicator-middle">
                        <!-- <a href="javascript:void(0);" class="copy-all-r-l" tabindex="-1">
                            <h4><span class="label label-danger ind-middle-label">OU</span></h4>
                            </a> -->
                    </div>
                    <div class="col-md-2 col-6 text-center copy-distance"></div>
                    @foreach($combinationArray['rx']['prism'] as $key =>$value)
                    <div class="col-md-2 col-6 text-center copy-distance" id="copy-{{ $key }}">
                        <a href="javascript:void(0);" tabindex="-1">
                        <i
                            class="fa fa-arrow-down"></i>
                        </a>
                    </div>
                    @endforeach
                </div>
                <div class="row">
                    <div class="labels-indicator">
                        <a href="javascript:void(0);" tabindex="-1">
                            <h3><span class="badge bg-primary ind-label">L: Prism</span></h3>
                        </a>
                    </div>
                    <div class="col-md-2 col-6"></div>
                    @foreach($combinationArray['rx']['prism'] as $key =>$value)
                    @if($value['type'] == 'dropdown')
                    <div class="col-md-2 col-6 prism-list p-2 {{ $value['class'] }}" id="left-{{ $key }}">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control prism_base select2_fixed edited {{ isset($value['inputClass']) ? $value['inputClass'] : '' }}" data-placeholder="" name="data[rx][prism][left_{{ $key }}]" id="left_{{ $key }}" data-attr="l_{{ $key }}" data-name="{{ $value['data-name'] }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}" data-empty-check="{{ $value['empty_check'] }}" data-required_if="{{ $value['required_if'] }}">
                                <option value=""></option>
                                @foreach ($value['values'] as $key2 => $value2)
                                <option value="{{ $key2 }}">{{ $value2 }}</option>
                                @endforeach
                            </select>
                            <label class="control-label" for="data[rx][prism][left_{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @else
                    <div class="col-md-2 col-6 prism-list" id="left-{{ $key }}">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            @if(!empty($value['symbol']))
                            <span class="input-symbol" style="display:none">{{$value['symbol']}}</span>
                            @endif
                            <span class="input-m-indicator" style="display:none;"></span>
                            <input type="{{$value['type']}}" class="form-control crawl-mx numeric-value add-symbol" data-attr="l_{{$key}}" data-name="{{ $key }}" name="data[rx][prism][left_{{ $key }}]" data-pad="{{ $value['pad'] }}" step="{{ $value['step'] }}" id="left_{{ $key }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}">
                            <label class="control-label" for="data[rx][prism][left_{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @endif
                    @endforeach
                </div>
            </div>
            <div class="show-hide-btn">
                <a href="javascript:;" class="btn btn-info btn-circle" id="add_prism-btn" tabindex="0"><i class="fa fa-plus"></i> Add Prism</a>
            </div>
        </div>
        <!-- Prism End Section -->
        <div class="col-md-6 mid-section left_space chide" id="final_rx" style="height: 188px">
            <div class="row">
                <div class="col-md-8 no-padding">
                    <h5>Final Rx</h5>
                </div>
            </div>
            <div class="extended-info-container">
                <div class="row">
                    <div class="labels-indicator">
                        <a href="javascript:void(0);" tabindex="-1">
                            <h3><span class="badge bg-primary ind-label">R</span></h3>
                        </a>
                    </div>
                    @foreach($combinationArray['rx']['final_rx'] as $key =>$value)
                    <div class="{{ $value['class'] }}" id="right-{{ $key }}">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            @if(!empty($value['symbol']))
                            <span class="input-symbol" style="display:none">{{$value['symbol']}}</span>
                            @endif
                            <input type="text" class="form-control crawl-mx numeric-value add-symbol" id="right-{{ $key }}-fr" data-name="{{ $key }}" name="data[rx][final_rx][right_{{ $key }}]" data-pad="{{ $value['pad'] }}" readonly>
                            <label class="control-label" for="data[rx][final_rx][right_{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @endforeach
                </div>
                <div class="row">
                    <div class="labels-indicator">
                        <a href="javascript:void(0);" tabindex="-1">
                            <h3><span class="badge bg-primary ind-label">L</span></h3>
                        </a>
                    </div>
                    @foreach($combinationArray['rx']['final_rx'] as $key =>$value)
                    <div class="{{ $value['class'] }}" id="left-{{ $key }}">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            @if(!empty($value['symbol']))
                            <span class="input-symbol" style="display:none">{{$value['symbol']}}</span>
                            @endif
                            <input type="text" class="form-control crawl-mx numeric-value add-symbol" name="data[rx][final_rx][left_{{ $key }}]" id="left-{{ $key }}-fr" data-pad="{{ $value['pad'] }}" readonly>
                            <label class="control-label" for="data[rx][final_rx][left_{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
        <!-- Distance End Section -->
        <div class="col-md-12 p-0">
            <!-- Shorter Corridor Section -->
            <!-- div class="col-md-3" id="use_shorter_corridor">
                <div class="row">
                    <div class="col-md-8 no-padding">
                        <h5></h5>
                    </div>
                </div>
                <div class="reading-container">
                    <div class="row">
                        <div class="col-md-12 input-group  shorter-coridor_padding">
                            <div class="col-md-12">
                                 <div class="md-checkbox-list single-checkbox">
                                    <div class="md-checkbox">
                                        <input type="checkbox" class="md-check" name="data[rx][use_shorter_corridor]" id="use_shorter_corridor1">
                                        <label class="control-label" for="use_shorter_corridor1">
                                            <span></span>
                                            <span class="check"></span>
                                            <span class="box"></span> {{ $combinationArray['rx']['use_shorter_corridor']['label'] }} </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                </div> -->
            <!-- Distance End Section -->
            <!-- Special Info info Section -->
            <div class="col-md-12 mid-section" id="special_info">
                <!-- <div class="row">
                    <div class="col-md-8 no-padding">
                        <h5>Special Info</h5>
                    </div>
                    </div> -->
                <div class="extended-info-container">
                    <div class="row">
                        @foreach($combinationArray['rx']['special_info'] as $key =>$value)
                        @if($value['type'] == 'dropdown')
                        <div class="col-md-4 col-4 p-2 crawl-cs-ddl chide" id="{{ $key }}">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <select class="form-control prism_base select2_fixed edited {{ isset($value['inputClass']) ? $value['inputClass'] : '' }}" data-placeholder="" name="data[rx][special_info][{{ $key }}]" id="{{ $key }}" data-attr="{{ $key }}" data-name="{{ $value['data-name'] }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}">
                                    <option value=""></option>
                                    @foreach ($value['values'] as $key2 => $value2)
                                    <option value="{{ $key2 }}">{{ $value2 }}</option>
                                    @endforeach
                                </select>
                                <label class="control-label" for="data[rx][special_info][{{ $key }}]">{{ $value['label'] }}</label>
                            </div>
                        </div>
                        @else
                        <div class="col-md-4" id="{{ $key }}">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                @if(!empty($value['symbol']))
                                <span class="input-symbol" style="display:none">{{$value['symbol']}}</span>
                                @endif
                                <!-- <span class="input-m-indicator" style="display:none;"></span> -->
                                <input type="{{ $value['type'] }}" class="form-control crawl-mx numeric-value distance-input add-symbol edited" data-attr="{{$key}}" name="data[rx][special_info][{{ $key }}]" data-pad="{{ $value['pad'] }}" max="{{ $value['max'] }}" min="{{ $value['min'] }}" data-name="{{ $value['data-name'] }}" id="{{ $key }}">
                                <label class="control-label" for="data[rx][special_info][{{ $key }}]">{{ $value['label'] }}</label>
                            </div>
                        </div>
                        @endif
                        @endforeach
                    </div>
                </div>
            </div>
            <!-- SPecial Info End Section -->
        </div>
    </div>
    <div class="row shadow p-b-10 p-t-10 rx-section frame-section">
        <div class="col-md-12 mid-section left_space">
            <h4 class="form-section bold title">Frame</h4>
        </div>
        <div class="col-md-12 mid-section">
            <div class="row">
                <div class="col-md-12 no-padding mt-1">
                    <label class="control-label" for="data[frame][job_type]">Job Type <span class="label-asterick job_type-test">*</span></label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100 job_type_group" data-toggle="buttons">
                    @foreach($combinationArray['frame']['job_type'] as $key =>$value)
                    <label class="btn btn-secondary btn-segment_choice btn-frame_job_type_choice" data-index="job_type">
                        <input type="radio" class="toggle is-required" name="data[frame][job_type]" value="{{ $key }}" data-text="{!! $value['label'] !!}">
                        <div class="label-txt">{!! $value['label'] !!} </div>
                    </label>
                    @endforeach
                </div>
            </div>
            <div class="col-md-8 col-md-offset-2 chide clearfix p-b-10 mt-5" id="invoice_order_no">
                <div class="form-group form-md-line-input form-md-floating-label">
                    <!-- <input type="text" class="form-control is-required" name="data[frame][invoice_order_no]" id="invoice_order_no_field" data-attr="invoice_order_no">
                        <label class="control-label" for="data[frame][invoice_order_no]">{{ $combinationArray['frame']['invoice_order_no']['label'] }}</label> -->
                    <select class="form-control invoice_order_no select2_apply edited" data-placeholder="" name="data[frame][invoice_order_no]" data-name="invoice_order_no" id="invoice_order_no_field" data-attr="invoice_order_no" data-allow-clear="false" data-tags="true">
                        <option value=""></option>
                        @foreach ($logged_in_user->getOrdersData() as $key => $value)
                        @php
                        $orderData = $value->rxOrderModel->getShowData();
                        @endphp
                        <option value="{{ $value->getOrderNumber().', '.$value->invoice_no.', '.$value->patient }}" data-frame_type="{{ $orderData['frame']['o_frame_type'] }}" data-a="{{ $orderData['frame']['frame_size']['values'][0] }}" data-b="{{ $orderData['frame']['frame_size']['values'][1] }}" data-ed="{{ $orderData['frame']['frame_size']['values'][2] }}" data-dbl="{{ $orderData['frame']['frame_size']['values'][3] }}" 
                            data-brand="{{ $orderData['frame']['frame_info']['values']['brand'] }}"
                            data-model="{{ $orderData['frame']['frame_info']['values']['model'] }}"
                            data-colour="{{ $orderData['frame']['frame_info']['values']['colour'] }}"
                            data-size="{{ $orderData['frame']['frame_info']['values']['size'] }}"
                            >
                            {{ $value->getOrderNumber().', '.$value->invoice_no.', '.$value->patient }}
                        </option>
                        @endforeach
                    </select>
                    <label class="control-label" for="data[frame][invoice_order_no]">{{ $combinationArray['frame']['invoice_order_no']['label'] }}</label>
                </div>
            </div>
        </div>
        <div class="col-md-12 mid-section chide" id="frame_info">
            <div class="row">
                <div class="col-md-12 no-padding mt-4">
                    <label class="control-label" for="frame_info">Frame Info</label>
                </div>
            </div>
            <div class="frame_container">
                <div class="row">
                    @foreach($combinationArray['frame']['frame_info'] as $key =>$value)
                    @if($value['type'] == 'checkbox')
                    <div class="col-md-2 p-0" id="{{$key}}-container">
                        <div class="md-checkbox-list single-checkbox">
                            <div class="md-checkbox">
                                <input type="checkbox" id="{{$key}}" class="md-check" name="data[frame][frame_info][{{$key}}]" data-attr="{{$key}}">
                                <label class="control-label" for="{{$key}}">
                                <span></span>
                                <span class="check"></span>
                                <span class="box"></span> {{ $value['label'] }} </label>
                            </div>
                        </div>
                    </div>
                    @elseif($value['type'] == 'dropdown')
                    <div class="{{ $value['class'] }}" id="left-{{ $key }}">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control {{ $key }} {{ $value['ddl_class'] }} edited" data-filter="{{ $value['data-filter'] }}" data-placeholder="" name="data[frame][frame_info][{{ $key }}]" data-name="{{$key}}" id="{{ $key }}" data-attr="{{$key}}" data-allow-clear="{{ $value['allow-clear'] }}">
                                <option value=""></option>
                                @foreach ($value['values'] as $key2 => $value2)
                                <option value="{{ $key2 }}">
                                    {{ $value2 }}
                                </option>
                                @endforeach
                            </select>
                            <label class="control-label" for="data[frame][frame_info][{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @else
                    <div class="col-md-3" id="{{$key}}-container">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <input type="text" class="form-control {{ $value['inputClass'] }}" id="{{ $key }}" name="data[frame][frame_info][{{ $key }}]" data-attr="{{$key}}">
                            <label class="control-label" for="data[frame][frame_info][{{ $key }}]">{{ $value['label'] }}</label>
                        </div>
                    </div>
                    @endif
                    @endforeach
                    <div class="col-md-10 text-center help-block font-10 pof-help-text" style="display: none;"> {{ $combinationArray['frame']['frame_info']['pof']['help_text'] }} </div>
                </div>
            </div>
        </div>
        <div class="col-md-12 mid-section">
            <div class="row">
                <div class="col-md-12 no-padding mt-4">
                    <label class="control-label" for="data[frame][frame_type]">Frame Type <span class="label-asterick">*</span></label>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0">
                <div class="btn-group btn-group-circle w-100 frame_type_group" data-toggle="buttons">
                    @foreach($combinationArray['frame']['frame_type'] as $key =>$value)
                    <label class="btn btn-secondary btn-segment_choice btn-frame_type_choice" data-index="frame_type">
                        <input type="radio" class="toggle form-control is-required" name="data[frame][frame_type]" value="{{ $key }}" data-text="{!! $value['label'] !!}" id="{{ $key }}" >
                        <div class="label-txt">{{ $value['label'] }} </div>
                    </label>
                    @endforeach
                </div>
            </div>
            <div class="col-md-4 col-md-offset-3 chide clearfix p-b-10" id="ft_other">
                <div class="form-group form-md-line-input form-md-floating-label">
                    <input type="text" class="form-control" name="data[frame][ft_other]">
                    <label class="control-label" for="data[frame][ft_other]">{{ $combinationArray['frame']['ft_other']['label'] }}</label>
                </div>
            </div>
        </div>
        <div class="col-md-12 mid-section">
            <div class="row">
                <div class="col-md-12 no-padding mt-4">
                    <label class="control-label">Frame Size</label>
                </div>
            </div>
            <div class="row clearfix p-b-10">
                <!-- <div class="btn-group btn-group-circle w-100" data-toggle="buttons"> -->
                <!-- <div class="col-md-1"></div> -->
                @foreach($combinationArray['frame']['frame_size'] as $key =>$value)
                @if($value['type'] == 'dropdown')
                <div class="{{$value['class']}}" id="container-{{ $key }}">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        <select class="form-control select2_fixed edited {{ isset($value['inputClass']) ? $value['inputClass'] : '' }}" data-placeholder="" id="{{ $key }}" name="data[frame][frame_size][{{ $key }}]" data-attr="{{ $key }}" data-name="{{ $value['data-name'] }}" data-round="{{ $value['round'] }}" data-increment="{{ $value['increment'] }}">
                            <option value=""></option>
                            @foreach ($value['values'] as $key2 => $value2)
                            <option value="{{ $key2 }}" <?= ($key2 == $value['default']) ? 'selected' : '' ?>>
                                {{ $value2 }}
                            </option>
                            @endforeach
                        </select>
                        <label class="control-label" for="data[frame][frame_size][{{ $key }}]">{{ $value['label'] }}</label>
                    </div>
                </div>
                @elseif($value['type'] == 'text')
                <div class="col-md-2">
                    <div class="form-group form-md-line-input form-md-floating-label">
                        @if(!empty($value['symbol']))
                        <span class="input-symbol" style="display:none">{{$value['symbol']}}</span>
                        @endif
                        <input type="number" class="form-control  crawl-mx numeric-value add-symbol" step="{{ $value['step'] }}" data-pad="{{ $value['pad'] }}" data-name="{{ $value['data-name'] }}" id="{{ $key }}" name="data[frame][frame_size][{{ $key }}]" data-attr="{{ $key }}">
                        <label class="control-label" for="data[frame][{{ $key }}]">{{ $value['label'] }}</label>
                    </div>
                </div>
                @endif
                @endforeach
                <!-- </div> -->
            </div>
        </div>
        <div class="col-md-12 mid-section hide" id="shape">
            <div class="row">
                <div class="col-md-8 no-padding">
                    <label class="control-label">Shape <span class="label-asterick">*</span></label>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 clearfix">
                    <input type="hidden" name="data[frame][frame_size][shape_factor]" value="">
                    <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                        @foreach($combinationArray['frame']['frame_size']['shape']['values'] as $key =>$value)
                        <label class="btn btn-secondary btn-segment_choice btn-frame_shape_choice" data-index="shape">
                            <input type="radio" class="toggle" name="data[frame][frame_size][shape]" value="{{ $key }}" data-factor="{{ $value['factor'] }}" data-text="{{ $value['label'] }}" data-attr="{{ $key }}">
                            <div class="label-txt">{{ $value['label'] }} </div>
                            <img src="{{ URL::asset('assets/img/shapes') }}/{{$value['img']}}">
                        </label>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12 mid-section chide" id="modify_shape">
            <div class="row">
                <div class="col-md-8 no-padding">
                    <h5>Modify Shape</h5>
                </div>
                <div class="col-md-4 text-right p-t-10 chide" id="mshape-content-rcontent">
                    <a href="javascript:void(0);" class="remove_container-btn" data-hide="mshape-content" title="Remove Prism" tabindex="-1"><i class="fa fa-remove color-red"></i></a>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0 mshape-content chide">
                @foreach($combinationArray['frame']['modify_shape'] as $key =>$value)
                <div class="col-md-1">
                    <div class="md-checkbox-list single-checkbox">
                        <div class="md-checkbox">
                            <input type="checkbox" id="{{$key}}" class="md-check enable_disable-fields" name="data[frame][modify_shape][{{$key}}]" data-attr="{{$key}}">
                            <label class="control-label" for="{{$key}}">
                            <span></span>
                            <span class="check"></span>
                            <span class="box"></span> {{ $value['label'] }} </label>
                        </div>
                    </div>
                </div>
                <div class="col-md-5" id="container-{{$key}}">
                    @foreach($value['values'] as $key2 =>$value2)
                    @if($value2['type'] == 'dropdown')
                    <div class="{{ $value2['class'] }}" id="container-{{ $key }}">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control select2_fixed edited {{ $value2['inputClass'] }}" data-placeholder="" name="data[frame][modify_shape][{{ $key2 }}]" data-attr="{{$key2}}" data-name="{{ $value2['data-name'] }}" id="{{ $value2['data-name'] }}" data-min="{{ $value2['min'] }}" data-max="{{ $value2['max'] }}" data-step="{{ $value2['step'] }}" disabled>
                                <option value=""></option>
                                @foreach ($value2['values'] as $value3)
                                <option value="{{ $value3 }}">{{ $value3 }}</option>
                                @endforeach
                            </select>
                            <label class="control-label" for="data[frame][modify_shape][{{ $key2 }}]">{{ $value2['label'] }}</label>
                        </div>
                    </div>
                    @else
                    <div class="col-md-6 col-6">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            @if(!empty($value2['symbol']))
                            <span class="input-symbol" style="display:none">{{$value2['symbol']}}</span>
                            @endif
                            <input type="number" class="form-control numeric-value" id="{{ $key2 }}" name="data[frame][modify_shape][{{ $key2 }}]" step="{{ $value2['step'] }}" min="{{ $value2['min'] }}" max="{{ $value2['max'] }}" data-pad="{{ $value2['pad'] }}" data-round="{{ $value2['round'] }}" data-attr="{{$key2}}" readonly>
                            <label class="control-label" for="data[frame][modify_shape][{{ $key2 }}]">{{ $value2['label'] }}</label>
                        </div>
                    </div>
                    @endif
                    @endforeach
                </div>
                @endforeach
            </div>
            <div class="show-hide-btn" style="padding: 118px;padding: 33px 0;">
                <a href="javascript:;" class="btn btn-info btn-circle add_container-btn" data-show="mshape-content" tabindex="-1"><i class="fa fa-plus"></i> Add Modify Shape</a>
            </div>
        </div>
        <div class="col-md-12 mid-section updated_checkbox p-0" style="min-height:auto;">
            <div class="row">
                <div class="col-md-12 no-padding">
                    <h4 class="no-margin">
                    &nbsp</h5>
                </div>
            </div>
            <div class="col-md-12 clearfix p-0" style="padding-bottom: 14px;">
                <!-- <div class="btn-group btn-group-circle w-100" data-toggle="buttons"> -->
                <div class="row">
                    <div class="col-md-3" id="base_curve-content">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control edited trigger-value select2_fixed" data-placeholder="" data-trigger="r_sph,r_cyl" name="data[rx][extended_info][right_base_curve]" id="right_base_curve" data-name="rx_base_curve" data-placeholder="">
                                <option></option>
                            </select>
                            <label class="control-label" for="right_base_curve">Lens Base Curve</label>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="col-md-12 text-right p-0 chide" id="specify_thickness-content-rcontent">
                            <a href="javascript:void(0);" class="remove_container-btn" data-hide="specify_thickness-content" title="Remove Prism" tabindex="-1"><i class="fa fa-remove color-red"></i></a>
                        </div>
                        <div class="md-checkbox-list single-checkbox1 specify_thickness-content m-0" id="specify_thickness-content">
                            <!-- <div class="md-checkbox">
                                <input type="checkbox" id="specify_thickness" class="md-check ch_checkboxes" name="data[frame][specify_thickness]">
                                <label class="control-label" for="specify_thickness">
                                    <span></span>
                                    <span class="check"></span>
                                    <span class="box"></span> {{ $combinationArray['frame']['specify_thickness']['label'] }}
                                    <br><small class="badge badge-primary small-info">Lab will decide best thickness</small>
                                </label>
                                </div> -->
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <select class="form-control select2_fixed edited" id="specify_thickness" name="data[frame][specify_thickness][value]" data-attr="specify_thickness">
                                    <!-- <option>{{ $combinationArray['frame']['specify_thickness']['label'] }}</option> -->
                                    @foreach($combinationArray['frame']['specify_thickness']['ddl_values'] as $key =>$value)
                                    <option value="{{ $value }}">{{ $value }}</option>
                                    @endforeach
                                </select>
                                <label class="control-label" for="specify_thickness">Lens Thickness</label>
                            </div>
                        </div>
                        <div class="show-hide-btn chide" style="padding: 24px 0;height: 0px;">
                            <a href="javascript:;" class="btn btn-info btn-circle add_container-btn" data-show="specify_thickness-content" tabindex="-1">Lens Thickness</a>
                        </div>
                    </div>
                </div>
                <div class="row" style="margin-top:10px !important;">
                    <div class="col-sm chide ct_or_et-container right">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <!-- <span class="input-symbol" style="display:none;">mm</span> -->
                            <select class="form-control r_ct_or_et select2_apply edited is-required" data-placeholder="" name="data[frame][specify_thickness][r_ct_or_et]" data-name="r_ct_or_et" id="r_ct_or_et" data-attr="r_ct_or_et" data-allow-clear="true" data-tags="false" data-step="0.50" data-min="0.00" data-max="5.00" data-round="2" >
                                <option value=""></option>
                            </select>
                            <!-- <input type="number" class="form-control crawl-mx numeric-value add-symbol is-required" data-attr="r_ct_or_et" name="data[frame][specify_thickness][r_ct_or_et]" data-name="r_ct_or_et" id="r_ct_or_et" step="0.10" data-pad="" min="0.50" max="5.00" data-round="1"> -->
                            <label class="control-label" for="data[frame][specify_thickness][r_ct_or_et]">R: CT</label>
                        </div>
                    </div>
                    <div class="col-sm chide ct_or_et-container left">
                        <div class="form-group form-md-line-input form-md-floating-label">
                            <select class="form-control l_ct_or_et select2_apply edited is-required" data-placeholder="" name="data[frame][specify_thickness][l_ct_or_et]" data-name="l_ct_or_et" id="l_ct_or_et" data-attr="l_ct_or_et" data-allow-clear="true" data-tags="false" data-step="0.10" data-min="0.00" data-max="5.00" data-round="2" >
                                <option value=""></option>
                            </select>
                            <!-- <span class="input-symbol" style="display:none;">mm</span> -->
                            <!-- <input type="number" class="form-control crawl-mx numeric-value add-symbol is-required" name="data[frame][specify_thickness][l_ct_or_et]" id="l_ct_or_et" data-name="l_ct_or_et" min="0.00" step="0.10" max="5.00" data-round="1" data-pad=""> -->
                            <label class="control-label" for="data[frame][specify_thickness][l_ct_or_et]">L: CT</label>
                        </div>
                    </div>
                </div>
                @foreach($combinationArray['frame']['specify_thickness']['values'] as $key =>$value)
                <div class="col-sm <?= !$value['show'] ? 'chide' : '' ?>" id="{{ $value['name'] }}-container">
                    <div class="md-checkbox-list single-checkbox">
                        <div class="md-checkbox">
                            <input type="checkbox" id="{{ $value['name'] }}" class="md-check ch_checkboxes" name="data[frame][{{ $value['name'] }}]" data-attr="{{ $value['name'] }}">
                            <label class="control-label" for="{{ $value['name'] }}">
                            <span></span>
                            <span class="check"></span>
                            <span class="box"></span> {{ $value['label'] }} </label>
                        </div>
                    </div>
                </div>
                @endforeach
                <div class="col-sm chide" id="edge_polish">
                    <div class="md-checkbox-list single-checkbox">
                        <div class="md-checkbox">
                            <input type="checkbox" class="md-check ch_checkboxes" id="polish_edges" name="data[frame][edge_polish]" <?= (!empty($userSettings->edge_polish) && $userSettings->edge_polish) ? 'checked' : '' ?>>
                            <label class="control-label" for="polish_edges">
                            <span></span>
                            <span class="check"></span>
                            <span class="box"></span> {{ $combinationArray['frame']['edge_polish']['label'] }} </label>
                        </div>
                    </div>
                </div>
                <!-- </div> -->
            </div>
        </div>
        <div class="col-md-12 mid-section chide" id="bevel_type">
            <!-- <div class="row">
                <div class="col-md-12 no-padding">
                        <h5>Bevel Type</h5>
                </div>
                </div> -->
            <div class="row">
                <div class="col-md-12 no-padding">
                    <h4 class="no-margin">
                    &nbsp</h5>
                </div>
            </div>
            <!-- <div class="col-md-2"></div> -->
            <div class="col-md-3 clearfix p-b-10">
                <div class="form-group form-md-line-input form-md-floating-label">
                    <select class="form-control select2_fixed edited" data-placeholder="" data-default="normal" name="data[frame][bevel_type]" data-attr="bevel_type" id="bevel_type">
                        <option></option>
                        @foreach($combinationArray['frame']['bevel_type'] as $key =>$value)
                        <option value="{{ $key }}" <?= (!empty($userSettings->bevel_type) && $userSettings->bevel_type == $key) ? 'selected' : '' ?>>{{ $value['label'] }}</option>
                        @endforeach
                    </select>
                    <label class="control-label" for="bevel_type">Bevel Type</label>
                </div>
                <!-- <div class="btn-group btn-group-circle w-100" data-toggle="buttons">
                    @foreach($combinationArray['frame']['bevel_type'] as $key =>$value)
                    <label class="btn btn-secondary btn-segment_choice btn-frame_bevel_type_choice <?= (!empty($userSettings->bevel_type) && $userSettings->bevel_type == $key) ? 'active' : '' ?>">
                            <input type="radio" class="toggle" name="data[frame][bevel_type]" value="{{ $key }}" <?= (!empty($userSettings->bevel_type) && $userSettings->bevel_type == $key) ? 'checked' : '' ?>>
                            <div class="label-txt">{{ $value['label'] }} </div>
                    </label>
                    @endforeach
                    </div> -->
            </div>
        </div>
    </div>
    <div class="row shadow p-b-10 p-t-10 rx-section">
        <div class="col-md-12 mid-section left_space">
            <h4 class="form-section bold title">Add-ons</h4>
        </div>
        <div class="col-md-12 mid-section">
            <div class="row">
                <div class="col-md-12 clearfix p-b-10 add_clip_on-container" style="display: none;">
                    <div class="row cancel-btn">
                        <div class="col-md-12 text-right remove_prism-content" style="padding: 0px;">
                            <a href="javascript:void(0);" class="remove-abtn" title="Hide" tabindex="-1"><i class="fa fa-remove color-red"></i></a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm add_clip_on-content">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <select class="form-control select2_fixed edited is-required" data-placeholder="Clip-on Type" id="clip_on_type" name="data[additional_items][clip_on_type]" data-attr="clip_on">
                                    <option value="">Clip-on Type</option>
                                </select>
                                <label class="control-label" for="data[additional_items][clip_on_type]">Clip-on Type</label>
                            </div>
                            <span class="info text-info"></span>
                        </div>
                        <div class="col-sm">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <select class="form-control select2_fixed edited is-required" data-placeholder="Lens Type" id="clip_on_lens_type" name="data[additional_items][clip_on_lens_type]" data-attr="clip_on">
                                    <option value="">Lens Type</option>
                                </select>
                                <label class="control-label" for="data[additional_items][clip_on_lens_type]">Lens Type</label>
                            </div>
                        </div>
                        <div class="col-sm">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <select class="form-control select2_fixed edited is-required" data-placeholder="Lens Colour" id="clip_on_lens_colour" name="data[additional_items][clip_on_lens_colour]" data-attr="clip_on">
                                    <option value="">Lens Colour</option>
                                </select>
                                <label class="control-label" for="data[additional_items][clip_on_lens_colour]">Lens Colour</label>
                            </div>
                        </div>
                        <div class="col-sm clip_on_lens_sub_colour-content chide">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <select class="form-control select2_fixed edited is-required" data-placeholder="Rim Colour" id="clip_on_lens_sub_colour" name="data[additional_items][clip_on_lens_sub_colour]" data-attr="clip_on">
                                    <option value="">Rim Colour</option>
                                </select>
                                <label class="control-label" for="data[additional_items][clip_on_lens_sub_colour]">Rim Colour</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 show-hide-btn show-hide-btn-container text-center">
                    <a href="javascript:;" class="btn btn-info btn-circle show_hide-abtn" data-element="add_clip_on-container" tabindex="0"><i class="fa fa-plus"></i> Add Custom Clip-on</a>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 clearfix p-b-10 add_repairs-container col-md-offset-3" style="display: none;">
                    <div class="row cancel-btn">
                        <div class="col-md-12 text-right remove_prism-content" style="padding: 0px;">
                            <a href="javascript:void(0);" class="remove-abtn" title="Hide" tabindex="-1"><i class="fa fa-remove color-red"></i></a>
                        </div>
                    </div>
                    <div class="row repairs_services-container">
                        <div class="col-md-12 repairs_services-content">
                            <div class="form-group d-flex">
                                <select class="form-control repairs_services-list m-1" name="data[additional_items][repairs_services][]" data-attr="add-repairs">
                                    <option value="">Select Repairs & Services</option>
                                </select>
                                <button class="btn btn-danger m-1 repairs_service-remove" type="button" style="display:none;"><i class="fa fa-close"></i></button>
                            </div>
                        </div>
                    </div>
                    <div class="row repair_description-content" style="display:none;">
                        <div class="col-md-12">
                            <div class="form-group form-md-line-input form-md-floating-label">
                                <input type="text" class="form-control" id="repair_description" name="data[additional_items][repair_description]" data-attr="repair_description">
                                <label class="control-label" for="data[additional_items][repair_description]">Repair Description</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 show-hide-btn show-hide-btn-container text-center">
                    <a href="javascript:;" class="btn btn-info btn-circle show_hide-abtn" data-element="add_repairs-container" tabindex="0"><i class="fa fa-plus"></i> Add Repairs & Services</a>
                </div>
            </div>
        </div>
    </div>
    <div class="row shadow p-b-10 p-t-10 rx-section">
        <div class="col-md-12 mid-section left_space">
            <h4 class="form-section bold title">Instructions</h4>
        </div>
        <div class="col-md-12 mid-section">
            <div class="form-group form-md-line-input">
                <div class="col-md-12 content-textarea">
                    <textarea class="form-control" rows="6" name="data[special_instructions]" placeholder="Any instructions given here will result in an analysis of your order by a customer service representative and may delay the processing of your order" id="special_instructions" data-attr="special_instructions"></textarea>
                    <div class="form-control-focus"> </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style type="text/css">
    body{
    overflow: hidden;
    }
    .select2-container--bootstrap .select2-selection{
    border: none;
    }
    .select2-container--bootstrap .select2-selection--single{
    padding: 6px 13px 6px 2px;
    }
    .select2-container--bootstrap .select2-selection--single .select2-selection__arrow b{
    margin-left: 5px;
    }
    .btn-custom-focus .btn:focus{
    color: black !important;
    background-color: white !important;
    border-color: black !important;
    }
    .crawl-cs-ddl,
    .dist-type-ddl{
    max-width: 15%;
    }
    select.lens-data{
    padding-right: 0px;
    }
    .form-error-toaster{
    background: #e73d4a url(../../public/img/exclamation.png) no-repeat 5px center;
    padding: 5px 5px 5px 30px;
    margin: 15px auto;
    font-weight: 700;
    font-family: Arial, Helvetica, sans-serif;
    font-size: 13px;
    font-style: normal;
    text-decoration: none;
    color: #FFF;
    border-radius: 5px;
    position:fixed;bottom:0;left:28%;width: 45%;
    }
    .form-error-toaster div{
    float: left; padding-right: 25px;width: 50%;
    }
    .form-group.form-md-line-input .form-control.edited:not([readonly])~label{
    color: black;
    }
    .form-group.form-md-line-input .form-control.edited:not([readonly])~label:focus{
    font-weight: bolder;
    }
    .btn-info.focus, .btn-info:focus{
    background-color: #2f373e !important;
    border-color: #2f373e !important;
    }
    .form-group {
        width: 100% !important;
    }
    .btn-info {
        color: #fff !important;
        background-color: #659be0 !important;
        border-color: #508edb !important;
    }
    .select2-container--open .select2-selection--single{
    background-color: #2f373e;
    color: white;
    }
    .select2-container--open + .control-label{
    font-weight: bolder !important;
    }
    .select2-container--open .select2-selection__rendered{
    color: white !important;
    }
    .btn-frame_job_type_choice.disabled {
    opacity: 0.5; /* Dim appearance */
    pointer-events: none; /* Prevent clicks */
    cursor: not-allowed; /* Show not-allowed cursor */
    }
    .frame_container .col-sm {
    max-width: 100%;
    overflow: hidden;
    }
    .readonly-select2 + .select2-container{
    cursor: not-allowed;            /* Show disabled cursor */
    }
    .readonly-select2 + .select2-container .select2-selection--single {
    background-color: #eee;         /* Light gray background */
    pointer-events: none;           /* Prevent mouse interaction */
    color: #666;
    }
    .readonly-container {
    opacity: 0.7;
    pointer-events: none;           /* Prevent mouse interaction */
    color: #666;
    cursor: not-allowed; 
    }
    #right-intermediate_strength .label-asterick{
    top: -14px !important;
    }
    label.has-error{
    color: #e73d4a;
    }
    .skeleton-loader {
    height: 36px;
    background: linear-gradient(90deg, #eee 25%, #ddd 50%, #eee 75%);
    background-size: 200% 100%;
    animation: shimmer 1.2s infinite;
    border-radius: 4px;
    margin-bottom: 8px;
    width: 100%;
    }
    @keyframes shimmer {
    0% { background-position: 200% 0; }
    100% { background-position: -200% 0; }
    }
    .lens-field-hidden { display: none !important; }
</style>