@extends('frontend.layouts.print')

@section('title', 'Order #'.$order->getOrderNumber(). ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
<style>
    .tabletext, .tableValueNames{
        font-size: 13px;
    }
    .svg-icons-order {
        width: 16px;
        height: 18px;
        position: relative;
        top: 4px;
    }
</style>
<table width="700" align="center" cellpadding="0" cellspacing="0" border="0" class="contentarea">
<tbody><tr>
    <td>
            <table width="100%" cellpadding="0" cellspacing="0" border="0">
                <tbody><tr>
                    <td valign="top" align="center">
                        <table width="700" cellpadding="0" cellspacing="0" border="0" class="tabletext">

                            <tbody>
                            <tr>
                                <td colspan="4">
                                    <table width="100%" cellpadding="0" cellspacing="0" border="0">
                                        <tbody>
                                            <!-- <tr height="30px" font="red" class="headerFooter">
                                            <td align="left">{{ $order->getOrderNumber() }}</td>
                                            <td align="right">{{ $order->getOrderNumber() }}</td>
                                        </tr> -->
                                        <tr>
                                            <td valign="top" width="25%"><img src="{{ URL::asset('public/img/backend/brand/logo.gif') }}" height="40" alt="Lens Shapers Logo"></td>
                                            <td valign="middle" align="center" width="40%"><h2 class="GriffonLight">{{ $order->online ? 'Web Order #' : 'Offline Order # ' }} {{ $order->getOfflineOrderNumber() }}</h2></td>                           
                                            <td valign="middle" align="right" width="35%" style="font-size: 11px;">
                                                @if($order->isRedo())
                                                    <span class="text-right">REDO OF W{{$order->reason_oid}}: {{ $order->reason_type.' ('.$order->reason_notes.')' }}</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </tbody></table>
                                </td>
                            </tr>
                            <tr class="rowtopborder">
                                <td valign="top" width="15%" align="left">Account Name</td>
                                <td valign="top" width="35%" align="left"><b>{!! $user->getBusinessName() !!}</b></td>
                                <td valign="top" width="15%" align="left">{{ $order->online ? 'Web Order No.' : 'Offline Order No. ' }}</td>
                                <td valign="top" align="left"><b>{{$order->getOfflineOrderNumber()}}</b></td>
                            </tr>
                                                            <tr>
                                <td valign="top" align="left">Account No.</td>
                                <td valign="top" align="left"><b>{{ $user->ac_code }}</b></td>
                                <td valign="top" align="left">Submitted on</td>
                                <td valign="top" align="left"><b>{{ date_time_format($order->created_at,'d-M-Y h:i a')}}</b></td>
                            </tr>
                            <tr>
                                <td valign="top" align="left">Address</td>
                                <td valign="top" align="left"><b>{!! $order->user->getAddress() !!}</b></td>
                                <td valign="top" align="left">Job Type</td>
                                <td valign="top" align="left"><b>{!! $order->type_label !!}</b></td>
                            </tr>
                            <!-- <tr class="rowbtmborder">
                                <td></td>
                                <td valign="top" align="left"><b>  </b></td>
                                <td valign="top" align="left">Status</td>
                                <td valign="top" align="left"><b>{!! $order->status_fg_label !!}</b></td>
                            </tr> -->
                        </tbody></table>
                    </td>
                </tr>
                <tr><td style="height:5px;"></td></tr>
                      
                    <tr>
                        <td valign="top" align="center">
                            <table width="100%" cellpadding="0" cellspacing="0" border="1" style="border-collapse:collapse;border: none;">
                                <tbody><tr>
                                    <td align="left">
                                        <table width="100%" cellpadding="0" cellspacing="0" border="0">
                                            <tbody><tr class="subtablehead">
                                                <th>PRESCRIPTION</th>
                                            </tr>
                                            <tr>
                                                <td valign="top" align="left">
                                                    <table width="100%" cellpadding="0" cellspacing="0" border="1" class="tabletext dottedborder">
                                                        <tbody><tr>
                                                            <td colspan="3" class="bggray">Patient/Reference</td>
                                                            <td colspan="9"><b>{{ $rxOrderArray['name'] }}</b></td>
                                                        </tr>
                                                        @if(!empty($rxOrderArray['multipair_ref']))
                                                            <tr>
                                                                <td colspan="3" class="bggray">MULTI-PAIR with</td>
                                                                <td colspan="9"><b>{{ $rxOrderArray['multipair_ref'] }}</b></td>
                                                            </tr>
                                                        @endif
                                                        @if(!empty($rxOrderArray['package']['label']))
                                                            <tr>
                                                                <td colspan="3" class="bggray">Package</td>
                                                                <td colspan="9"><b>{{ $rxOrderArray['package']['label'] }}</b></td>
                                                            </tr>
                                                        @endif
                                                        <tr align="center">
                                                            <td width="4%">&nbsp;</td>
                                                            @foreach($rxOrderArray['distance']['label'] as $key =>$value)
                                                                <td width="12%" class="bggray">{{$value}}</td>
                                                            @endforeach
                                                        </tr>
                                                        <tr>
                                                            <td align="center" class="bggray">R</td>
                                                            @if(!empty(strtolower($rxOrderArray['distance']['right_dist_type'])) && strtolower($rxOrderArray['distance']['right_dist_type']) != 'order')
                                                                <td colspan="{{ count($rxOrderArray['distance']['right']) }}" style="text-align: left;">
                                                                    {{ $rxOrderArray['distance']['right_dist_type'] }}
                                                                </td>
                                                            @else
                                                                @foreach($rxOrderArray['distance']['right'] as $key =>$value)
                                                                    <td>
                                                                        <b>{{$value}}</b>
                                                                    </td>
                                                                @endforeach
                                                            @endif
                                                        </tr>
                                                        <tr>
                                                            <td align="center" class="bggray">L</td>
                                                            @if(!empty(strtolower($rxOrderArray['distance']['left_dist_type'])) && strtolower($rxOrderArray['distance']['left_dist_type']) != 'order')
                                                                <td colspan="{{ count($rxOrderArray['distance']['left']) }}" style="text-align: left;">
                                                                    {{ $rxOrderArray['distance']['left_dist_type'] }}
                                                                </td>
                                                            @else
                                                                @foreach($rxOrderArray['distance']['left'] as $key =>$value)
                                                                    <td>
                                                                        <b>{{$value}}</b>
                                                                    </td>
                                                                @endforeach
                                                            @endif
                                                        </tr>
                                                        @if(!empty($rxOrderArray['intermediateStrengthText']))
                                                            <tr class="rxValues">
                                                                <td colspan="{{ count($rxOrderArray['reading']['label']) }}" style="font-size: 12px;">
                                                                    {{ $rxOrderArray['intermediateStrengthText'] }}
                                                                </td>
                                                            </tr>
                                                        @endif
                                                        <tr align="center">
                                                            <td>&nbsp;</td>
                                                            @foreach($rxOrderArray['reading']['label'] as $key =>$value)
                                                                <td class="bggray">{{$value}}</td>
                                                            @endforeach
                                                        </tr>
                                                        <tr>
                                                            <td align="center" class="bggray">R</td>
                                                            @foreach($rxOrderArray['reading']['right'] as $key =>$value)
                                                                <td><b>{{ $value }}</b></td>
                                                            @endforeach
                                                        </tr>
                                                        <tr>
                                                            <td align="center" class="bggray">L</td>
                                                            @foreach($rxOrderArray['reading']['left'] as $key =>$value)
                                                                <td><b>{{ $value }}</b></td>
                                                            @endforeach
                                                        </tr>
                                                        <tr class="tableValueNames" align="center">
                                                            <td>&nbsp;</td>
                                                            @foreach($rxOrderArray['single_info']['label'] as $key =>$value)
                                                                <td class="bggray">{{$value}}</td>
                                                            @endforeach
                                                        </tr>
                                                        <tr class="tableValueNames" align="center">
                                                            <td>&nbsp;</td>
                                                            @foreach($rxOrderArray['single_info']['values'] as $key =>$value)
                                                                <td class=""><b>{{ $value }}</b></td>
                                                            @endforeach
                                                        </tr>
                                                        @if(isset($rxOrderArray['s_info']))
                                                            <tr align="center">
                                                                <td rowspan="3" align="center" valign="middle">Special Info</td>
                                                                <td>&nbsp;</td>
                                                                @foreach($rxOrderArray['s_info']['label'] as $key =>$value)
                                                                    <td class="bggray">{{$value}}</td>
                                                                @endforeach
                                                                <td rowspan="2" colspan="2" valign="middle" align="center"><input type="checkbox" name="use_shorter_corridor"  onclick="return false;" value="{{$rxOrderArray['s_info']['use_shorter_corridor']}}"  id="use_shorter_corridor" /> Use Shorter Corridor</td>
                                                            </tr>
                                                            <tr>
                                                                <td align="center">&nbsp;</td>
                                                                @foreach($rxOrderArray['s_info']['values'] as $key =>$value)
                                                                    <td><b>{{ $value }}</b></td>
                                                                @endforeach
                                                            </tr>
                                                        @endif
                                                    </tbody></table>
                                                </td>
                                            </tr> 
                                        </tbody></table>
                                    </td>
                                </tr>
                            </tbody></table>
                        </td>
                    </tr>
                    <tr><td style="height:5px;"></td></tr>
                
                <tr>
                    <td>  
                        <table width="100%" cellpadding="0" cellspacing="0" border="0.5" style="border-collapse:collapse">
                            <tbody><tr><td width="50%" valign="top">
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse">
                                    <tbody><tr>
                                        <td valign="top" align="left">
                                            <table width="100%" cellpadding="2" cellspacing="0" border="1" class="tabletext dottedborder" style="border-collapse:collapse">
                                                <tbody><tr class="subtablehead">
                                                    <th colspan="2">FRAME</th>
                                                </tr>
                                                <tr>
                                                    <td class="bggray tableValueNames" width="30%">Frame Type</td>
                                                    <td class="tableValues"><b>{{ $rxOrderArray['frame']['frame_type'] }}</b></td>
                                                </tr>
                                                <tr>
                                                    <td class="bggray tableValueNames" >Lens Thickness</td>
                                                    <td class="tableValues" ><b>
                                                        {{!empty($rxOrderArray['frame']['specify_thickness']) ? $rxOrderArray['frame']['specify_thickness'] : ''}}
                                                        @if(!empty($rxOrderArray['frame']['specify_thickness_data']['r_ct_or_et']))
                                                            ({{ $rxOrderArray['frame']['specify_thickness_data']['r_ct_or_et'] }} {{$rxOrderArray['frame']['specify_thickness_data']['l_ct_or_et']}})
                                                        @endif
                                                    </b></td>
                                                </tr>
                                                @if(!empty($rxOrderArray['frame']['bevel_type']))
                                                <tr>
                                                    <td class="bggray tableValueNames" >Bevel Type</td>
                                                    <td class="tableValues" ><b
                                                        >{{!empty($rxOrderArray['frame']['bevel_type']) ? $rxOrderArray['frame']['bevel_type'] : ''}}
                                                    </b></td>
                                                </tr>
                                                @endif
                                                @foreach($rxOrderArray['frame']['frame_info']['label'] as $key =>$value)
                                                    <tr>
                                                        <td class="bggray tableValueNames">{{ ucwords($value) }}</td>
                                                        <td class="tableValues" width="50%"><b style="font-family: DejaVu Sans, sans-serif;">{!! $rxOrderArray['frame']['frame_info']['values'][strtolower($value)] !!}</b></td>
                                                    </tr>
                                                @endforeach
                                                <!-- <tr>
                                                    <td colspan="2" style="height:15px;"></td>
                                                </tr> -->
                                            </tbody></table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table width="100%" cellpadding="2" cellspacing="0" border="1" class="tabletext dottedborder">
                                                <tbody><tr class="subtablehead">
                                                    <th colspan="4">FRAME SIZE</th>
                                                </tr>
                                                <tr class="bggray tableValueNames" align="center">
                                                    @foreach($rxOrderArray['frame']['frame_size']['label'] as $key =>$value)
                                                        <td width="25%">{{$value}}</td>
                                                    @endforeach
                                                </tr>
                                                <tr class="tableValues" align="center">
                                                    @foreach($rxOrderArray['frame']['frame_size']['values'] as $key =>$value)
                                                        <td><b>{{$value}}</b></td>
                                                    @endforeach
                                                </tr>
                                                <!-- <tr>
                                                    <td colspan="4" style="height:15px;"></td>
                                                </tr> -->
                                            </tbody></table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table width="100%" cellpadding="2" cellspacing="0" border="1" class="tabletext dottedborder">
                                                <tbody><tr class="subtablehead">
                                                    <th colspan="3">MODIFY SHAPE</th>
                                                </tr>
                                                <tr class="tableValues">
                                                    <td width="10%"><b style="font-family: DejaVu Sans, sans-serif;">{!! $rxOrderArray['frame']['modify_shape']['a'] !!} A</b></td>
                                                    <td width="25%"><b >{{ $rxOrderArray['frame']['modify_shape']['a_option'] }}</b></td>
                                                    <td width="25%"><b >{{ $rxOrderArray['frame']['modify_shape']['a_increase'] }}</b></td>
                                                </tr>
                                                <tr class="tableValues">
                                                    <td><b style="font-family: DejaVu Sans, sans-serif;">{!! $rxOrderArray['frame']['modify_shape']['b'] !!} B</b></td>
                                                    <td><b>{{ $rxOrderArray['frame']['modify_shape']['b_option'] }}</b></td>
                                                    <td><b>{{ $rxOrderArray['frame']['modify_shape']['b_increase'] }}</b></td>
                                                </tr>
                                            </tbody></table>
                                        </td>
                                    </tr>

                                </tbody></table>

                            </td>
                            <td valign="top" width="50%"    >
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse">
                                    <tbody><tr>
                                        <td>
                                                <table width="100%" cellpadding="2" cellspacing="0" border="1" style="border-collapse:collapse" class="tabletext dottedborder">
                                                <tbody><tr class="subtablehead">
                                                    <th colspan="2">JOB TYPE</th>
                                                </tr>
                                                <tr>
                                                    <td colspan="2" class="tableValues" id="frame_cell"><b>{!! $rxOrderArray['frame']['job_type'] !!}</b></td>
                                                </tr>

                                                <tr>
                                                    @if(isset($rxOrderArray['frame']['invoice_order_no']))
                                                        <td class="bggray tableValueNames">Invoice/Order Number</td>
                                                        <td><b>{{$rxOrderArray['frame']['invoice_order_no']}}</b></td>
                                                    @else
                                                        <!-- <td colspan="2" style="height:15px;"></td> -->
                                                    @endif
                                                </tr>


                                                <tr class="subtablehead">
                                                    <th colspan="2">LENS INFORMATION</th>
                                                </tr>                                                
                                                @if(isset($rxOrderArray['lens_group']))
                                                    @foreach($rxOrderArray['lens_group']['group_values'] as $key => $value)
                                                        <tr class="tableValues">
                                                            <td align="left" class="bggray tableValueNames">{{ $value }}</td>
                                                            <td id="lensValue1"><b>{{ $rxOrderArray['lens_group']['att_values'][$key] }}</b></td>
                                                        </tr>
                                                    @endforeach
                                                @else
                                                <tr>
                                                    <td width="30%" class="bggray tableValueNames">Lens Type</td>
                                                    <td class="tableValues"><b>{{ $rxOrderArray['lens']['lens_type'] }}</b></td>
                                                </tr>
                                                <tr class="tableValues">
                                                    <td align="left" class="bggray tableValueNames">Sub-Type</td>
                                                    <td id="lensValue1"><b>{{ $rxOrderArray['lens']['sub_type'] }}</b></td>
                                                </tr>
                                                <tr class="tableValues">
                                                    <td align="left" class="bggray tableValueNames">Lens Name</td>
                                                    <td id="lensValue3"><b>{{ $rxOrderArray['lens']['lens_name'] }}</b></td>
                                                </tr>
                                                <tr class="tableValues">
                                                    <td align="left" class="bggray tableValueNames">Material</td>
                                                    <td id="lensValue5"><b>{{ $rxOrderArray['lens']['lens_material'] }}</b></td>
                                                </tr>
                                                <tr class="tableValues">
                                                    <td align="left" class="bggray tableValueNames">Filter</td>
                                                    <td id="lensValue5"><b>{{ $rxOrderArray['lens']['lens_filter'] }}</b></td>
                                                </tr>
                                                <tr class="tableValues">
                                                    <td align="left" class="bggray tableValueNames">Colour</td>
                                                    <td id="lensValue5"><b>{{ $rxOrderArray['lens']['lens_colour'] }}</b></td>
                                                </tr>
                                                <tr class="tableValues">
                                                    <td align="left" class="bggray tableValueNames">Coating</td>
                                                    <td id="lensValue5"><b>{{ $rxOrderArray['lens']['coating_name'] }}</b></td>
                                                </tr>
                                                <tr class="tableValues">
                                                    <td align="left" class="bggray tableValueNames">Coating Colour</td>
                                                    <td id="lensValue5"><b>{{ $rxOrderArray['lens']['coating_colour'] }}</b></td>
                                                </tr>
                                                @endif
                                                @if(isset($rxOrderArray['is_tinting']) && $rxOrderArray['is_tinting'] == 1)
                                                    <tr>
                                                        <td colspan="2" style="height:15px;"></td>
                                                    </tr>
                                                    <tr class="subtablehead">
                                                        <th colspan="2">TINTING</th>
                                                    </tr>
                                                    <tr>
                                                        <td class="bggray tableValueNames">Tint</td>
                                                        <td class="tableValues"><b>{{ $rxOrderArray['tint_option'] != '1' ? 'Match Sample' : ''}}</b></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="bggray tableValueNames">Colour</td>
                                                        <td class="tableValues"><b>{{ $rxOrderArray['tint_color_sample']}}</b></td>
                                                    </tr>
                                                @endif
                                                <!-- <tr>
                                                    <td colspan="2" style="height:15px;"></td>
                                                </tr> -->
                                                <tr class="subtablehead">
                                                    <th colspan="2">Additional Items</th>
                                                </tr>
                                                <tr>
                                                    <td class="bggray tableValueNames">Add Clip-On</td>
                                                    <td class="tableValues"><b>{{ $rxOrderArray['additional_items']['add_clip_on']}}</b></td>
                                                </tr>
                                                <tr>
                                                    <td class="bggray tableValueNames">Add Repairs</td>
                                                    <td class="tableValues"><b>
                                                        @if(!empty($rxOrderArray['additional_items']['repairs_services']))
                                                            @foreach($rxOrderArray['additional_items']['repairs_services'] as $value)
                                                                @if(!empty($value)) 
                                                                    <span>{{ \App\Models\Backend\RxValidations::decodeValue($value) }}</span>
                                                                @endif
                                                            @endforeach
                                                        @endif
                                                    </b></td>
                                                </tr>
                                                <tr>
                                                    <td class="bggray tableValueNames">Description</td>
                                                    <td class="tableValues"><b>{{ $rxOrderArray['additional_items']['repair_description'] }}</b></td>
                                                </tr>
                                                </tbody></table>  
                                            </td>
                                        </tr>

                                    </tbody></table>
                                </td>
                            </tr></tbody></table>
                        </td>
                    </tr>
                    <tr>
                    <td style="height:5px;"></td>
                </tr>
                <tr>
                    <td valign="top" align="center">
                        <table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse">
                            <tbody><tr>
                                <td align="left">
                                    <table width="100%" cellpadding="2" cellspacing="0" border="1" style="border-collapse:collapse" class="tabletext dottedborder">
                                        <tbody><tr class="subtablehead">
                                            <th>SPECIAL INSTRUCTIONS</th>
                                        </tr>
                                        <tr class="tableValues">
                                            <td valign="top" align="left">
                                                <table width="100%" cellpadding="0" cellspacing="0" height="30" class="tabletext">
                                                    <tbody><tr>
                                                        <td>{{ $rxOrderArray['additional_items']['special_instructions'] }}</td>
                                                    </tr>
                                                </tbody></table>
                                            </td>
                                        </tr>
                                    </tbody></table>
                                </td>
                            </tr>
                        </tbody></table>
                    </td>
                </tr>

                    <tr><td style="height:10px;"></td></tr>
                    <tr>
                        <td>
                            <img src="{{ URL::asset('public/img/cut-here.png') }}" width="100%">
                        </td></tr>
                    <tr align="center" style="font-size:11px;">

                        <td>   <b>   ⇩&nbsp;  SEND THIS SECTION TO LAB WITH FRAME  &nbsp;⇩</b></td>

                    </tr>
                    <tr><td style="height:10px;"></td></tr>

                    <tr>
                    </tr></tbody></table><table width="100%" cellpadding="0" cellspacing="0" border="0" class="bottomTab">

                        <tbody><tr>
                            <td valign="top" align="left" class="tableValues">Customer: <b>{{ $user->ac_code }} - {{ $user->getBusinessName() }}</b></td>
                            <td valign="top" align="left" class="tableValues">Patient Name: <b>{{ $rxOrderArray['name'] }}</b></td>

                            <td valign="top" align="left" class="tableValues">{{ $order->online ? 'Web Order No.' : 'Offline Order No. ' }}: <b>{{ $order->getOrderNumber() }}</b></td>

                        </tr>
                    </tbody></table>
                    </td></tr>
    <tr>
                            <td>
                                <table width="100%" cellpadding="0" cellspacing="0" border="0" class="bottomTab" style="margin-top:5px;">
                                    <tbody><tr>
                                    </tr><tr height="20px" font="red" class="headerFooter">
                                        <td vertical-align="middle" align="middle"><img src="{{ generateBarcode($order->getOrderNumber()) }}" height="30px">
                                        </td><td vertical-align="middle" align="middle"><img src="{{ generateBarcode($order->getOrderNumber()) }}" height="30px">                                        </td><td vertical-align="middle" align="middle"><img src="{{ generateBarcode($order->getOrderNumber()) }}" height="30px">    
                                        </td><td vertical-align="middle" align="middle"><img src="{{ generateBarcode($order->getOrderNumber()) }}" height="30px">    
                                        </td><td vertical-align="middle" align="middle"><img src="{{ generateBarcode($order->getOrderNumber()) }}" height="30px">    
                                    </td></tr>
                                    <tr class="tableValues">
                                        <td vertical-align="middle" align="middle">{{ $order->getOrderNumber() }}                                        </td><td vertical-align="middle" align="middle">{{ $order->getOrderNumber() }}                                        </td><td vertical-align="middle" align="middle">{{ $order->getOrderNumber() }}                                        </td><td vertical-align="middle" align="middle">{{ $order->getOrderNumber() }}                                        </td><td vertical-align="middle" align="middle">{{ $order->getOrderNumber() }}                                    </td></tr>
                        
                    </tbody></table>
            </td>
        </tr>
</tbody></table>
@endsection