@extends('frontend.layouts.print')

@section('title', 'Order #'.$modal->getOrderNumber(). ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
<style>
    .svg-icons-order {
        width: 16px;
        height: 18px;
        position: relative;
        top: 4px;
    }
</style>
<table width="700" align="center" cellpadding="0" cellspacing="0" border="0" class="contentarea">
    <tbody><tr>
        <td>
            <table width="100%" cellpadding="0" cellspacing="0" border="0">
                <tbody><tr>
                    <td valign="top" align="center">
                        <table width="700" cellpadding="0" cellspacing="0" border="0" class="tabletext">

                            <tbody><tr>
                                <td colspan="4">
                                    <table width="100%" cellpadding="0" cellspacing="0" border="0">
                                        <tbody><tr height="30px" font="red" class="headerFooter">
                                            <td align="left">{{ $stockOrder->order->getOrderNumber() }}</td>
                                            <td align="right">{{ $stockOrder->order->getOrderNumber() }}</td>
                                        </tr>
                                        <tr>
                                            <td valign="top" width="25%"><img src="{{ URL::asset('public/img/backend/brand/logo.gif') }}" height="40" alt="Lens Shapers Logo"></td>
                                            <td valign="middle" align="center"><h2 class="GriffonLight">{{ $stockOrder->order->online ? 'Web Order #' : 'Offline Order # ' }} {{ $stockOrder->order->getOfflineOrderNumber() }}</h2></td>
                                        </tr>
                                    </tbody></table>
                                </td>
                            </tr>
                            <tr class="rowtopborder">
                                <td valign="top" width="15%" align="left">Account Name</td>
                                <td valign="top" width="35%" align="left"><b>{!! $user->getBusinessName() !!}</b></td>
                                <td valign="top" width="15%" align="left">{{ $stockOrder->order->online ? 'Web Order No.' : 'Offline Order No. ' }}</td>
                                <td valign="top" align="left"><b>{{ $stockOrder->order->getOfflineOrderNumber() }}</b></td>
                            </tr>
                                                            <tr>
                                <td valign="top" align="left">Account No.</td>
                                <td valign="top" align="left"><b>{{ $user->ac_code }}</b></td>
                                <td valign="top" align="left">Submitted on</td>
                                <td valign="top" align="left"><b>{{ date_time_format($stockOrder->order->created_at,'d-M-Y h:i a')}}</b></td>
                            </tr>
                            <tr>
                                <td valign="top" align="left">Address</td>
                                <td valign="top" align="left"><b>{!! $user->getAddress() !!}</b></td>
                                <td valign="top" align="left">Job Type</td>
                                <td valign="top" align="left"><b>{!! $stockOrder->order->type_label !!} Order</b></td>
                            </tr>
                            <tr class="rowbtmborder">
                                <td></td>
                                <td valign="top" align="left"><b>  </b></td>
                                <td valign="top" align="left">Status</td>
                                <td valign="top" align="left"><b>{!! $stockOrder->order->status_fg_label !!}</b></span></td>
                            </tr>
                        </tbody></table>
                    </td>
                </tr>
                <tr><td style="height:5px;"></td></tr>
                                        <tr>
                        <td valign="top" align="center">
                            <table width="700" cellpadding="0" cellspacing="5" border="1" style="border-collapse:collapse">
                                <tbody><tr>
                                    <td align="left">
                                        <table class="tabletext" width="100%" cellpadding="0" cellspacing="0" border="0">
                                            <tbody><tr class="subtablehead">
                                                <th colspan="5">Stock Order Details</th>
                                            </tr>
                                            <tr>
                                                <td width="20%" class="bggray">Patient/Reference</td>
                                                <td colspan="4"><b>{{ $stockOrder->order->patient }}</b></td>
                                            </tr>
                                            @if( $stockOrder->isBoth() || $stockOrder->isRight() )
                                                <tr>
                                                    <td class="bggray">Right</td>
                                                    <td><b>{{ $stockOrder->rightDetails() }}</b></td>
                                                    <td><b>{{ $stockOrder->r_sph }}</b></td>
                                                    <td><b>{{ $stockOrder->r_cyl }}</b></td>
                                                    <td><b>{{ $stockOrder->r_quantity }} pc(s)</b></td>
                                                </tr> 
                                            @endif
                                            @if( $stockOrder->isBoth() || $stockOrder->isBarcode() || $stockOrder->isLeft() )
                                                <tr>
                                                    <td class="bggray">Left</td>
                                                    <td><b>{{ $stockOrder->leftDetails() }}</b></td>
                                                    <td><b>{{ $stockOrder->l_sph }}</b></td>
                                                    <td><b>{{ $stockOrder->l_cyl }}</b></td>
                                                    <td><b>{{ $stockOrder->l_quantity }} pc(s)</b></td>
                                                </tr> 
                                             @endif
                                        </tbody></table>
                                    </td>
                                </tr>
                            </tbody></table>
                        </td>
                    </tr>
                </tbody>
            </table>
</td>
</tr>
</tbody></table>
@endsection