<div class="row">
    <div class="col-12">
        <div class="position-relative">
            <input type="hidden" name="invoice_order_no" value="{{ $modal->invoice_no }}">
            <table class="table table-striped table-bordered table-advance table-hover">
                <tbody>
                    <tr class="rowtopborder">
                        <td>Account Name</td>
                        <td><b>{!! $modal->user->getBusinessName() !!}</b></td>
                        <td>{{ $modal->online ? 'Web Order No.' : 'Offline Order No. ' }}</td>
                        <td colspan="2"><b>{{ $modal->getOfflineOrderNumber() }}</b></td>
                    </tr>
                    <tr>
                        <td>Account No.</td>
                        <td><b>{{ $modal->user->ac_code }}</b></td>
                        <td>Submitted on</td>
                        <td colspan="2"><b>{{date('d-M-Y h:i a',strtotime($modal->created_at))}}</b></td>
                    </tr>
                    </tr>
                        <td>Status</td>
                        <td><b>{!! $modal->getStatusLabelAttribute(true) !!}</b></td>
                        <td>Invoice Number</td>
                        <td><b>{{ $modal->invoice_no }}</b></td>
                    <tr>
                    </tr>
                        <td>ETA</td>
                        <td><b>{{ !empty($modal->eta) ? date('Y-m-d',strtotime($modal->eta)) : '' }}</b></td>
                        <td>Tray</td>
                        <td><b>{{ $modal->tray }}</b></td>
                    <tr>
                </tbody>
            </table>
        </div>
        <div class="order-view-container position-relative scroller p-0" style="height:400px;overflow: scroll;">
            <div class="row m-0 p-0">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th colspan="11"><b>PRESCRIPTION</b></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td colspan="1" class="bggray">Patient/Reference</td>
                            <td colspan="10"><b>{{ $rxOrderArray['name'] }}</b></td>
                        </tr>
                        <tr align="center">
                            <td width="9%" rowspan="3">Distant Vision</td>
                            <td width="4%">&nbsp;</td>
                            @foreach($rxOrderArray['distance']['label'] as $key =>$value)
                                <td width="12%" class="bggray">{{$value}}</td>
                            @endforeach
                        </tr>
                        <tr align="center">
                            <td class="bggray">R</td>
                            @foreach($rxOrderArray['distance']['right'] as $key =>$value)
                                <td>
                                    <b>{{$value}}</b>
                                </td>
                            @endforeach
                        </tr>
                        <tr align="center">
                            <td class="bggray">L</td>
                            @foreach($rxOrderArray['distance']['left'] as $key =>$value)
                                <td>
                                    <b>{{$value}}</b>
                                </td>
                            @endforeach
                        </tr>
                        <tr align="center">
                            <td rowspan="3" align="center" valign="middle">Reading</td>
                            <td>&nbsp;</td>
                            @foreach($rxOrderArray['reading']['label'] as $key =>$value)
                                <td class="bggray">{{$value}}</td>
                            @endforeach
                        </tr>
                        <tr>
                            <td align="center" class="bggray">R</td>
                            @foreach($rxOrderArray['reading']['right'] as $key =>$value)
                                <td><b>{{ $value }}</b></td>
                            @endforeach
                        </tr>
                        <tr>
                            <td align="center" class="bggray">L</td>
                            @foreach($rxOrderArray['reading']['left'] as $key =>$value)
                                <td><b>{{ $value }}</b></td>
                            @endforeach
                        </tr>
                        <tr align="center">
                            <td rowspan="3" align="center" valign="middle"></td>
                            <td>&nbsp;</td>
                            @foreach($rxOrderArray['single_info']['label'] as $key =>$value)
                                <td class="bggray">{{$value}}</td>
                            @endforeach
                        </tr>
                        <tr>
                            <td align="center" class=""></td>
                            @foreach($rxOrderArray['single_info']['values'] as $key =>$value)
                                <td><b>{{ $value }}</b></td>
                            @endforeach
                        </tr>
                        @if(isset($rxOrderArray['s_info']))
                            <tr align="center">
                                <td rowspan="3" align="center" valign="middle">Special Info</td>
                                <td>&nbsp;</td>
                                @foreach($rxOrderArray['s_info']['label'] as $key =>$value)
                                    <td class="bggray">{{$value}}</td>
                                @endforeach
                                <td rowspan="2" colspan="2" valign="middle" align="center"><input type="checkbox" name="use_shorter_corridor"  onclick="return false;" value="{{$rxOrderArray['s_info']['use_shorter_corridor']}}"  id="use_shorter_corridor" /> Use Shorter Corridor</td>
                            </tr>
                            <tr>
                                <td align="center">&nbsp;</td>
                                @foreach($rxOrderArray['s_info']['values'] as $key =>$value)
                                    <td><b>{{ $value }}</b></td>
                                @endforeach
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-striped table-bordered table-advance table-hover" >
                        <tbody><tr class="subtablehead">
                            <th colspan="2">FRAME</th>
                        </tr>
                        <tr>
                            <td class="bggray tableValueNames" width="30%">Frame Type</td>
                            <td class="tableValues"><b>{{ $rxOrderArray['frame']['frame_type'] }}</b></td>
                        </tr>
                        <tr>
                            <td class="bggray tableValueNames" >Lens Thickness</td>
                            <td class="tableValues" ><b>{{$rxOrderArray['frame']['bevel_type']}}</b></td>
                        </tr>
                        @foreach($rxOrderArray['frame']['frame_info']['label'] as $key =>$value)
                            <tr>
                                <td class="bggray tableValueNames">{{ ucwords($value) }}</td>
                                <td class="tableValues" width="50%"><b style="font-family: DejaVu Sans, sans-serif;">{!! $rxOrderArray['frame']['frame_info']['values'][strtolower($value)] !!}</b></td>
                            </tr>
                        @endforeach
                        <tr>
                            <td colspan="2" style="height:15px;"></td>
                        </tr>
                    </tbody></table>      
                    <table class="table table-striped table-bordered table-advance table-hover">
                        <tbody><tr class="subtablehead">
                            <th colspan="4">FRAME SIZE</th>
                        </tr>
                        <tr class="bggray tableValueNames" align="center">
                            @foreach($rxOrderArray['frame']['frame_size']['label'] as $key =>$value)
                                <td width="25%">{{$value}}</td>
                            @endforeach
                        </tr>
                        <tr class="tableValues" align="center">
                            @foreach($rxOrderArray['frame']['frame_size']['values'] as $key =>$value)
                                <td><b>{{$value}}</b></td>
                            @endforeach
                        </tr>
                        <tr>
                            <td colspan="4" style="height:15px;"></td>
                        </tr>
                    </tbody></table>        
                    <table class="table table-striped table-bordered table-advance table-hover">
                        <tbody><tr class="subtablehead">
                            <th colspan="3">MODIFY SHAPE</th>
                        </tr>
                        <tr class="tableValues">
                            <td width="10%"><b style="font-family: DejaVu Sans, sans-serif;">{!! $rxOrderArray['frame']['modify_shape']['a'] !!} A</b></td>
                            <td width="25%"><b >{{ $rxOrderArray['frame']['modify_shape']['a_option'] }}</b></td>
                            <td width="25%"><b >{{ $rxOrderArray['frame']['modify_shape']['a_increase'] }}</b></td>
                        </tr>
                        <tr class="tableValues">
                            <td><b style="font-family: DejaVu Sans, sans-serif;">{!! $rxOrderArray['frame']['modify_shape']['b'] !!} B</b></td>
                            <td><b>{{ $rxOrderArray['frame']['modify_shape']['b_option'] }}</b></td>
                            <td><b>{{ $rxOrderArray['frame']['modify_shape']['b_increase'] }}</b></td>
                        </tr>
                        <tr>
                            <td colspan="3" style="height:15px;"></td>
                        </tr>
                    </tbody></table>
                </div>
                <div class="col-md-6 p-0">
                    <table class="table table-striped table-bordered table-advance table-hover">
                        <tbody><tr class="subtablehead">
                            <th colspan="2">JOB TYPE</th>
                        </tr>
                        <tr>
                            <td colspan="2" class="tableValues" id="frame_cell"><b>{{ $rxOrderArray['frame']['job_type'] }}</b></td>
                        </tr>

                        <tr>
                            @if(isset($rxOrderArray['frame']['invoice_order_no']))
                                <td class="bggray tableValueNames">Invoice/Order Number</td>
                                <td><b>{{$rxOrderArray['frame']['invoice_order_no']}}</b></td>
                            @else
                                <td colspan="2" style="height:15px;"></td>
                            @endif
                        </tr>


                        <tr class="subtablehead">
                            <th colspan="2">LENS INFORMATION</th>
                        </tr>
                        <tr>
                            <td width="30%" class="bggray tableValueNames">Lens Type</td>
                            <td class="tableValues"><b>{!! $rxOrderArray['lens']['lens_type'] !!}</b></td>
                        </tr>
                        <tr class="tableValues">
                            <td align="left" class="bggray tableValueNames">Sub-Type</td>
                            <td id="lensValue1"><b>{{ $rxOrderArray['lens']['sub_type'] }}</b></td>
                        </tr>
                        <tr class="tableValues">
                            <td align="left" class="bggray tableValueNames">Lens Name</td>
                            <td id="lensValue3"><b>{{ $rxOrderArray['lens']['lens_name'] }}</b></td>
                        </tr>
                        <tr class="tableValues">
                            <td align="left" class="bggray tableValueNames">Material</td>
                            <td id="lensValue5"><b>{{ $rxOrderArray['lens']['lens_material'] }}</b></td>
                        </tr>
                        <tr class="tableValues">
                            <td align="left" class="bggray tableValueNames">Filter</td>
                            <td id="lensValue5"><b>{{ $rxOrderArray['lens']['lens_filter'] }}</b></td>
                        </tr>
                        <tr class="tableValues">
                            <td align="left" class="bggray tableValueNames">Colour</td>
                            <td id="lensValue5"><b>{{ $rxOrderArray['lens']['lens_colour'] }}</b></td>
                        </tr>
                        <tr class="tableValues">
                            <td align="left" class="bggray tableValueNames">Coating</td>
                            <td id="lensValue5"><b>{{ $rxOrderArray['lens']['coating_name'] }}</b></td>
                        </tr>
                        <tr class="tableValues">
                            <td align="left" class="bggray tableValueNames">Coating Colour</td>
                            <td id="lensValue5"><b>{{ $rxOrderArray['lens']['coating_colour'] }}</b></td>
                        </tr>
                        <tr>
                            <td colspan="2" style="height:15px;"></td>
                        </tr>
                        <tr class="subtablehead">
                            <th colspan="2">Additional Items</th>
                        </tr>
                        <tr>
                            <td class="bggray tableValueNames">Add Clip-On</td>
                            <td class="tableValues"><b>{{ $rxOrderArray['additional_items']['add_clip_on']}}</b></td>
                        </tr>
                        <tr>
                            <td class="bggray tableValueNames">Add Repairs</td>
                            <td class="tableValues"><b></b></td>
                        </tr>
                        <tr>
                            <td class="bggray tableValueNames">Description</td>
                            <td class="tableValues"><b>{{ $rxOrderArray['additional_items']['repair_description'] }}</b></td>
                        </tr>
                        </tbody></table>  
                </div>
            </div>
            <div class="row">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th><b>Special Instructions</b></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td width="15%">{{ $rxOrderArray['additional_items']['special_instructions'] }}</td>
                        </tr>
                    </tbody>
                </table>
                @if($modal->isRedo())
                    <table class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th colspan="4"><b>Reason for redo</b></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td width="15%">Type</td>
                                <td width="25%"><b>{{ $modal->reason_type }}</b></td>
                                <td width="15%">Notes</td>
                                <td width="25%"><b>{{ $modal->reason_notes }}</b></td>
                            </tr>
                        </tbody>
                    </table>
                @endif
            </div>
        </div>
    </div>
</div>
<div class="row stock-btn-container">
    <div class="col-md-12 zero-col-padding">
        <div class="col-md-4 nopadding">
            <!-- <div class="form-actions">
                <a class="btn red" href="{{route('frontend.user.rx-lens-orders')}}">Back</a>
            </div> -->
        </div>
        <div class="col-md-4 nopadding">
        </div>
        <div class="col-md-4 nopadding">
            <div class="form-actions aligned-stock-btn">
                <button class="btn blue print_order-btn" data-url="{{route('frontend.user.orders.print',$modal)}}"><i class="fas fa-print"></i> Print</button>
                @if($modal->isWebOrder())
                    <button class="btn green redo_order-btn" data-id="{{ $modal->id }}"><i class="fas fa-redo"></i> Start Redo</button>
                @endif
            </div>
        </div>
    </div>
</div>