<div class="order-details-tab-container" style="max-width:650px;margin: auto;">
    <div class="row">
        <div class="col-md-12 nopadding mb-2">
            <div class="form-actions aligned-stock-btn align-right">
                @if($modal->isSaved())
                    <a class="btn red" href="{{route('frontend.user.orders.destroy',$modal)}}"><i class="fa fa-trash"></i> Delete</a>
                    <a class="btn blue" href="{{route('frontend.user.new-rx-lens-order')}}?edit={{ $modal->id }}"><i class="fa fa-pencil"></i> Edit</a>
                @else
                    <button class="btn blue print_order-btn" data-url="{{route('frontend.user.orders.print',$modal)}}"><i class="fas fa-print"></i> Print</button>
                    @if(!$modal->isOffline() && !$modal->isLegacy() && !auth()->user()->isCustomerStaff())
                        <a class="btn red" href="{{route('frontend.user.new-rx-lens-order')}}?reuse={{ $modal->id }}" target="_blank"><i class="fas fa-recycle"></i> Reuse</a>
                        @if($modal->isWebOrder())
                            <button class="btn green redo_order-btn" data-id="{{ $modal->id }}"><i class="fas fa-redo"></i> Start Redo</button>
                        @endif
                    @else
                        @if(!auth()->user()->isCustomerStaff())
                            <span data-toggle="tooltip" title="Not available for this order">
                            <button class="btn red" disabled>
                                <i class="fas fa-recycle"></i> Reuse
                            </button>
                            </span>

                            <span data-toggle="tooltip" title="Not available for this order">
                            <button class="btn green" disabled>
                                <i class="fas fa-redo"></i> Start Redo
                            </button>
                            </span>
                        @endif
                    @endif
                @endif
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="position-relative">
                <input type="hidden" name="invoice_order_no" value="{{ $modal->invoice_no }}">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <tbody>
                        <tr class="rowtopborder">
                            <td>Account Name</td>
                            <td><b>{!! $modal->user->getBusinessName() !!}</b></td>
                            <td>{{ $modal->online ? 'Web Order No.' : 'Offline Order No. ' }}</td>
                            <td colspan="2"><b>{{ $modal->getOfflineOrderNumber() }}</b></td>
                        </tr>
                        <tr>
                            <td>Account No.</td>
                            <td><b>{{ $modal->user->ac_code }}</b></td>
                            <td>Submitted on</td>
                            <td colspan="2"><b>{{ date_time_format($modal->created_at,'d-M-Y h:i a')}}</b></td>
                        </tr>
                        </tr>
                            <td>Status</td>
                            <td><b>{!! $modal->getStatusLabelAttribute(true) !!}</b></td>
                            <td>Invoice Number</td>
                            <td><b>{{ $modal->invoice_no }}</b></td>
                        <tr>
                        </tr>
                            <td>ETA</td>
                            <td><b>{{ !empty($modal->eta) ? date('d-M-Y',strtotime($modal->eta)) : '' }}</b></td>
                            <td>Tray</td>
                            <td><b>{{ $modal->tray }}</b></td>
                        <tr>
                    </tbody>
                </table>
            </div>
            <div class="order-view-container position-relative scroller p-0" style="height:400px;overflow-y: scroll;">
                <div class="row summary-container">
                    <div class="col-12">
                        <div class="row p-0 m-0">
                            <div class="col-1 p-0">&nbsp;</div>
                            <div class="col-11 p-0">
                                <h4 class="form-section bold m-0">Order Summary</h4>
                                <label class="">
                                    <b id="reference-field">{{ $rxOrderArray['name'] }}</b>
                                </label>
                                @if($modal->isRedo())
                                <div class="reason-content">
                                    <label class="">
                                        <b id="reason-content-field">REDO OF W{{$modal->reason_oid}}: {{ $modal->reason_type.' ('.$modal->reason_notes.')' }}</b>
                                    </label>
                                </div>
                                @endif
                                @if(!empty($rxOrderArray['package']['label']))
                                <div class="reason-content">
                                    <label class="">
                                        <b id="package-content-field">Package: {{ $rxOrderArray['package']['label'] }}</b>
                                    </label>
                                </div>
                                @endif
                            </div>
                        </div>
                        @if(!empty($rxOrderArray['multipair_ref']))
                            <div class="row m-0 p-2">
                                <div class="col-1 p-0 text-center bold"></div>
                                <div class="col-11 p-0">
                                    <div id="left-order_container">
                                        <span class="multipair_ref-field">             
                                            MULTI-PAIR with: {{ $rxOrderArray['multipair_ref'] }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        @endif
                        <section>
                            <div class="row p-0 m-0">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-11 p-0">
                                    <h4 class="form-section bold summary-heading" style="padding-left: 5px;">Lenses</h4>
                                </div>
                            </div>
                            <div class="row m-0 p-2">
                                <div class="col-1 p-0 text-center bold">R</div>
                                <div class="col-11 p-0">
                                    <div id="right-order_container">
                                        <span class="lens_type-field">
                                            @if(isset($rxOrderArray['lens_group']))
                                                {!! implode(', ', $rxOrderArray['lens_group']['att_values']) !!}
                                            @elseif(!empty($rxOrderArray['distance']['right_dist_type']) && strtolower($rxOrderArray['distance']['right_dist_type']) != 'order')
                                                {{ $rxOrderArray['distance']['right_dist_type'] }}
                                            @else
                                                {!! rtrim(trim(str_replace(', , ',', ',$rxOrderArray['lens']['lens_type'].', '.$rxOrderArray['lens']['sub_type'].', '.$rxOrderArray['lens']['lens_name'].', '.$rxOrderArray['lens']['lens_material'].', '.$rxOrderArray['lens']['lens_filter'].', '.$rxOrderArray['lens']['lens_colour'].', '.$rxOrderArray['lens']['coating_name'].', '.$rxOrderArray['lens']['coating_colour'])),',') !!}
                                            @endif
                                        </span>
                                    </div>
                                    <div id="right-order_other_container" style="display:none;">
                                        <span class="lens_type-details"></span>
                                    </div>
                                    <span style="display:none;" id="right-order_specs"></span>
                                </div>
                            </div>
                            <div class="row m-0 p-2">
                                <div class="col-1 p-0 text-center bold">L</div>
                                <div class="col-11 p-0">
                                    <div id="left-order_container">
                                        <span class="lens_type-field">             
                                            @if(isset($rxOrderArray['lens_group']))
                                                {!! implode(', ', $rxOrderArray['lens_group']['att_values']) !!}
                                            @elseif(!empty($rxOrderArray['distance']['left_dist_type']) && strtolower($rxOrderArray['distance']['left_dist_type']) != 'order')
                                                {{ $rxOrderArray['distance']['left_dist_type'] }}
                                            @else
                                            {!! rtrim(trim(str_replace(', , ',', ',$rxOrderArray['lens']['lens_type'].', '.$rxOrderArray['lens']['sub_type'].', '.$rxOrderArray['lens']['lens_name'].', '.$rxOrderArray['lens']['lens_material'].', '.$rxOrderArray['lens']['lens_filter'].', '.$rxOrderArray['lens']['lens_colour'].', '.$rxOrderArray['lens']['coating_name'].', '.$rxOrderArray['lens']['coating_colour'])),',') !!}
                                            @endif
                                        </span>
                                    </div>
                                    <div id="left-order_other_container" style="display:none;">
                                        <span class="lens_type-details"></span>
                                    </div>
                                    <span style="display:none;" id="left-order_specs"></span>
                                </div>
                            </div>
                        </section>
                        <section>
                            <div class="row p-0 m-0 text-center">
                                <div class="col-1 p-0">&nbsp;</div>
                                @foreach($rxOrderArray['distance']['label'] as $key =>$value)
                                    @if($value != '')
                                    <div class="col p-0">
                                        <h4 class="form-section bold summary-heading">{{$value}}</h4>
                                    </div>
                                    @endif
                                @endforeach
                            </div>
                            <div class="row m-0 p-2 text-center">
                                <div class="col-1 p-0 text-center bold">R</div>
                                @foreach($rxOrderArray['distance']['right'] as $key =>$value)
                                    @if($key != '')
                                        <div class="col p-0">
                                            <span>{{$value}}</span>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                            <div class="row m-0 p-2 text-center">
                                <div class="col-1 p-0 text-center bold">L</div>
                                @foreach($rxOrderArray['distance']['left'] as $key =>$value)
                                    @if($key != '')
                                        <div class="col p-0">
                                            <span>{{$value}}</span>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                            @if(!empty($rxOrderArray['intermediateStrengthText']))
                            <div class="row m-0 p-2 text-left">
                                <div class="col-1 p-0 text-center bold"></div>
                                <div class="col p-0">
                                    <span>{{ $rxOrderArray['intermediateStrengthText'] }}</span>
                                </div>
                            </div>
                            @endif
                        </section>
                        <section>
                            <div class="row p-0 m-0 text-center">
                                <div class="col-1 p-0">&nbsp;</div>
                                @foreach($rxOrderArray['reading']['label'] as $key =>$value)
                                    <div class="col p-0">
                                        <h4 class="form-section bold summary-heading">{{$value}}</h4>
                                    </div>
                                @endforeach
                            </div>
                            <div class="row m-0 p-2 text-center">
                                <div class="col-1 p-0 text-center bold">R</div>
                                @foreach($rxOrderArray['reading']['right'] as $key =>$value)
                                    <div class="col p-0">
                                        <span>{{ $value }}</span>
                                    </div>
                                @endforeach                                
                            </div>
                            <div class="row m-0 p-2 text-center">
                                <div class="col-1 p-0 text-center bold">L</div>
                                @foreach($rxOrderArray['reading']['left'] as $key =>$value)
                                    <div class="col p-0">
                                        <span>{{ $value }}</span>
                                    </div>
                                @endforeach  
                            </div>
                        </section>
                        <section>
                            <div class="row p-0 m-0 text-center">
                                <div class="col-1 p-0">&nbsp;</div>
                                @foreach($rxOrderArray['single_info']['label'] as $key =>$value)
                                <div class="col p-0">
                                    <h4 class="form-section bold summary-heading">{{$value}}</h4>
                                </div>
                                @endforeach
                            </div>
                            <div class="row m-0 p-2 text-center">
                                <div class="col-1 p-0">&nbsp;</div>
                                @foreach($rxOrderArray['single_info']['values'] as $key =>$value)
                                <div class="col p-0">
                                    <span>{{$value}}</span>
                                </div>
                                @endforeach
                            </div>
                        </section>
                        <section>
                            <div class="row p-0 m-0">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-11 p-0">
                                    <h4 class="form-section bold summary-heading" style="padding-left: 5px;">Frame</h4>
                                </div>
                            </div>
                            <div class="row m-0 p-2 frame_type-summary">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-11 p-0">
                                    <span data-show="frame_type-summary">{{ $rxOrderArray['frame']['frame_type'] }}</span>
                                </div>
                            </div>
                            <div class="row m-0 p-2 frame_info-summary">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-11 p-0">
                                    @php
                                        $frameInfo = [];
                                        foreach ($rxOrderArray['frame']['frame_info']['values'] as $key => $value) {
                                            if (!empty($value)) {
                                                // Find the corresponding label for checkmark values
                                                if ($value == '✓') {
                                                    if($key == 'pof'){
                                                        $labelIndex = array_search(ucwords($key), $rxOrderArray['frame']['frame_info']['label']);
                                                        $label = $labelIndex !== false ? $rxOrderArray['frame']['frame_info']['label'][$labelIndex] : $key;
                                                        $frameInfo[] = $value . ' ' . ucwords($label);
                                                    }
                                                } else {
                                                    $frameInfo[] = $value;
                                                }
                                            }
                                        }
                                    @endphp

                                    @if (!empty($frameInfo))
                                        {!! implode(', ', $frameInfo) !!}
                                    @endif
                                </div>
                            </div>
                            <div class="row m-0 p-2 frame_size-details-summary">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-10 p-0 check-backslashes">
                                        @foreach($rxOrderArray['frame']['frame_size']['label'] as $key =>$value)
                                            @if(!empty($rxOrderArray['frame']['frame_size']['values'][$key]))
                                                <span>{{ $value }}:  {{ $rxOrderArray['frame']['frame_size']['values'][$key] }}</span>
                                            @endif
                                        @endforeach
                                </div>
                                <div class="col-1 p-0 "></div>
                            </div>
                            <div class="row m-0 p-2">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-10 p-0">
                                    <span id="specify_thickness-field">{{!empty($rxOrderArray['frame']['specify_thickness']) ? 'Lens Thickness: '.$rxOrderArray['frame']['specify_thickness'].',' : ''}} </span>
                                    <span id="r_ct_or_et-field" data-label="true">{{$rxOrderArray['frame']['specify_thickness_data']['r_ct_or_et']}}</span>
                                    <span id="l_ct_or_et-field" data-label="true">{{$rxOrderArray['frame']['specify_thickness_data']['l_ct_or_et']}}</span>
                                    @if(!empty($rxOrderArray['frame']['bevel_type']))
                                        <span id="bevel_type-field">Bevel Type: {{$rxOrderArray['frame']['bevel_type']}}</span>
                                    @endif
                                    <span id="safety_stamp-field">{!!$rxOrderArray['frame']['safety_stamp']!!}</span>
                                    <span id="polish_edges-field">{!!$rxOrderArray['frame']['edge_polish']!!}</span>
                                </div>
                                <div class="col-1 p-0 "></div>
                            </div>
                        </section>
                        <section>
                            <div class="row p-0 m-0 modify_shape-summary" style="display:<?= empty($rxOrderArray['frame']['modify_shape']['a_option']) ? 'none' : '' ?>;">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-11 p-0">
                                    <h4 class="form-section bold summary-heading" style="padding-left: 5px;">Modify Shape</h4>
                                </div>
                            </div>
                            <div class="row m-0 p-2 modify_shape-summary" style="display:<?= empty($rxOrderArray['frame']['modify_shape']['a_option']) ? 'none' : '' ?>;">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-10 p-0">
                                    <span id="ms_a-field" data-show="modify_shape-summary">A: {!! $rxOrderArray['frame']['modify_shape']['a'] !!}</span>
                                    <span id="a_shape_options-field" data-show="modify_shape-summary">{{ $rxOrderArray['frame']['modify_shape']['a_option'] }}</span>
                                    <span id="a_increased_by-field" data-show="modify_shape-summary">{{ $rxOrderArray['frame']['modify_shape']['a_increase'] }}</span>

                                    <span id="ms_b-field" data-show="modify_shape-summary">B: {!! $rxOrderArray['frame']['modify_shape']['b'] !!}</span>
                                    <span id="b_shape_options-field" data-show="modify_shape-summary">{{ $rxOrderArray['frame']['modify_shape']['b_option'] }}</span>
                                    <span id="b_increased_by-field" data-show="modify_shape-summary">{{ $rxOrderArray['frame']['modify_shape']['b_increase'] }}</span>
                                </div>
                                <div class="col-1 p-0 "></div>
                            </div>
                        </section>
                        <section style="display:<?= empty($rxOrderArray['additional_items']['add_clip_on']) ? 'none' : '' ?>;">
                            <div class="row p-0 m-0 addons-summary">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-11 p-0">
                                    <h4 class="form-section bold summary-heading" style="padding-left: 5px;">Add-ons</h4>
                                </div>
                            </div>
                            <div class="row m-0 p-2 addons-summary" id="addons-second-elem">
                                <div class="col-1 p-0"></div>
                                <div class="col-11 p-0">
                                    <span id="clip_on_type-custom">{{ $rxOrderArray['additional_items']['add_clip_on'] }}</span>
                                </div>
                            </div>
                            @if(!empty($rxOrderArray['additional_items']['repairs_services']))
                                @foreach($rxOrderArray['additional_items']['repairs_services'] as $value)
                                    @if(!empty($value)) 
                                        <div class="row m-0 p-2 repairs_services-summary">
                                            <div class="col-1 p-0">&nbsp;</div>
                                            <div class="col-11 p-0">
                                                <span id="repairs_services-field" data-show="repairs_services-summary">{{ \App\Models\Backend\RxValidations::decodeValue($value) }}</span>
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            @endif
                            @if(!empty($rxOrderArray['additional_items']['repair_description']))
                            <div class="row m-0 p-2 repair_description-summary">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-11 p-0">
                                    <span id="repair_description-field" data-show="repair_description-summary">{{ $rxOrderArray['additional_items']['repair_description'] }}</span>
                                </div>
                            </div>
                            @endif
                        </section>
                        <section>
                            <div class="row p-0 m-0 job-summary">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-11 p-0">
                                    <h4 class="form-section bold summary-heading" style="padding-left: 5px;">Job</h4>
                                </div>
                            </div>
                            <div class="row m-0 p-2 job-summary">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-11 p-0">
                                    <span id="job_type-field" data-show="job-summary">{!! $rxOrderArray['frame']['job_type'] !!}</span>

                                    <span><span id="pof-field"></span></span>
                                </div>
                            </div>
                        </section>
                        <section>
                            <div class="row p-0 m-0 special_instructions-summary">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-11 p-0">
                                    <h4 class="form-section bold summary-heading" style="padding-left: 5px;">Instructions</h4>
                                </div>
                            </div>
                            <div class="row m-0 p-2 special_instructions-summary">
                                <div class="col-1 p-0">&nbsp;</div>
                                <div class="col-10 p-0">
                                    <span id="special_instructions-field" data-show="special_instructions-summary">{{ $rxOrderArray['additional_items']['special_instructions'] }}</span>
                                </div>
                                <div class="col-1 p-0 "></div>
                            </div>
                        </section>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- <div class="row stock-btn-container">
        <div class="col-md-12 zero-col-padding"> -->
            <!-- <div class="col-md-4 nopadding"> -->
                <!-- <div class="form-actions">
                    <a class="btn red" href="{{route('frontend.user.rx-lens-orders')}}">Back</a>
                </div> -->
            <!-- </div> -->
            <!-- <div class="col-md-12 nopadding">
                <div class="form-actions aligned-stock-btn align-right">
                    @if($modal->isSaved())
                        <a class="btn red" href="{{route('frontend.user.orders.destroy',$modal)}}"><i class="fa fa-trash"></i> Delete</a>
                        <a class="btn blue" href="{{route('frontend.user.new-rx-lens-order')}}?edit={{ $modal->id }}"><i class="fa fa-pencil"></i> Edit</a>
                    @else
                        <a class="btn red" href="{{route('frontend.user.new-rx-lens-order')}}?reuse={{ $modal->id }}" target="_blank"><i class="fas fa-recycle"></i> Reuse</a>
                        <button class="btn blue print_order-btn" data-url="{{route('frontend.user.orders.print',$modal)}}"><i class="fas fa-print"></i> Print</button>
                        @if($modal->isWebOrder())
                            <button class="btn green redo_order-btn" data-id="{{ $modal->id }}"><i class="fas fa-redo"></i> Start Redo</button>
                        @endif
                    @endif
                </div>
            </div> -->
        <!-- </div>
    </div> -->
</div>