@extends('frontend.layouts.customer-login')

@section('title', 'Customer Login' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
    <!-- BEGIN RESET PASSWORD FORM -->
    {{ html()->form('POST', route('frontend.auth.password.reset'))->class('login-form')->open() }}
        {{ html()->hidden('token', $token) }}
        @if(isset($email))
            {{ html()->hidden('email', $email) }}
        @endif
        <h3 class="form-title">@lang('labels.frontend.passwords.reset_password_box_title')</h3>
        <div class="alert alert-danger display-hide">
            <button class="close" data-close="alert"></button>
            <span> Missing Information. </span>
        </div>
        @if(session('status'))
            <div class="alert alert-success">
                {{ session('status') }}
            </div>
        @endif
        @if($ac_code ?? null)
            <div class="form-group">
                {{ html()->label('Customer Code')->for('ac_code_business_display') }}
                <div class="input-icon">
                    <i class="fa fa-code"></i>
                    <input type="text" id="ac_code_business_display" class="form-control" value="{{ $ac_code }} - {{ $business_name ?? '' }}" readonly>
                </div>
            </div>
            {{ html()->hidden('ac_code', $ac_code) }}
        @endif
        <div class="form-group">
            {{ html()->label(__('validation.attributes.frontend.password'))->for('password') }}
            <div class="input-icon">
                <i class="fa fa-lock"></i>
                {{ html()->password('password')
                    ->class('form-control')
                    ->placeholder(__('validation.attributes.frontend.password'))
                    ->required() }}
            </div>
        </div>
        <div class="form-group">
            {{ html()->label(__('validation.attributes.frontend.password_confirmation'))->for('password_confirmation') }}
            <div class="input-icon">
                <i class="fa fa-lock"></i>
                {{ html()->password('password_confirmation')
                    ->class('form-control')
                    ->placeholder(__('validation.attributes.frontend.password_confirmation'))
                    ->required() }}
            </div>
        </div>
        <div class="form-actions">
            {{ form_submit(__('labels.frontend.passwords.reset_password_button')) }}
        </div>
    {{ html()->form()->close() }}

@endsection
