@if($breadcrumbs)
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <span>Home</span>
                <i class="fa fa-circle"></i>
            </li>
            @foreach($breadcrumbs as $breadcrumb)
                <li>
                    @if($breadcrumb->url && !$loop->last)
                        <a href="{{ $breadcrumb->url }}">{{ $breadcrumb->title }}</a>
                    @else
                        {{ $breadcrumb->title }}
                    @endif
                    <i class="fa fa-circle"></i>
                </li>
            @endforeach

            @yield('breadcrumb-links')
        </ul>
        <div class="page-toolbar">
            <div class="btn-group float-end">
                @if(!auth()->user()->isCustomerAdmin())
                    <button type="button" class="btn green btn-sm btn-outline dropdown-toggle" data-toggle="dropdown"> Users
                        <i class="fa fa-angle-down"></i>
                    </button>
                @endif
                <div class="dropdown">
                    <ul class="dropdown-menu float-end" role="menu">
                        <li>
                            <a class="dropdown-item" href="{{ route('admin.auth.user.index') }}"><i class="fa fa-user" aria-hidden="true"></i>@lang('menus.backend.access.users.all')</a>
                        </li>
                        @can('backend admin')
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.auth.user.create') }}"><i class="fa fa-plus" aria-hidden="true"></i>@lang('menus.backend.access.users.create')</a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.auth.user.deactivated') }}"><i class="fa fa-power-off" aria-hidden="true"></i>@lang('menus.backend.access.users.deactivated')</a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.auth.user.deleted') }}"><i class="fa fa-trash-o" aria-hidden="true"></i>@lang('menus.backend.access.users.deleted')</a>
                            </li>
                        @endcan
                    </ul>
                </div>
            </div>
        </div>
    </div>
@endif
