@php
$layoutMode = 'split';
$sections = $__env->getSections();
if (isset($sections['layout_mode'])) {
    $layoutMode = trim($sections['layout_mode']);
}
@endphp
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', app_name())</title>
    <meta name="description" content="@yield('meta_description', 'Lens Shapers')">
    <meta name="author" content="@yield('meta_author', 'Lens Shapers')">
    @yield('meta')
    @stack('before-styles')

    <link rel="shortcut icon" href="{{ asset('assets/img/favicon.ico') }}" />

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    @if($layoutMode == 'split')
        <script src="https://js.pusher.com/4.1/pusher.min.js"></script>
        <script src="//cdn.ckeditor.com/4.22.1/full-all/ckeditor.js"></script>
        <script src="https://unpkg.com/@popperjs/core@2"></script>
        <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
        @endif
   
        @vite(['resources/css/app.css', 'resources/js/app.js'])
   
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
   
        @stack('after-styles')
    <script type="text/javascript">
        var baseUrl = "<?= url('') ?>";
    </script>
</head>
<body class="@if($layoutMode == 'app')page-header-fixed page-sidebar-closed-hide-logo page-content-white @else page-header-fixed page-sidebar-closed-hide-logo frontend @endif">
    @if($layoutMode == 'split')
        <div class="chatpageloader loader">
            <div class="lds-ring">
            </div>
        </div>
    @endif
    @include('includes.partials.messages')
    @if($layoutMode == 'app')
        <div class="page-wrapper">
            @include('frontend.includes.header')
            <div class="page-container">
                @include('frontend.includes.sidebar')
                <div class="page-content-wrapper">
                    <div class="page-content">
                        {!! Breadcrumbs::render() !!}
                        @yield('content')
                    </div>
                </div>
            </div>
            @include('frontend.auth.orders.includes.message-modal')
            @include('frontend.includes.footer')
        </div>
    @else
        <div class="wrapper split-wrapper">
            <header class="page-header custom-page-header split-header">
                @include('frontend.includes.split-header')
            </header>
            <div class="split-content">
                <div class="container-fluid p-0">
                    <div class="page-content">
                        <div class="breadcrumbs">
                            {{-- {!! Breadcrumbs::render() !!} --}}
                        </div>
                        @php
                            $stickyMsg = auth()->user()->getCustomerAdmin()->getStickyMessage();
                        @endphp
                        @if(!empty($stickyMsg))
                            <div class="col-12">
                                <div class="alert alert-danger" role="alert" style="    font-size: 25px;text-align: center;">
                                  <i class="fa fa-info-circle"></i> {{ $stickyMsg }}
                                </div>
                            </div>
                        @endif
                        {!! $content ?? '' !!}@yield('content')
                    </div>
                </div>
            </div>
            <footer class="split-footer">
                @include('frontend.includes.footer')
            </footer>
            @include('frontend.auth.orders.includes.message-modal')
        </div>
    @endif

    <!-- Scripts -->
    @stack('before-scripts')
    @if($layoutMode == 'app')
        <script type="text/javascript">
            var validateUrl = "<?= route('frontend.user.validate') ?>";
            var loginUrl = "<?= route('login') ?>";
            $(function() {
                $.ajax({
                    url: validateUrl,
                    type: "GET",
                    cache: false,
                    error: function (request, status, error) {
                        window.location.replace(loginUrl);
                    }
                });
            });
        </script>
    @else
        <script type="text/javascript"> let portalType = 'customer'; </script>
        <script type="text/javascript">
            var validateUrl = "<?= route('frontend.user.validate') ?>";
            var loginUrl = "<?= route('login') ?>";
            var userId = "<?= auth()->user()->id ?>";
            var isSuperAdmin = false;
            var notificationChannel = null;
            var PhoneLog = {
                TYPE_ORDER_CANCELLATION: 'order_cancellation',
                TYPE_REQUEST_CHANGE: 'request_change',
                TYPE_PHONE_LOG: 'phone_log',
                TYPE_NOTE: 'notes',
                TYPE_QUESTION: 'questions'
            };
            var pusher = new Pusher("{{ config('app.pusher.key') }}", {
                cluster: "{{ config('app.pusher.options.cluster') }}",
                encrypted: true
            });
            notificationChannel = pusher.subscribe("{{ Auth::user()->getChannelId() }}");
            window.isLoaderStop = true;
            window.isLoaderFStop = false;
            document.addEventListener('DOMContentLoaded', function() {
                $('.loader').hide();
                $.ajax({
                    url: validateUrl,
                    type: "GET",
                    cache: false,
                    error: function (request, status, error) {
                        window.location.replace(loginUrl);
                    }
                });
            });
        </script>
    @endif
    @stack('after-scripts')
</body>
</html>