@extends('frontend.layouts.split')

@section('title', 'Settings' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
    <div class="profile">
        <div class="row profile-account">
            <div class="col-md-2">
                <ul class="ver-inline-menu tabbable margin-bottom-10">
                    <li class="active">
                        <a data-toggle="tab" href="#tab_1-1">
                            <i class="fa fa-user"></i> Account </a>
                            <!-- <i>{!! svg_image('menu-account.svg', 'svg-icons-order', 'Account') !!}</i> @lang('Account') -->
                        <!-- </a> -->
                        <span class="after"> </span>
                    </li>
                    <li>
                        <a data-toggle="tab" href="#change-password">
                           <i class="fa fa-lock"></i> Password </a>
                            <!-- <i>{!! svg_image('password.svg', 'svg-icons-order', 'Password') !!}</i> @lang('Password') -->
                        <!-- </a> -->
                    </li>
                    <li>
                        <a data-toggle="tab" href="#tab_2-2">
                         <i class="fa fa-picture-o"></i> Logo </a>
                            <!-- <i>{!! svg_image('menu-logo.svg', 'svg-icons-order', 'Logo') !!}</i> @lang('Logo') -->
                        <!-- </a> -->
                    </li>
                    @can('frontend admin')
                        <li>
                            <a data-toggle="tab" href="#staff_member" data-url="{{ route('frontend.user.account.tabs.users') }}">
                                <i class="fa fa-users"></i> Staff </a>
                                <!-- <i>{!! svg_image('menu-staff.svg', 'svg-icons-order', 'Staff') !!}</i> @lang('Staff') -->
                            <!-- </a> -->
                        </li>
                        <li>
                            <a data-toggle="tab" href="#tab_3-4">
                               <i class="fa fa-bell"></i> Notifications </a>
                                <!-- <i>{!! svg_image('notification.svg', 'svg-icons-order', 'Notifications') !!}</i> @lang('Notifications') -->
                            <!-- </a> -->
                        </li>
                    @endcan
                </ul>
                
            </div>
            <div class="col-md-10" >
                <div class="tab-content" data-set-height="no">
                    {{-- ===== FORM 1 ===== --}}

                    <div id="tab_1-1" class="tab-pane active">
                        @include('frontend.user.account.tabs.edit')</div>

                    <div id="tab_2-2" class="tab-pane">
                        @include('frontend.user.account.tabs.profile')</div>

                    {{-- ===== FORM 2 ===== --}}
                    <div id="change-password" class="tab-pane">
                        @include('frontend.user.account.tabs.change-password')
                    </div>
                    @can('frontend admin')
                        <div id="staff_member" class="tab-pane">
                            @include('frontend.user.account.tabs.users',['users'=>$users,'pageCount'=>$pageCount])
                        </div>
                        <div id="tab_3-4" class="tab-pane">
                            @include('frontend.user.account.tabs.settings',['settings'=>$settings])
                        </div>
                    @endcan
                </div>
            </div>
            <!--end col-md-9-->
        </div>
    </div>
@push('after-scripts')
<script>
    $(function() {
        // Manual tab switching to avoid Bootstrap conflicts
        $('.ver-inline-menu li a').on('click', function(e) {
            e.preventDefault();

            // Remove active class from all tabs
            $('.ver-inline-menu li').removeClass('active');

            // Add active class to clicked tab
            $(this).parent('li').addClass('active');

            // Hide all tab panes
            $('.tab-content .tab-pane').removeClass('active');

            // Show the target tab pane
            var target = $(this).attr('href');
            var url = $(this).data('url');

            if (url) {
                // Fetch content via AJAX
                $.get(url, function(data) {
                    $(target).html(data);
                    $(target).addClass('active');
                });
            } else {
                $(target).addClass('active');
            }
        });

        // $("input:not([type=password]), select").on('change', function () {
        $("#date_of_birth, #religion").on('change', function () {
            let form = $(this).closest('form');
            $.ajax({
                url: form.attr('action'),
                type: "POST",
                data:form.serialize(),
                success: function(response){
                    if(response.status){
                        toastr.success(response.message);
                    }else{
                        toastr.error(response.message);
                    }
                },
                error: function(error){
                    toastr.error('Something went wrong. Please try again later!')
                }
            });
        });
        if($('.profile-main-tabs li.active a').attr('href') == '#overview'){
            $('.navbar-responsive-collapse .nav li').removeClass('open');
            $('#notification-header-link').addClass('open');
        }
        flatpickr('#date_of_birth', {
            dateFormat: 'Y-m-d'
        });

        setTimeout(function(){ $(document).scrollTop(0); }, 50);
    });
</script>
@endpush
@endsection
