<?php 
use App\Models\Backend\UserProfile;
?>
{{ html()->modelForm($logged_in_user, 'POST', route('frontend.user.profile.update'))->class('form-horizontal enable_change_btn')->attribute('enctype', 'multipart/form-data')->open() }}
@method('PATCH')
<input type="hidden" name="steps" value="personal_info">
<div class="form-body">
    <div class="row m-0">
        <div class="col-md-6" style="padding-right: 18px;">
            <div class="form-group">
                {{ html()->label(__('validation.attributes.frontend.first_name'))->for('first_name') }}

                @if($user->isCustomerAdmin())
                    {{ html()->text('first_name')
                        ->class('form-control common-form-control')
                        ->placeholder(__('validation.attributes.frontend.first_name'))
                        ->attribute('maxlength', 191)
                        ->attribute('readonly', true)
                        ->required() }}
                @else
                    {{ html()->text('first_name')
                        ->class('form-control common-form-control')
                        ->placeholder(__('validation.attributes.frontend.first_name'))
                        ->attribute('maxlength', 191)
                        ->required() }}
                @endif
            </div>
        </div>
        <div class="col-md-6" style="padding-left: 18px;">
            <div class="form-group">
                {{ html()->label(__('validation.attributes.frontend.last_name'))->for('last_name') }}


                @if($user->isCustomerAdmin())
                    {{ html()->text('last_name')
                        ->class('form-control common-form-control')
                        ->placeholder(__('validation.attributes.frontend.last_name'))
                        ->attribute('maxlength', 191)
                        ->attribute('readonly', true)
                        ->required() }}
                @else
                    {{ html()->text('last_name')
                        ->class('form-control common-form-control')
                        ->placeholder(__('validation.attributes.frontend.last_name'))
                        ->attribute('maxlength', 191)
                        ->required() }}
                @endif
            </div>
        </div>
        <div class="col-md-6" style="padding-right: 18px;">
            <div class="form-group">
                {{ html()->label('Account Code')->for('ac_code') }}

                {{ html()->text('ac')
                    ->class('form-control')
                    ->placeholder('Account Code')
                    ->attribute('maxlength', 191)
                    ->value($user->ac_code)
                    ->attribute('disabled', 'disabled')
                    ->required() }}
            </div>
        </div>
        @if($user->isCustomerAdmin())
            <div class="col-md-6">
                <div class="form-group lable-style">
                    {{ html()->label(__('Birthday'))->for('date_of_birth') }}
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fa fa-calendar"></i>
                        </span>
                        <input type="text" name="date_of_birth" id="date_of_birth" class="form-control" placeholder="Birthday" value="{{ $profile->date_of_birth }}" maxlength="191" data-date-format="yyyy-mm-dd">
                    </div>
                </div>
            </div> 
            <div class="col-md-6" style="padding-right: 18px;">
                <div class="form-group">
                    {{ html()->label(__('validation.attributes.frontend.email'))->for('email') }}

                    {{ html()->email('email')
                        ->class('form-control common-form-control')
                        ->placeholder(__('validation.attributes.frontend.email'))
                        ->attribute('maxlength', 191)
                        ->attribute('readonly', true)
                        ->required() }}
                </div>
            </div>                           
            <div class="col-md-6">
                <div class="form-group">
                    {{ html()->label(__('Celebrates Holidays'))->for('religion') }}
                    <select name="religion[]" id="religion" class="form-control common-form-control select2" multiple>
                        <option value="">Please Select</option>
                        <?php 
                            $religion = !empty($profile->religion) ? json_decode($profile->religion,1) : [];
                        ?>
                        @foreach (UserProfile::getReligionArrayLabel() as $key => $value)
                            <option value="{{ $value->name }}" <?= in_array($value->name, $religion) ? 'selected' : '' ?>>{{ $value->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    {{ html()->label(__('Business Name'))->for('business_name') }}
                    {{ html()->text('business_name')
                        ->class('form-control common-form-control')
                        ->placeholder(__('Business Name'))
                        ->value($profile->business_name)
                        ->attribute('maxlength', 191)
                        ->attribute('readonly', true)
                            }}
                </div>
            </div>
            <div class="col-md-6" style="padding-left: 18px;">
                <div class="form-group">
                    {{ html()->label(__('Address Line 1'))->for('address1') }}
                    {{ html()->text('address1')
                        ->class('form-control common-form-control')
                        ->placeholder(__('Address'))
                        ->value($profile->address1)
                        ->attribute('maxlength', 191)
                        ->attribute('readonly', true)
                         }}
                </div>
            </div>                            
            <div class="col-md-6">
                <div class="form-group">
                    {{ html()->label(__('Address Line 2'))->for('address2') }}
                    {{ html()->text('address2')
                            ->class('form-control common-form-control')
                            ->placeholder(__('Address'))
                            ->value($profile->address2)
                            ->attribute('maxlength', 191)
                            ->attribute('readonly', true) }}
                </div>
            </div>
            <div class="col-md-6" style="padding-left: 18px;">
                <div class="form-group">
                    {{ html()->label(__('City'))->for('city') }}
                    {{ html()->text('city')
                        ->class('form-control common-form-control')
                        ->placeholder(__('city'))
                        ->value($profile->city)
                        ->attribute('maxlength', 191) 
                        ->attribute('readonly', true) }}
                </div>
            </div>                            
            <div class="col-md-6">
                <div class="form-group">
                    {{ html()->label(__('Province'))->for('state') }}
                        {{ html()->text('state')
                            ->class('form-control common-form-control')
                            ->placeholder(__('Province'))
                            ->value($profile->state)
                            ->attribute('maxlength', 191)
                            ->attribute('readonly', true) }}
                </div>
            </div>
            <div class="col-md-6" style="padding-left: 18px;">
                <div class="form-group">
                    {{ html()->label(__('Country'))->for('country') }}
                        {{ html()->text('country')
                            ->class('form-control')
                            ->placeholder(__('Country'))
                            ->value($profile->country)
                            ->attribute('readonly', true)
                            ->attribute('maxlength', 191) }}
                </div>
            </div>                            
            <div class="col-md-6">
                <div class="form-group">
                    {{ html()->label(__('Postal Code'))->for('zip_code') }}
                        {{ html()->text('zip_code')
                            ->class('form-control common-form-control')
                            ->placeholder(__('Postal Code'))
                            ->value($profile->zip_code)
                            ->attribute('maxlength', 191)
                            ->attribute('readonly', true) }}
                </div>
            </div>
            <div class="col-md-6" style="padding-left: 18px;">
                <div class="form-group">
                    {{ html()->label(__('Phone'))->for('phone') }}
                    {{ html()->text('phone2')
                        ->class('form-control common-form-control')
                        ->placeholder(__('(+1) XXX-XXX-XXXX'))
                        ->value($profile->phone ? formatPhone($profile->phone) : '')
                        ->attribute('maxlength', 17) 
                        ->attribute('readonly', true) }}
                </div>
            </div>                            
            <div class="col-md-6">
                <div class="form-group">
                    {{ html()->label(__('Fax'))->for('fax') }}
                    {{ html()->text('fax')
                        ->class('form-control common-form-control')
                        ->placeholder(__('(+1) XXX-XXX-XXXX'))
                        ->value($profile->fax ? formatPhone($profile->fax) : '')
                        ->attribute('maxlength', 17) 
                        ->attribute('readonly', true) }}
                </div>
            </div>
        @endif
    </div>
</div>
{{ html()->closeModelForm() }}
@if($user->isCustomerAdmin())
    <div class="operation-container">
        <span class="btn red btn_request_change" id="requestChangeBtn" onclick="requestChange()">Request Change</span>
        <span class="btn green btn_submit" id="submitBtn" style="display:none;" onclick="submitChange()">Submit</span>
        <span class="btn red btn_cancel" id="cancelBtn" style="display:none;" onclick="cancelChange()">Cancel</span>
    </div>
@endif

