<div class="row row-top-margin">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-users font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> Staff Management </span>
                </div>
                <div class="actions">
                    @include('frontend.user.includes.header-buttons')
                </div>
            </div>
            <div class="portlet-body">
                <div class="order-list staff-users-list">
                    <div class="row">
                        <div class="col-md-4 p-0 table-data-container">
                            @include('partials.user-table', compact('users', 'pageCount'))
                        </div>
                        <div class="col-md-8">
                            <div class="tabbable-custom nav-justified order-details-container box-shadow">
                                    <ul class="nav nav-pills nav-justified">
                                        <li class="nav-item">
                                            <a href="#tab_order" data-toggle="tab" class="nav-link active tab_order">Overview</a>
                                        </li>
                                         <li class="nav-item">
                                            <a href="#permissions" data-toggle="tab" class="data-tabs nav-link permissions" data-value="permissions" data-id="comment-tab-wrapper"> Permissions </a>
                                        </li>
                                    </ul>
                                    <div class="tab-content">
                                        <div class="tab-pane active" id="tab_order">
                                            <center><h3>
                                                {{ !empty($users) ? 'Choose Staff Member on Left to See Details...' : 'No Staff Members' }}
                                            </h3></center>
                                        </div>
                                         <div class="tab-pane" id="permissions">
                                              <div id="permissions-tab-wrapper" class="d-none">
                                                 {{ html()->form('PATCH', route('frontend.user.profile.update'))->open() }}
                                                    <input type="hidden" name="user_id" value="" id="staff_user_id">
                                                    <input type="hidden" name="steps" value="staff_permissions">
                                                    <div class="row">
                                                        <div class="col-md-2"></div>
                                                        <div class="col-md-4">
                                                            <div class="input-group">
                                                                <div class="md-checkbox-list">
                                                                    <div class="md-checkbox">
                                                                        <input type="checkbox" class="md-check" name="permission_order_placed" id="permission_order_placed">
                                                                        <label for="permission_order_placed">
                                                                            <span></span>
                                                                            <span class="check"></span>
                                                                            <span class="box"></span> Place Orders</label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="input-group">
                                                                <div class="md-checkbox-list">
                                                                    <div class="md-checkbox">
                                                                        <input type="checkbox" class="md-check" name="permission_prices_invoices" id="permission_prices_invoices">
                                                                        <label for="permission_prices_invoices">
                                                                            <span></span>
                                                                            <span class="check"></span>
                                                                            <span class="box"></span> See Prices & Invoices</label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                    </div>
                                                {{ html()->form()->close() }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>

@push('after-scripts')
<script type="text/javascript">
    $(function() {
        $(document).on('switchChange.bootstrapSwitch','#staff_enable',function(){
            let status = this.checked;
            let user_id = $(this).attr('data-user_id');
            $.ajax({
                url: "{{route('frontend.user.profile.update')}}",
                type: "PATCH",
                data:{status,status,_token: $('meta[name="csrf-token"]').attr('content'),steps:"update_status",user_id:user_id},
                success: function(data){
                    if(data.status){
                        toastr.success(data.message);
                    }
                    else
                        toastr.error(data.message);
                },
            });
        });
        $(document).on('change','#staff_change_password',function(){
            swal({
                title: "Are you sure, you want to change password?",
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes",
                cancelButtonText: "No",
                // closeOnConfirm: false,
                // closeOnCancel: false,
                }, function(isConfirm){
                    if (isConfirm) {
                        let password = $('#staff_change_password').val();
                        let user_id = $('#staff_change_password').attr('data-user_id');
                        $.ajax({
                            url: "{{route('frontend.user.profile.update')}}",
                            type: "PATCH",
                            data:{password,password,_token: $('meta[name="csrf-token"]').attr('content'),steps:"update_staff_password",user_id:user_id},
                            success: function(data){
                                if(data.status){
                                    $('#staff_change_password').val('')
                                    toastr.success(data.message);
                                }
                                else
                                    toastr.error(data.message);
                            },
                        });
                    }
                }
            );
        });
    });
</script>
@endpush