<input type="hidden" name="invoice_order_no" id="invoice_order_no" value="{{ $order->invoice_no }}">
@if($order->type != 'rx')
    <div class="print-btn-container">
        @if($isCustomerAdmin)
            <button class="btn blue print_order-btn" data-url="{{ route('frontend.user.orders.print', $order) }}"><i class="fas fa-print"></i> Print</button>
        @else
            @if(Auth::user()->hasRole('administrator'))
                <div class="labzilla-order-btn">
                    <button class="btn blue float-right lab-order-model" type="submit">Labzilla Call</button>
                    <button class="btn green float-right lab-order-submit" type="submit">Send to Labzilla</button>
                </div>
            @endif
            <button class="btn red print_order-btn" data-url="{{ route('admin.order.print', $order) }}">Print Local</button>
            <button class="btn blue print_order-btn" data-url="{{ route('admin.order.upload-print', $order) }}">Print</button>
        @endif
    </div>
@else
    <div class="print-btn-container">
        @if($order->isSaved())
            <a class="btn red" href="{{route('frontend.user.orders.destroy',$order)}}"><i class="fa fa-trash"></i> Delete</a>
            <a class="btn blue" href="{{route('frontend.user.new-rx-lens-order')}}?edit={{ $order->id }}"><i class="fa fa-pencil"></i> Edit</a>
        @else
            @if($isCustomerAdmin)
                <button class="btn blue print_order-btn" data-url="{{route('frontend.user.orders.print',$order)}}"><i class="fas fa-print"></i> Print</button>
                @if(!$order->isOffline() && !$order->isLegacy())
                    <a class="btn red" href="{{route('frontend.user.new-rx-lens-order')}}?reuse={{ $order->id }}" target="_blank"><i class="fas fa-recycle"></i> Reuse</a>
                    @if($order->isWebOrder())
                        <button class="btn green redo_order-btn" data-id="{{ $order->id }}"><i class="fas fa-redo"></i> Start Redo</button>
                    @endif
                @else
                    @if(!auth()->user()->isCustomerStaff())
                        <span data-toggle="tooltip" title="Not available for this order">
                        <button class="btn red" disabled>
                            <i class="fas fa-recycle"></i> Reuse
                        </button>
                        </span>

                        <span data-toggle="tooltip" title="Not available for this order">
                        <button class="btn green" disabled>
                            <i class="fas fa-redo"></i> Start Redo
                        </button>
                        </span>
                    @endif
                @endif
            @else
                @if(Auth::user()->hasRole('administrator'))
                    <div class="labzilla-order-btn">
                        <button class="btn blue float-right lab-order-model" type="submit">Labzilla Call</button>
                        <button class="btn green float-right lab-order-submit" type="submit">Send to Labzilla</button>
                    </div>
                @endif
                <button class="btn red print_order-btn" data-url="{{ route('admin.order.print', $order) }}">Print Local</button>
                <button class="btn blue print_order-btn" data-url="{{ route('admin.order.upload-print', $order) }}">Print</button>
            @endif
        @endif
    </div>
@endif
