<?php
$showButtons = $showButtons ?? false;
$data = $log->replyModel();
$logs = $data['logs'];
$currentUser = $data['user'];
$isCurrentUser = $log->user_id == auth()->id();
$isDeleteAllowed = $log->created_at->diffInSeconds(now()) <= 30;
$isAdmin = auth()->user()->isAdmin();
$senderClass = $isCurrentUser ? ($isAdmin ? 'sender-admin' : 'sender-customer') : ($isAdmin ? 'sender-customer' : 'sender-admin');
$ownerClass = $isCurrentUser ? 'current-user' : '';
?>
<li class="media comment comment-{{ $log->id }} main-comment {{ $ownerClass }}" 
    data-id="{{ $log->id }}" 
    data-owner="{{ $isCurrentUser ? 'current-user' : 'other-user' }}"
    data-sender="{{ $isAdmin ? 'admin' : 'customer' }}">
    
    <div class="media-body todo-comment">
        <div class="comment-header">
            @if($log->getProfileImage())
                <img class="todo-userpic comment-avatar" src="{{ $log->getProfileImage() }}" width="32" height="32">
            @endif
            <div class="user-info">
                <span class="todo-comment-username">{{ $log->user->full_name }}</span>
                <span class="todo-comment-date">
                    {{ $log->created_at->diffForHumans() }}
                </span>
            </div>
            @if($log->isQuestion())
                <span class="comment-type badge-info float-right">{!! $log->getIcon() !!} Order Enquiry</span>
            @elseif($log->isRequestChange())
                <span class="comment-type badge-warning float-right">{!! $log->getIcon() !!} Order Change</span>
            @elseif($log->isRequestCancellation())
                <span class="comment-type badge-danger float-right">{!! $log->getIcon() !!} Order Cancellation</span>
            @elseif($log->isPhoneLog())
                <span class="comment-type badge text-bg-secondary float-right">{!! $log->getIcon() !!} Phone Log</span>   
            @else
                <span class="comment-type badge text-bg-secondary float-right">{!! $log->getIcon() !!}Private Note</span>
            @endif
        </div>
        
        <p class="comment-content">
            {{ $log->description }}
        </p>
        @if($showButtons && $isCurrentUser && $isDeleteAllowed)
        <div class="comment-actions-append">
            <a data-id="{{ $log->id }}" class="comment-action comp-cmt-tab-edit-btn" data-time="{{ $log->created_at }}">
                <i class="fa fa-pencil"></i> Edit
            </a>
            <a data-id="{{ $log->id }}" class="comment-action comp-cmt-tab-delete-btn" data-time="{{ $log->created_at }}">
                <i class="fa fa-trash"></i> Delete
            </a>
        </div>
        @endif

        <!-- Replies Container -->
        <div class="replies-container">
            @foreach($logs as $reply)
                @if($reply['replied'] == $log->id)
                <?php 
                    $isReplyCurrentUser = $reply['user_id'] == auth()->id();
                    $replySenderClass = $isReplyCurrentUser ? ($isAdmin ? 'sender-admin' : 'sender-customer') : ($isAdmin ? 'sender-customer' : 'sender-admin');
                    $replyOwnerClass = $isReplyCurrentUser ? 'current-user' : '';
                ?>
                <div class="media comment comment-{{ $reply['id'] }} reply {{ $replyOwnerClass }}" 
                     data-id="{{ $reply['id'] }}" 
                     data-owner="{{ $isReplyCurrentUser ? 'current-user' : 'other-user' }}"
                     data-sender="{{ $isReplyCurrentUser ? ($isAdmin ? 'admin' : 'customer') : ($isAdmin ? 'customer' : 'admin') }}">
                    <div class="media-body todo-comment">
                        <div class="comment-header">
                            @if($reply['user']['avatar_location'])
                                <img class="todo-userpic comment-avatar" 
                                    src="{{ asset('storage/app/public/'.$reply['user']['avatar_location']) }}" 
                                    width="32" height="32">
                            @endif
                            <div class="user-info">
                                <span class="todo-comment-username">{{ $reply['user']['full_name'] }}</span>
                                <span class="todo-comment-date">
                                    {{ \Carbon\Carbon::parse($reply['created_at'])->diffForHumans() }}
                                </span>
                            </div>
                        </div>
                        <p class="comment-content">
                            {{ $reply['description'] }}
                            @if($isReplyCurrentUser && \Carbon\Carbon::parse($reply['created_at'])->diffInSeconds(now()) <= 30)
                                 <div class="comment-actions-append-reply">
                                    <a data-id="{{ $reply['id'] }}" class="comment-action comp-cmt-tab-edit-btn" data-time="{{ $reply['created_at'] }}">
                                        <i class="fa fa-pencil"></i> Edit
                                    </a>
                                    <a data-id="{{ $reply['id'] }}" class="comment-action comp-cmt-tab-delete-btn" data-time="{{ $reply['created_at'] }}">
                                        <i class="fa fa-trash"></i> Delete
                                    </a>
                                </div>
                            @endif
                        </p>
                    </div>
                </div>
                @endif
            @endforeach
        </div>

        @unless($log->replied)
        @if($log->type != 'notes')
            <div class="comment-actions">
                <a class="action-btn cmnt-reply-yes" data-id="{{ $log->id }}" data-oid="{{ $log->order_id }}">
                    <i class="fa fa-check"></i> Yes
                </a>
                <a class="action-btn cmnt-reply-no" data-id="{{ $log->id }}" data-oid="{{ $log->order_id }}">
                    <i class="fa fa-times"></i> No
                </a>
                <a class="action-btn cmnt-reply-ok" data-id="{{ $log->id }}" data-oid="{{ $log->order_id }}">
                    <i class="fa fa-check-square-o"></i> OK
                </a>
                <a class="action-btn cmnt-reply-done" data-id="{{ $log->id }}" data-oid="{{ $log->order_id }}">
                    <i class="fa fa-check-square-o"></i> Done
                </a>
                <a class="action-btn cmnt-reply" data-id="{{ $log->id }}" data-oid="{{ $log->order_id }}">
                    <i class="fa fa-reply"></i> Reply
                </a>
            </div>
            <div class="reply-form-container" style="display: none;">
                <textarea class="form-control reply-textarea" placeholder="Type your reply..."></textarea>
                <div class="float-end">
                    <button class="btn red btn-sm cancel-reply">Cancel</button>
                    <button class="btn btn-primary btn-sm submit-reply" data-id="{{ $log->id }}" data-oid="{{ $log->order_id }}">Send</button>
                </div>
            </div>
        @endif
        @endunless
    </div>
</li>