@php
    $isCustomerAdmin = auth()->user()->hasRole('customer_admin') ? auth()->user()->hasRole('customer_admin') : auth()->user()->hasRole('customer_staff');
    $user = $order->user;
    $orderNumber = $isCustomerAdmin ? $order->getOfflineOrderNumber() : $order->getOrderNumber();
    $consumables = $order->consumableModals;
@endphp

    {{-- Print invoice button --}}
    <div class="order-info-container">
        {{--  Order Information --}}
        @include('partials.ordersummary.details',[
            'isCustomerAdmin' => $isCustomerAdmin,
            'order' => $order,
            'type' => 'consumables',
            'user' => $user
        ])

        {{-- Order item detials --}}
        <div class="order-summary-container">
            <div class="section-header">
                <span>Consumables</span>
                @if(!$isCustomerAdmin)
                    <div class="lens-price-col">Price</div>
                @endif
            </div>
            @if ($consumables->count() > 0)
                @php  $totalPrice = 0; @endphp
                @foreach ($consumables as $item)
                    @php
                        if (!$isCustomerAdmin) {
                            $totalPrice += $item->price ? (float)$item->price : 0;
                        }
                    @endphp
                    <div class="order-summary-item">
                        <span class="order-summary-quantity">{{ $item->quantity }}x</span>
                        <span class="order-summary-details">{{ $item->name }} - {{ $item->sub_name }}</span>
                        @if(!$isCustomerAdmin)
                            @if(!empty($item->price))
                                <div class="lens-price-col">${{ $item->price ? number_format($item->price, 2) : '' }}</div>
                            @endif
                        @endif
                    </div>
                @endforeach
            @else
                <div class="no-order-summary">No Consumables Found</div>
            @endif
        </div>
        @if(!$isCustomerAdmin)
            <div class="total-price-container">
                <div class="total-price-label">Total:</div>
                <div class="total-price-value">${{ number_format($totalPrice, 2) }}</div>
            </div>
        @endif
    </div>
      @include('partials.actions.printbtn',[
            'isCustomerAdmin' => $isCustomerAdmin,
            'order' => $order
        ])
