<div class="form-group">
    <label for="">Customer</label>
    <input type="text" class="form-control customer-loading" placeholder="Loading..." disabled style="background-color: #f8f9fa;">
    <select class="form-control customer-select customer-static" name="user_ids[]" multiple data-placeholder="Choose Multiple Users..." style="display: none;">
        @if(isset($customers) && is_array($customers))
            @foreach($customers as $customer)
                <option value="{{ $customer['id'] }}">{{ $customer['text'] }}</option>
            @endforeach
        @endif
    </select>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    function initCustomerSelect() {
        if (typeof window.jQuery === 'undefined' || typeof window.jQuery.fn.select2 === 'undefined') {
            setTimeout(initCustomerSelect, 100);
            return;
        }
        window.jQuery('.customer-loading').hide();
        window.jQuery('.customer-static').show().select2({
            minimumInputLength: 0,
            multiple: true,
            allowClear: true,
            placeholder: 'Choose Multiple Users...'
        });
    }
    setTimeout(initCustomerSelect, 500);
});
</script>