@php
$isCustomerAdmin = auth()->user()->hasRole('customer_admin') ? auth()->user()->hasRole('customer_admin') : auth()->user()->hasRole('customer_staff');
@endphp
    {{-- Print invoice button --}}
    <div class="order-info-container">
        {{--  Order Information --}}
        @include('partials.ordersummary.details',[
            'isCustomerAdmin' => $isCustomerAdmin,
            'order' => $order,
            'type' => 'stock',
            'stockOrder' => $stockOrder
        ])
        {{-- Order item detials --}}
        @if($stockOrder->r_quantity || $stockOrder->l_quantity)
            <div class="order-summary-container">
                    <div class="lens-order-table {{ $isCustomerAdmin ? 'customer-view' : 'admin-view' }}">
                            <div class="order-summary-table-header">
                                <div class="lens-side-col">Stock Lenses</div>
                                <div class="lens-data-col">Sph</div>
                                <div class="lens-data-col">Cyl</div>
                                <div class="lens-qty-col-main">Qty</div>
                                @if(!$isCustomerAdmin)
                                    <div class="lens-price-col">Price</div>
                                @endif
                            </div>
                            @if($stockOrder->isBoth() || $stockOrder->isRight())
                            <div class="table-row-stock">
                                <div class="lens-side-col">
                                    <span class="lens-side">R</span>
                                    <span class="lens-spec-col">
                                        @if($stockOrder->r_material)
                                            {{ $stockOrder->r_material }}
                                            {{ $stockOrder->r_colour ?: $stockOrder->r_colour }} 
                                            {{ $stockOrder->r_coating ?:$stockOrder->r_coating }}  
                                            {{ $stockOrder->r_size ? $stockOrder->r_size.'mm' : '' }}
                                            @if(!$isCustomerAdmin)
                                                {{ $stockOrder->r_vendor ? '('.$stockOrder->r_vendor.')' : '' }}
                                                {{ $stockOrder->r_cards ? '('.$stockOrder->r_cards.')' : '' }}
                                            @endif
                                        @else
                                            {{ $stockOrder->r_desc ?: $stockOrder->r_desc }}
                                        @endif
                                    </span>
                                </div>
                                <div class="lens-data-col">{{ $stockOrder->r_sph ?? '' }}</div>
                                <div class="lens-data-col">{{ $stockOrder->r_cyl ?? '' }}</div>
                                <div class="lens-qty-col">{{ $stockOrder->r_quantity ? $stockOrder->r_quantity : '' }}</div>
                                @if(!$isCustomerAdmin)
                                    @if(!empty($stockOrder->r_price))
                                        <div class="lens-price-col">${{ $stockOrder->r_price ? number_format($stockOrder->r_price, 2) : '' }}</div>
                                    @endif
                                @endif
                            </div>
                            @endif
                            @if($stockOrder->isBoth() || $stockOrder->isBarcode() || $stockOrder->isLeft())
                            <div class="table-row-stock">
                                <div class="lens-side-col">
                                    <span class="lens-side">L</span>
                                    <span class="lens-spec-col">
                                        @if($stockOrder->l_material)
                                            {{ $stockOrder->l_material }}
                                            {{ $stockOrder->l_colour ?: $stockOrder->l_colour }} 
                                            {{ $stockOrder->l_coating ?: $stockOrder->l_coating }}  
                                            {{ $stockOrder->l_size ? $stockOrder->l_size.'mm' : '' }}
                                            @if(!$isCustomerAdmin)
                                                {{ $stockOrder->l_vendor ? '('.$stockOrder->l_vendor.')' : '' }}
                                                {{ $stockOrder->l_cards ? '('.$stockOrder->l_cards.')' : '' }}
                                            @endif
                                        @else
                                            {{ $stockOrder->l_desc ?: $stockOrder->l_desc }}
                                        @endif
                                    </span>
                                </div>
                                <div class="lens-data-col">{{ $stockOrder->l_sph ?? '' }}</div>
                                <div class="lens-data-col">{{ $stockOrder->l_cyl ?? '' }}</div>
                                <div class="lens-qty-col">{{ $stockOrder->l_quantity ? $stockOrder->l_quantity : '' }}</div>
                                @if(!$isCustomerAdmin)
                                    @if(!empty($stockOrder->l_price))
                                        <div class="lens-price-col">${{ $stockOrder->l_price ? number_format($stockOrder->l_price, 2) : '' }}</div>
                                    @endif
                                @endif
                            </div>
                            @endif
                        </div>
                    </div>
                    @if(!$isCustomerAdmin)
                        @php
                        $totalPrice = 0;
                        if (!$isCustomerAdmin) {
                            $totalPrice += $stockOrder->r_price ? (float)$stockOrder->r_price : 0;
                            $totalPrice += $stockOrder->l_price ? (float)$stockOrder->l_price : 0;
                        }
                        @endphp
                        <div class="total-price-container">
                            <div class="total-price-label">Total:</div>
                            <div class="total-price-value">${{ number_format($totalPrice, 2) }}</div>
                        </div>
                    @endif
            </div>
             @else
                <div class="text-center mt-5">Order data not available.</div>
            @endif
        </div>
    @include('partials.actions.printbtn',[
            'isCustomerAdmin' => $isCustomerAdmin,
            'order' => $order
        ])

        