@extends('backend.layouts.split')
@section('layout_mode', 'app')

@push('after-styles')
    @include('log-viewer::_template.style')
@endpush

@section('content')
<div class="row row-top-margin">
    <div class="col-md-12">
        <div class="portlet light portlet-fit bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class=" icon-layers font-green"></i>
                    <span class="caption-subject font-green bold uppercase">Log Viewer</span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="row">
                    <div class="col-md-3 col-xs-12">
                        <canvas id="stats-doughnut-chart" height="250"></canvas>
                    </div>
                    <div class="col-md-9">
                        @foreach($percents as $level => $item)
                            <div class="col-md-4 col-sm-6 mb-3">
                                <div class="card level-card level-{{ $level }} {{ $item['count'] === 0 ? 'level-empty' : '' }}">
                                    <div class="card-header">
                                        <span class="level-icon">{!! log_styler()->icon($level) !!}</span> {{ $item['name'] }}
                                    </div>
                                    <hr>
                                    <div class="card-body mt-5">
                                        {{ $item['count'] }} entries - {!! $item['percent'] !!}%
                                        <div class="progress">
                                            <div class="progress-bar" style="width: {{ $item['percent'] }}%"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.18.1/moment-with-locales.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.0/Chart.min.js"></script>
    <script>
        Chart.defaults.global.responsive      = true;
        Chart.defaults.global.scaleFontFamily = "'Source Sans Pro'";
        Chart.defaults.global.animationEasing = "easeOutQuart";
    </script>
    <script>
        $(function() {
            new Chart($('canvas#stats-doughnut-chart'), {
                type: 'doughnut',
                data: {!! $chartData !!},
                options: {
                    legend: {
                        position: 'bottom'
                    }
                }
            });
        });
    </script>
@endpush
