@extends('backend.layouts.split')
@section('layout_mode', 'app')

@push('after-styles')
    @include('log-viewer::_template.style')
@endpush

@section('content-header')
@section('page-header')
@endsection

@section('content')
<h4 class="bold">Log [{{ $log->date }}]</h4>
    <div class="row row-top-margin">
        <div class="col-md-3 col-sm-3">
            @include('log-viewer::_partials.menu')
        </div>
        <div class="col-md-9 col-sm-9">
            {{-- Log Details --}}
            <div class="portlet light portlet-fit bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject font-dark bold uppercase">Log Info:</span>
                    </div>
                    <div class="actions">
                        <div class="btn-group">
                            <a class="btn dark btn-outline btn-circle btn-sm" href="javascript:;" data-toggle="dropdown" data-hover="dropdown" data-close-others="true"> Actions
                                <i class="fa fa-angle-down"></i>
                            </a>
                            <div class="dropdown">
                                <ul class="dropdown-menu float-end" role="menu">
                                    <li>
                                        <a href="{{ route('log-viewer::logs.download', [$log->date]) }}">
                                            <i class="fa fa-download"></i> DOWNLOAD
                                        </a>
                                    </li>
                                    <li>
                                        <a href="#delete-log-modal" data-toggle="modal" data-backdrop="false">
                                            <i class="fa fa-trash"></i> DELETE
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th> File path: </th>
                                <th colspan="3"> {{ $log->getPath() }} </th>
                            </tr>
                        </thead>
                        <tbody> 
                            <tr>
                                <td>Log entries: <span class="label label-sm label-info">{{ $entries->total() }}</span></td>
                                <td>Size: <span class="label label-sm label-info">{{ $log->size() }}</span></td>
                                <td>Created at: <span class="label label-sm label-info">{{ $log->createdAt() }}</span></td>
                                <td>Updated at: <span class="label label-sm label-info">{{ $log->updatedAt() }}</span></td>   
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            {{-- Log Entries --}}
            <div class="portlet light portlet-fit bordered">
                <div class="card mt-4">
                    @if($entries->hasPages())
                        <div class="card-header">
                            <div class="row">
                                <div class="col">
                                    {!! $entries->appends(compact('query'))->render('log-viewer::_pagination.bootstrap-4') !!}
                                </div>
                                <div class="col text-right">
                                    <span class="badge badge-info">
                                        Page {!! $entries->currentPage() !!} of {!! $entries->lastPage() !!}
                                    </span>
                                </div>
                            </div>
                        </div>
                    @endif

                    <div class="card-body" >
                        <div class="table-responsive">
                            <table id="entries" class="table" style="word-break: break-word;">
                                <thead>
                                <tr>
                                    <th>ENV</th>
                                    <th>Level</th>
                                    <th>Time</th>
                                    <th>Header</th>
                                    <th class="text-right">Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                    @forelse($entries as $key => $entry)
                                    <tr>
                                        <td>
                                            <span class="label label-sm badge-env">{{ $entry->env }}</span>
                                        </td>
                                        <td>
                                        <span class="label label-sm level-{{ $entry->level }}">
                                            {!! $entry->level() !!}
                                        </span>
                                        </td>
                                        <td>
                                        <span class="label label-sm badge-default">
                                            {{ $entry->datetime->format('H:i:s') }}
                                        </span>
                                        </td>
                                        <td>
                                        </td>
                                        <td class="text-right">
                                            @if($entry->hasStack())
                                                <a class="btn btn-sm btn-outline-info" role="button" data-toggle="collapse" href="#log-stack-{{ $key }}" aria-expanded="false" aria-controls="log-stack-{{ $key }}">
                                                    <i class="fa fa-toggle-on"></i> Stack
                                                </a>
                                            @endif
                                        </td>
                                        <td></td>
                                    </tr>
                                    @if($entry->hasStack())
                                        <tr class="stack-content collapse" id="log-stack-{{ $key }}">
                                            <td colspan="5" class="stack">
                                                {!! trim($entry->stack()) !!}
                                            </td>
                                        </tr>
                                    @endif
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center">
                                            <span class="badge badge-default">{{ __('log-viewer::general.empty-logs') }}</span>
                                        </td>
                                    </tr>
                                @endforelse
                                </tbody>
                            </table>
                        </div><!--table-responsive-->
                    </div><!--card-body-->
                    @if($entries->hasPages())
                        <div class="card-footer">
                            <div class="row">
                                <div class="col">
                                    {!! $entries->appends(compact('query'))->render('log-viewer::_pagination.bootstrap-4') !!}
                                </div>
                                <div class="col text-right">
                                <span class="badge badge-info">
                                    Page {!! $entries->currentPage() !!} of {!! $entries->lastPage() !!}
                                </span>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div id="delete-log-modal" class="modal fade">
        <div class="modal-dialog">
            <form id="delete-log-form" action="{{ route('log-viewer::logs.delete') }}" method="POST">
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <input type="hidden" name="date" value="{{ $log->date }}">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title bold">Delete Log File</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure you want to <span class="label label-sm label-danger">DELETE</span> this log file <span class="label label-sm label-info">{{ $log->date }}</span> ?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-sm red" data-loading-text="Loading&hellip;"><i class="fa fa-trash"></i> DELETE FILE</button>
                        <button type="button" class="btn btn-sm blue " data-dismiss="modal"><i class="fa fa-times"></i> Cancel</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('after-scripts')
    <script>
        $(function () {
            var deleteLogModal = $('#delete-log-modal'),
                deleteLogForm  = $('#delete-log-form'),
                submitBtn      = deleteLogForm.find('button[type=submit]');

            deleteLogForm.on('submit', function(event) {
                event.preventDefault();
                submitBtn.button('loading');

                $.ajax({
                    url:      $(this).attr('action'),
                    type:     $(this).attr('method'),
                    dataType: 'json',
                    data:     $(this).serialize(),
                    success: function(data) {
                        submitBtn.button('reset');
                        if (data.result === 'success') {
                            deleteLogModal.modal('hide');
                            location.replace("{{ route('log-viewer::logs.list') }}");
                        }
                        else {
                            alert('OOPS ! This is a lack of coffee exception!')
                        }
                    },
                    error: function(xhr, textStatus, errorThrown) {
                        alert('AJAX ERROR ! Check the console !');
                        console.error(errorThrown);
                        submitBtn.button('reset');
                    }
                });

                return false;
            });

            @unless(empty(log_styler()->toHighlight()))
            $('.stack-content').each(function() {
                var $this = $(this);
                var html = $this.html().trim()
                    .replace(/({!! join(log_styler()->toHighlight(), '|') !!})/gm, '<strong>$1</strong>');

                $this.html(html);
            });
            @endunless
        });
    </script>
@endpush
