<?php

use App\Http\Controllers\Backend\DashboardController;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Backend\Auth\OrdersController;
use App\Http\Controllers\Backend\Auth\User\ProfileController;
use App\Http\Controllers\Backend\Auth\User\AccountController;
use App\Http\Controllers\Backend\Auth\ReligionsController;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\Frontend\ContactController;
use App\Http\Controllers\Frontend\User\UserController;
use App\Http\Controllers\Frontend\User\UserStatusController;
use App\Http\Controllers\Frontend\Auth\StatementsController;
use App\Http\Controllers\Frontend\Auth\CreditMemosController;
use App\Http\Controllers\Backend\Auth\EmailTemplateController;
use App\Http\Controllers\Frontend\FilesController;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\Frontend\PushNotificationsController;
use App\Http\Controllers\Backend\Auth\PhoneLogController;
use App\Http\Controllers\Frontend\Auth\LoginController;
use App\Http\Controllers\Backend\Auth\LoginAdminController;
use App\Http\Controllers\Frontend\Auth\RegisterController;
use App\Http\Controllers\Frontend\Auth\SocialLoginController;
use App\Http\Controllers\Frontend\Auth\NotificationController;
use App\Http\Controllers\Frontend\Auth\ResetPasswordController;
use App\Http\Controllers\Frontend\Auth\ConfirmAccountController;
use App\Http\Controllers\Frontend\Auth\ForgotPasswordController;
use App\Http\Controllers\Frontend\Auth\UpdatePasswordController;
use App\Http\Controllers\Frontend\Auth\PasswordExpiredController;

// All route names are prefixed with 'admin.'.
Route::redirect('/dashboard', '/admin/orders', 301);

/*
 * These backend controllers require the user to be logged in
 * All route names are prefixed with 'backend.'
 * These routes can not be hit if the password is expired
 */
Route::group(['middleware' => ['auth', 'admin']], function () {
    Route::group(['as' => 'user.'], function () {

        Route::get('validate-auth', [HomeController::class, 'validateAuth'])->name('validate');
        // User Account Specific
        Route::get('account', [AccountController::class, 'index'])->name('account');

        // Admin Profile Specific
        Route::patch('profile/update', [ProfileController::class, 'update'])->name('profile.update');

        Route::get('notifications', [DashboardController::class, 'notifications'])->name('notifications');
    });

    Route::group(['prefix' => 'orders'], function () {
        Route::get('all', [OrdersController::class, 'index'])->name('orders-all');
        Route::get('', [OrdersController::class, 'list'])->name('orders.list');
        Route::get('rx-lens', [OrdersController::class, 'rxLensOrders'])->name('rx-lens-orders');
        Route::get('tray-lens', [OrdersController::class, 'trayLensOrders'])->name('tray-lens-orders');
        Route::get('stock-lens', [OrdersController::class, 'stockLensOrders'])->name('stock-lens-orders');
        Route::get('barcode-lens', [OrdersController::class, 'barcodeLensOrders'])->name('barcode-lens-orders');
        Route::post('search-barcode-api', [OrdersController::class, 'searchBarcodeApi'])->name('search-barcode-api');
        Route::get('consumeables', [OrdersController::class, 'consumableLensOrders'])->name('consumables-lens-orders');
        Route::get('settings', [OrdersController::class, 'settings'])->name('orders.settings');
        // Route::post('settings', [OrdersController::class, 'settings'])->name('orders.settings.update');
        Route::post('settings', [OrdersController::class, 'settings'])->name('orders.settings');
        Route::post('upload-print/{id}', [OrdersController::class, 'uploadPrint'])->name('order.upload-print');
    });

    Route::get('orders/show/{order}', [OrdersController::class, 'show'])->name('order.show');
    Route::get('orders/print/{order}', [OrdersController::class, 'print'])->name('order.print');
    Route::get('orders/print-pdf/{order}', [OrdersController::class, 'printPdf'])->name('order.print-pdf');
    Route::get('common/details-api/{order}', [CommonController::class, 'detailsApi'])->name('common.detailsApi');
    Route::post('orders/details-type-api', [OrdersController::class, 'detailsTypeApi'])->name('orders.detailsTypeApi');
    Route::get('auth/details-api/{id}/{type}', [DashboardController::class, 'detailsApi'])->name('detailsApi');
    Route::get('common/details-api/{id}/{type}', [DashboardController::class, 'detailsApi'])->name('detailsApi');

    Route::post('dashboard/mark-notification', [DashboardController::class, 'markNotification'])->name('markNotification');
    Route::group(['as' => 'religions.', 'prefix' => 'religions'], function () {
        
        Route::get('list-api', [ReligionsController::class, 'listApi'])->name('list-api');        
        Route::post('store', [ReligionsController::class, 'store'])->name('store');
        Route::post('update-status', [ReligionsController::class, 'updateStatus'])->name('update-status');
        Route::post('update/{id}', [ReligionsController::class, 'update'])->name('update');
        Route::post('destroy', [ReligionsController::class, 'destroy'])->name('destroy');
    });

    
});

// Lab Order routes
Route::group(['middleware' => ['web','auth', 'admin']], function () {
    Route::get('/laborder', [\App\Http\Controllers\API\LabOrderController::class, 'index'])->name('laborder');
    Route::post('/lab-order/push', [\App\Http\Controllers\API\LabOrderController::class, 'pushOrder'])->name('lab-order.push');
    Route::post('/lab-order/data/{orderId}', [\App\Http\Controllers\API\LabOrderController::class, 'getOrderData'])->name('lab-order.data');
    Route::get('/lab-order/check-auth', [\App\Http\Controllers\API\LabOrderController::class, 'checkAuthToken'])->name('lab-order.check-auth');
});