<?php

use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Frontend\PushNotificationsController;
use App\Http\Controllers\Frontend\ContactController;
use App\Http\Controllers\Frontend\User\UserController;
use App\Http\Controllers\Frontend\Auth\OrdersController;
use App\Http\Controllers\Frontend\User\AccountController;
use App\Http\Controllers\Backend\Auth\PhoneLogController;
use App\Http\Controllers\Frontend\User\ProfileController;
use App\Http\Controllers\Frontend\User\DashboardController;
use App\Http\Controllers\Frontend\User\UserStatusController;
use App\Http\Controllers\Frontend\Auth\StatementsController;
use App\Http\Controllers\Frontend\Auth\CreditMemosController;
use App\Http\Controllers\Backend\Auth\EmailTemplateController;
use App\Http\Controllers\Frontend\FilesController;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\CommonController;
use Illuminate\Support\Facades\Route;

/*
 * Frontend Routes
 * All route names are prefixed with 'frontend.'
 */
Route::get('/', [HomeController::class, 'index'])->name('frontend.index');
Route::get('/run-import', [HomeController::class, 'runImport'])->name('frontend.run-import');
// Route::get('/files', [ApiController::class, 'dropbox']);

Route::get('/contact', [ContactController::class, 'index'])->name('frontend.contact');
Route::post('/contact/send', [ContactController::class, 'send'])->name('frontend.contact.send');

/*
 * These frontend routes require the user to be logged in
 * All route names are prefixed with 'frontend.'
 * These routes cannot be hit if the password is expired
 */
Route::get('/files/orders/{id}', [FilesController::class, 'orders'])->name('files.orders');

Route::middleware(['auth', 'revalidate'])->group(function () {
    Route::prefix('files')->name('files.')->group(function () {
        Route::get('/statements/{id}', [FilesController::class, 'statements'])->name('statements');
        Route::get('/invoice/{id}', [FilesController::class, 'invoice'])->name('invoice');
        Route::get('/credit-memos/{id}', [FilesController::class, 'creditMemos'])->name('credit-memos');
        Route::get('/others/{id}', [FilesController::class, 'others'])->name('others');
    });
});

Route::middleware(['auth', 'customer', 'revalidate'])->group(function () {
    Route::name('user.')->group(function () {
        // User Dashboard Specific
        Route::get('/validate-auth', [HomeController::class, 'validateAuth'])->name('validate');
        Route::get('/user', [UserController::class, 'index'])->name('index');
        Route::post('/user', [UserController::class, 'store'])->name('store');
        Route::get('/user/create', [UserController::class, 'create'])->name('create');
        Route::get('/dashboard', [CommonController::class, 'dashboard'])->name('common.dashboard');
        Route::get('/user/deleted', [UserStatusController::class, 'getDeleted'])->name('deleted');
        Route::post('/delete-entry', [UserController::class, 'deleteEntry'])->name('delete-entry');
        Route::post('/request-change', [UserController::class, 'requestChange'])->name('request-change');

        Route::prefix('user/{user}')->group(function () {
            // User CRUD
            Route::get('/', [UserController::class, 'show'])->name('show');
            Route::get('/edit', [UserController::class, 'edit'])->name('edit');
            Route::patch('/', [UserController::class, 'update'])->name('update');
            Route::delete('/', [UserController::class, 'destroy'])->name('destroy');

            Route::get('/delete', [UserStatusController::class, 'delete'])->name('delete-permanently');
            Route::get('/restore', [UserStatusController::class, 'restore'])->name('restore');
            // Access
            Route::get('/login-as', [UserController::class, 'loginAs'])->name('login-as');
        });

        Route::get('/orders/show/{order}', [OrdersController::class, 'show'])->name('orders.show');
        Route::get('/orders/print/{order}', [OrdersController::class, 'print'])->name('orders.print');
        Route::get('/common/details-api/{order}', [CommonController::class, 'detailsApi'])->name('common.orderDetailsApi');
        Route::post('/orders/details-type-api', [OrdersController::class, 'detailsTypeApi'])->name('orders.detailsTypeApi');
        Route::post('/orders/order-feedback', [OrdersController::class, 'orderFeedback'])->name('orders.orderFeedback');
        Route::get('/details-api/{id}/{type}', [HomeController::class, 'detailsApi'])->name('detailsApi');
        Route::get('/common/details-api/{id}/{type}', [HomeController::class, 'detailsApi'])->name('common.detailsApi');
        Route::post('/orders/copy', [OrdersController::class, 'copy'])->name('orders.copy');
        Route::get('/orders/destroy/{order}', [OrdersController::class, 'destroy'])->name('orders.destroy');

        // User Account Specific
        Route::get('/account', [AccountController::class, 'index'])->name('account');
        Route::get('/account/tabs/users', [AccountController::class, 'usersTab'])->name('account.tabs.users');
        Route::get('/notifications', [AccountController::class, 'notifications'])->name('notifications');

        // User Profile Specific
        Route::patch('/profile/update', [ProfileController::class, 'update'])->name('profile.update');
        Route::post('/profile/update-api', [ProfileController::class, 'updateApi'])->name('profile.updateApi');

        // Customer admin order routes
        Route::prefix('orders')->group(function () {
            Route::get('/', [OrdersController::class, 'index'])->name('orders');
            Route::get('/saved', [OrdersController::class, 'saved'])->name('saved-orders');
            Route::get('/rx-lens', [OrdersController::class, 'rxLensOrders'])->name('rx-lens-orders');
            Route::get('/stock-lens', [OrdersController::class, 'stockLensOrders'])->name('stock-lens-orders');
            Route::get('/consumeables', [OrdersController::class, 'consumableLensOrders'])->name('consumables-lens-orders');
            Route::post('/search-barcode-api', [OrdersController::class, 'searchBarcodeApi'])->name('search-barcode-api');
            Route::post('/rx-validation-api', [OrdersController::class, 'rxValidationApi'])->name('rx-validation-api');
            Route::post('/rx-filtered-validation-api', [OrdersController::class, 'rxFilteredValidationApi'])->name('rx-filtered-validation-api');
            Route::get('/all', [OrdersController::class, 'all'])->name('orders-all');
            Route::post('/rx-cutout-validation', [OrdersController::class, 'rxValidationCutoutApi'])->name('rx-cutout-validation');
            Route::get('/confirm/{order}', [OrdersController::class, 'confirm'])->name('order.confirm');
            Route::post('/filter-frame-info', [OrdersController::class, 'filterFrameInfo'])->name('filter-frame-info');
        });

        Route::prefix('orders/create')->group(function () {
            Route::get('/rx-lens', [OrdersController::class, 'createRXLensOrder'])->name('new-rx-lens-order');
            Route::get('/stock-lens', [OrdersController::class, 'createStocklenseOrder'])->name('new-stock-lens-order');
            Route::get('/consumables', [OrdersController::class, 'createConsumableLensOrder'])->name('new-consumables-lens-order');
            Route::post('/redo', [OrdersController::class, 'redo'])->name('redo');
        });
    });

    Route::get('/stock-data', [OrdersController::class, 'getStockData'])->name('stock-data');
    Route::post('/store-rx', [OrdersController::class, 'storeRx'])->name('store-rx');
    Route::post('/confirm-stock-order', [OrdersController::class, 'confirmStock'])->name('confirm-stock-order');
    Route::post('/store-stock-order', [OrdersController::class, 'newStockOrder'])->name('store-stock-order');
    Route::post('/store-consumables-order', [OrdersController::class, 'newConsumablesOrder'])->name('store-consumables-order');
    Route::post('/barcode', [OrdersController::class, 'newBarcodeOrder'])->name('new-barcode');
    Route::get('/customer-reply', [EmailTemplateController::class, 'reply'])->name('customer.reply');
    Route::post('/search-orders', [OrdersController::class, 'searchOrders'])->name('search-orders');

    Route::prefix('statements')->name('statements.')->group(function () {
        Route::get('/', [StatementsController::class, 'index'])->name('index');
        Route::post('/data-api', [StatementsController::class, 'dataApi'])->name('data-api');
        Route::post('/load-content-api', [StatementsController::class, 'loadContentApi'])->name('load-content-api');
        Route::post('/file', [StatementsController::class, 'file'])->name('file');
    });

    Route::prefix('credit-memos')->name('credit-memos.')->group(function () {
        Route::get('/', [CreditMemosController::class, 'index'])->name('index');
        Route::post('/file', [CreditMemosController::class, 'file'])->name('file');
    });

    Route::prefix('push-notifications')->name('push-notifications.')->group(function () {
        Route::post('/store-token', [PushNotificationsController::class, 'storeToken'])->name('store-token');
        Route::get('/test', [PushNotificationsController::class, 'test'])->name('test');
    });
});

Route::group([], function () {
    // Add Comment on order
    Route::post('/comment/store', [PhoneLogController::class, 'store'])->name('comment.store');
    Route::post('/comment', [PhoneLogController::class, 'index'])->name('comment.index');
});