<?php 
$notifications = $logged_in_user->notifications();
$unreadNotifications = $logged_in_user->unreadNotifications();
?>
<nav class="navbar navbar-expand-lg mega-menu" role="navigation">
    <div class="container-fluid">
        <div class="clearfix fixed-top">
            <!-- Brand and toggle get grouped for better mobile display -->
            <button type="button" class="navbar-toggler" data-toggle="collapse" data-target=".navbar-responsive-collapse">
                <span class="sr-only">Toggle navigation</span>
                <span class="toggle-icon">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </span>
            </button>
            <!-- End Toggle Button -->
            <!-- BEGIN LOGO -->
            <a id="index" class="page-logo"
                href="<?php echo e(auth()->user()->isAdmin() ? route('admin.orders.list') : route('admin.orders.list')); ?>">
                <img src="<?php echo e(URL::asset('img/backend/brand/logo.png')); ?>" alt="Logo"> </a>
            <!-- END LOGO -->
            <!-- BEGIN HEADER MENU -->
            <div class="nav-collapse collapse navbar-collapse navbar-responsive-collapse">
                <ul class="navbar-nav">
                    <?php if(auth()->user()->isAcessible(['backend view users','backend admin']) &&  auth()->user()->isAdmin() ): ?>
                        <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkUriPattern('admin/auth/user*'),'selected active open')); ?>">
                            <a href="<?php echo e(route('admin.auth.user.index')); ?>" class="text-uppercase">
                                <i class="icon-users"></i> Users </a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view backend')): ?>
                    <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkUriPattern('admin/orders'),'selected active open')); ?>">
                        <a href="<?php echo e(route('admin.orders.list')); ?>" class="text-uppercase">
                            <i class="fa fa-shopping-cart"></i> Orders</a>
                            <!-- <?php echo svg_image('orders-menu.svg', 'svg-icons', 'Orders'); ?> <?php echo app('translator')->get('Orders'); ?> -->
                        </a>
                    </li>
                    
                    <?php endif; ?>      
                    <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkUriPattern('admin/notifications'),'selected active open')); ?>" id="notification-header-link">
                        <a href="<?php echo e(route('admin.user.notifications')); ?>" class="text-uppercase">
                             <i class="fa fa-bell"></i> Notifications
                            <!-- <?php echo svg_image('notification.svg', 'svg-icons', 'Notifications'); ?> <?php echo app('translator')->get('Notifications'); ?> -->
                            <?php if(count($unreadNotifications) > 0): ?>
                                <span class="badge badge-danger notifications-badge-counter"><?php echo e(count($unreadNotifications)); ?></span>
                            <?php else: ?>
                                <span class="badge badge-danger notifications-badge-counter"></span>
                            <?php endif; ?>
                        </a>
                    </li>
                    <?php if(auth()->user()->isAcessible(['backend admin'])): ?>
                        <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkUriPattern('admin/auth/template*'),'selected active open')); ?>">
                            <a href="<?php echo e(route('admin.auth.template.index')); ?>" class="text-uppercase">
                                <i class="fa fa-envelope-o"></i> Email Templates </a>
                        </li>
                    <?php endif; ?>
                    <?php if(auth()->user()->isAcessible(['backend admin']) || auth()->user()->isLabManager()): ?>
                    <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkUriPattern('admin/orders/settings*'),'selected active open')); ?>">
                        <a href="<?php echo e(route('admin.orders.settings')); ?>" class="text-uppercase">
                            <i class="fa fa-cogs"></i> Setup </a>
                            <!-- <?php echo svg_image('setting.svg', 'svg-icons', 'Setup'); ?> <?php echo app('translator')->get('Setup'); ?> -->
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if(auth()->user()->isAcessible(['backend admin'])): ?>
                    <li class="dropdown dropdown-fw dropdown-fw-disabled <?php echo e(active_class(Active::checkUriPattern('admin/auth/api-client*'),'selected active open')); ?>">
                        <a href="<?php echo e(route('admin.auth.api-client.index')); ?>" class="text-uppercase">
                            <i class="fa fa-key"></i> Api Clients </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
            <div class="topbar-actions">
                <!-- BEGIN GROUP NOTIFICATION -->
                <!-- END GROUP NOTIFICATION -->
                <!-- BEGIN USER PROFILE -->
                <div class="btn-group-img btn-group">
                    <button type="button" class="btn btn-sm md-skip dropdown-toggle profile-btn" data-toggle="dropdown">
                        <span class="text-right">
                            <?php echo e($logged_in_user->name); ?> <i class="fa fa-arrow-down"></i> <br> Admin
                            <!-- <?php echo e($logged_in_user->name); ?> <?php echo svg_image('arrow-down.svg', 'svg-icons', 'Arrow Down'); ?> -->
                        </span>
                        <?php if(!$logged_in_user->isGravatar()): ?>
                            <img class="avatar" src="<?php echo e($logged_in_user->picture); ?>" alt="">
                        <?php endif; ?>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-v2" role="menu">
                        <?php if(auth()->user()->isAcessible(['backend view users','backend admin']) && auth()->user()->isAdmin()): ?>
                            <li>
                                <a href="<?php echo e(route('admin.auth.user.index')); ?>">
                                    <i class="icon-users"></i> Users
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view backend')): ?>
                            <li>
                                <a href="<?php echo e(route('admin.orders.list')); ?>">
                                    <i class="fa fa-shopping-cart"></i> Orders
                                    <!-- <?php echo svg_image('orders-menu.svg', 'svg-icons', 'Orders'); ?> <?php echo app('translator')->get('Orders'); ?> -->
                                </a>
                            </li>
                        <?php endif; ?> 
                        <li>
                            <a href="<?php echo e(!auth()->user()->isCustomerAdmin() ? route('admin.user.account') : route('frontend.user.account')); ?>">
                                <i class="icon-user"></i> My Profile
                                <!-- <?php echo svg_image('account.svg', 'svg-icons', 'My Profile'); ?> <?php echo app('translator')->get('My Profile'); ?> -->
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('frontend.auth.logout')); ?>">
                                <i class="icon-key"></i> Log Out </a>
                                <!-- <?php echo svg_image('logout.svg', 'svg-icons', 'Log Out'); ?> <?php echo app('translator')->get('Log Out'); ?> -->
                            </a>
                        </li>
                    </ul>
                </div>
                <!-- END USER PROFILE -->
            </div>
            <!-- END TOPBAR ACTIONS -->
        </div>
    </div>
    <!--/container-->
</nav><?php /**PATH /var/www/html/lens-shapers/resources/views/backend/includes/split-header.blade.php ENDPATH**/ ?>