<style>
.variant-list {
    display: flex;
    width: 100%;
    justify-content: center;
    align-items: center;
}

.variant-list-item {
    width: 60%;
    padding-bottom: 8px;
    text-align: initial;
}

.variant-list-item.section-1 {
    width: 50%;
}

.card-body {
    margin-left: 34px;
}

.card.mb-3 {
    border: 1px solid #F5F5F5;
    border-radius: 4px;
    ;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    transition: all 0.3sease;
}

.card.mb-3:hover {
    border-color: #0056b3;
    box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2);
}

.card-title,
.card-price,
.item-symbol {
    font-size: large;
    font-weight: bold;
    display: inline-block;
    vertical-align: middle;
}

.card-price,
.item-symbol {
    float: right;
}

.quantity-selector input[type="number"] {
    width: 60px;
    text-align: center;
    appearance: textfield;
    -moz-appearance: textfield;
    margin: 0 10px;
    padding: 5px;
    border: 1px solid #ccc;
}

.qty-input::-webkit-outer-spin-button,
.qty-input::-webkit-inner-spin-button {
    -webkit-appearance: none;
    margin: 0;
}

.qty-input[type=number] {
    -moz-appearance: textfield;
}

.card {
    border-radius: 4px;
    background: #fff;
    box-shadow: 0 6px 10px rgba(0, 0, 0, .08), 0 0 6px rgba(0, 0, 0, .05);
    transition: .3s transform cubic-bezier(.155, 1.105, .295, 1.12), .3s box-shadow, .3s -webkit-transform cubic-bezier(.155, 1.105, .295, 1.12);
    padding: 14px 80px 18px 36px;
    cursor: pointer;
}

.font-small {
    font-size: small;
}

.font-medium {
    font-size: medium;
}

.image-container {
    width: 493px !important;
    height: 250px;
    object-fit: cover;
    overflow: hidden;
}

/* model popup start */
.modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.9);
    justify-content: center;
    align-items: center;
    z-index: 1000;
}

.modal-content-container {
    position: relative;
    max-width: 90%;
    max-height: 90%;
    display: flex;
    flex-direction: column;
    align-items: center;
}

.modal-content {
    position: relative;
    display: flex;
    justify-content: center;
    align-items: center;
    width: 800px;
    height: 600px;
    border-radius: 8px;
}

#modalImage {
    width: 100%;
    height: 100%;
    object-fit: contain;
    border-radius: 4px;
      background: #fff;
    display: block;
    z-index: 1;
}

.variant-info {
    color: #ffff;
    text-align: center;
    margin-top: 10px;
    width: 100%;
    padding: 10px;
    display: flex;
    flex-direction: column;
}

/* Close button */
.close-btn {
    position: absolute;
    top: -40px;
    right: -40px;
    color: #fff;
    font-size: 40px;
    cursor: pointer;
    z-index: 10; /* Higher than image */
    border-radius: 50%;
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    line-height: 1;
    border: none;
    outline: none;
}

/* Arrow buttons */
.left-arrow,
.right-arrow {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    background: rgba(255, 255, 255, 0.7);
    border: none;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    cursor: pointer;
    font-size: 20px;
    opacity: 1;
    display: block;
    z-index: 10;
}

.left-arrow {
    left: 10px;
}

.right-arrow {
    right: 10px;
}

/* model popup end */

span.variant-label {
    font-size: larger;
}

img.imageToReplace {
    border-radius: 4px;
    ;
}

.form-section {
    margin: 10px 0px !important;
}

/* span.item-price {
        text-align: end;
    } */
    .item-price {
        text-align: right;
        display: flex;
        justify-content: flex-end;
        align-items: end;
        font-weight: bold;
    }
    .inherit-price-container {
        display: none;
    }
    .empty-cart-label {
        font-size: 14px;
        text-align: center
    }
    .delete-btn:hover {
        color: #e7505a;
    }
    .delete-btn {
        color: #808080;
    }

.variant-list-item.section-2 {
    font-size: 14px;
    font-weight: bold;
}

.sticky-summary {
    position: -webkit-sticky;
    /* For Safari */
    position: sticky;
    top: 0;
    z-index: 1000;
}

.scrollable-container {
    overflow-y: auto;
    max-height: 100vh;
}

.col-order-form-container {
    max-height: 90vh;
    overflow-y: auto;
    padding-right: 20px;
}

.sticky-summary {
    position: -webkit-sticky;
    position: sticky;
    top: 0;
    z-index: 1000;
    padding: 5px;
    margin-top: 0px;
}

.scrollable-container {
    max-height: 90vh;
    overflow-y: auto;
}

.cart-container {
    padding-bottom: 10px !important;
}

.quantity-selector button {
    background-color: rgb(177, 177, 177); 
    color: white;
    border: none;
    padding: 3px 10px;
    cursor: pointer;
    font-size: 16px;
}
</style>

<?php $__env->startSection('title', 'Consumables Order'); ?>
<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <img alt="stock-center-logo" height="100" src="<?php echo e(asset('img/StockCenter.jpg')); ?>" style="margin-bottom: 20px">
    </div>
</div>
<div class="row m-t-20">
    <div class="col-md-7 col-order-form-container scrollable-container">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-layers font-green"></i>
                    <span class="caption-subject font-green sbold uppercase">Consumables Order</span>
                </div>
            </div>
            <div class="container">
                <div class="row">
                    <?php foreach ($consumableProducts as $consumable): ?>
                    <div class="card mb-3" style="max-width: auto">
                        <div class="row no-gutters">
                            <div class="col-md-4 image-container">
                                <?php if(count($consumable['child']) ===1) { ?>
                                    <img class="imageToReplace"
                                        src="<?php echo e(asset('storage/imports/images/'.$consumable['image'])); ?>"
                                        alt="<?php echo e($consumable['name']); ?>"
                                        <?php if(!empty($consumable['image_hover'])): ?>
                                            onmouseover="this.src='<?php echo e(asset('storage/imports/images/'.$consumable['image_hover'])); ?>';"
                                        <?php endif; ?>
                                        <?php if(!empty($consumable['image'])): ?>
                                            onmouseout="this.src='<?php echo e(asset('storage/imports/images/'.$consumable['image'])); ?>';"
                                            <?php endif; ?>>
                                <?php } else { ?>
                                    <img class="imageToReplace" src="<?php echo e(asset('storage/imports/images/'.$consumable['image'])); ?>" alt="<?php echo e($consumable['name']); ?>">
                                <?php } ?>
                            </div>
                          <div class="col-md-8">
                                <div class="card-body">
                                    <span class="card-title"><?php echo e($consumable['name']); ?></span>
                                    <?php if($consumable['price'] == 0): ?>
                                        <span class="card-price">Contact</span>
                                    <?php else: ?>
                                        <span class="item-symbol">$
                                            <span class="card-price"><?php echo e(number_format($consumable['price'], 2)); ?></span>
                                        </span>
                                    <?php endif; ?>
                                    <p class="card-text"><?php echo e($consumable['description']); ?></p>
                                    <p class="card-text">
                                        <small class="text-muted">
                                            <div class="quantity-selector">
                                                <?php foreach ($consumable['child'] as $key => $child) { ?>
                                                    <div class="variant-list" data-variant-id="<?php echo e($child['id']); ?>" data-variant-price="<?php echo e($child['price']); ?>" data-variant-label="<?php echo e($consumable['name']); ?>" data-variant="<?php echo e($child['sub_name']); ?>">
                                                        <div class="variant-list-item section-1"
                                                        data-variant-image="<?php echo e(asset('storage/imports/images/'.$child['image'])); ?>"
                                                            <?php if(!empty($child['image_hover'])): ?>
                                                                data-variant-image-sub="<?php echo e(asset('storage/imports/images/'.$child['image_hover'])); ?>"
                                                            <?php endif; ?>>
                                                            <span class="variant-label"><?php echo e($child['sub_name']); ?></span>
                                                        </div>
                                                        <div class="variant-list-item section-2">
                                                            <button class="minus-btn">-</button>
                                                            <input type="number" min="0" max="20" class="qty-input" value="">
                                                            <button class="plus-btn">+</button>
                                                        </div>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                        </small>
                                    </p>
                                </div>
                          </div>
                        </div>
                      </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-5  sticky-summary">
        <div class="portlet light bordered" style="padding: 0px;margin-top: 0px;">
            <div class="portlet-body rx-form-content">
                <div class="row summary-container">
                    <div class="col-12 stock-summary-content p-0">
                        <div class="row p-0 m-0">
                            <div class="col-1 p-0">&nbsp;</div>
                            <div class="col-11 p-0">
                                <h4 class="form-section bold">Order Summary</h4>
                                <label class="">
                                    <b id="patient-field"></b>
                                </label>
                            </div>
                        </div>
                        <div class="summary-content-table">
                            <section>
                                <div class="row p-0 m-0">
                                    <div class="col-1 p-0">&nbsp;</div>
                                    <div class="col-11 p-0">
                                        <h4 class="form-section bold summary-heading" style="padding-left: 5px;">Consumables</h4>
                                    </div>
                                </div>
                                <div class="consumable-summary-container">
                                    <h4 class="empty-cart-label">Add an item on the left...</h4>
                                </div>
                            </section>
                            <section class="mt-3">
                                <div class="row p-0 m-0">
                                    <div class="col-1 p-0 inherit-price-container-1" style="display: none">&nbsp;</div>
                                    <div class="col-md-11 text-right inherit-price-container">
                                        <div class="bold">Total: $<span id="t_price-field">0.00</span></div>
                                        <span>All prices on this page are Net/Net. No further discounts applicable.</span>
                                    </div>
                                </div>
                            </section>  
                        </div>                              
                    </div>
                </div>
                <div class="row stock-btn-container mt-5" style="border-top: 1px solid #e7ecf1;padding-top: 10px;padding-left: 10px;padding-right: 10px;">
                    <div class="col-md-12 zero-col-padding display-inline-flex">
                        <div class="col-md-4 nopadding">
                            <div class="form-actions">
                                <?php echo e(form_cancel(route('frontend.user.orders'), __('buttons.general.cancel'))); ?>

                            </div>
                        </div>
                        <div class="col-md-4 nopadding">
                            <div class="form-actions text-center">
                                <?php echo e(form_cancel('javascript:void(0);','Reset','btn yellow mt-ladda-btn ladda-button btn-outline btn-reset')); ?>

                            </div>
                        </div>
                        <div class="col-md-4 nopadding">
                            <div class="form-actions aligned-stock-btn">
                                <button class="btn blue btn-submit submit-consumable-order" onclick="submitCousmableOrder()" type="submit">Order Now</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal Popup -->
<div id="imageModal" class="modal">
    <div class="modal-content-container">
        <div class="modal-content">
            <img id="modalImage" class="modal-image" src="" alt="Product Image">
            <span class="close-btn">&times;</span>
            <button class="left-arrow">❮</button>
            <button class="right-arrow">❯</button>
        </div>
        <div class="variant-info"  style="display: none;">
            <span id="data-variant-label"></span>
            <span id="data-variant"></span>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.split', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/lens-shapers/resources/views/frontend/auth/orders/create/consumable-lens-order.blade.php ENDPATH**/ ?>