<?php 
use App\Models\Backend\UserProfile;
?>
<?php echo e(html()->modelForm($logged_in_user, 'POST', route('frontend.user.profile.update'))->class('form-horizontal enable_change_btn')->attribute('enctype', 'multipart/form-data')->open()); ?>

<?php echo method_field('PATCH'); ?>
<input type="hidden" name="steps" value="personal_info">
<div class="form-body">
    <div class="row m-0">
        <div class="col-md-6" style="padding-right: 18px;">
            <div class="form-group">
                <?php echo e(html()->label(__('validation.attributes.frontend.first_name'))->for('first_name')); ?>


                <?php if($user->isCustomerAdmin()): ?>
                    <?php echo e(html()->text('first_name')
                        ->class('form-control common-form-control')
                        ->placeholder(__('validation.attributes.frontend.first_name'))
                        ->attribute('maxlength', 191)
                        ->attribute('readonly', true)
                        ->required()); ?>

                <?php else: ?>
                    <?php echo e(html()->text('first_name')
                        ->class('form-control common-form-control')
                        ->placeholder(__('validation.attributes.frontend.first_name'))
                        ->attribute('maxlength', 191)
                        ->required()); ?>

                <?php endif; ?>
            </div>
        </div>
        <div class="col-md-6" style="padding-left: 18px;">
            <div class="form-group">
                <?php echo e(html()->label(__('validation.attributes.frontend.last_name'))->for('last_name')); ?>



                <?php if($user->isCustomerAdmin()): ?>
                    <?php echo e(html()->text('last_name')
                        ->class('form-control common-form-control')
                        ->placeholder(__('validation.attributes.frontend.last_name'))
                        ->attribute('maxlength', 191)
                        ->attribute('readonly', true)
                        ->required()); ?>

                <?php else: ?>
                    <?php echo e(html()->text('last_name')
                        ->class('form-control common-form-control')
                        ->placeholder(__('validation.attributes.frontend.last_name'))
                        ->attribute('maxlength', 191)
                        ->required()); ?>

                <?php endif; ?>
            </div>
        </div>
        <div class="col-md-6" style="padding-right: 18px;">
            <div class="form-group">
                <?php echo e(html()->label('Account Code')->for('ac_code')); ?>


                <?php echo e(html()->text('ac')
                    ->class('form-control')
                    ->placeholder('Account Code')
                    ->attribute('maxlength', 191)
                    ->value($user->ac_code)
                    ->attribute('disabled', 'disabled')
                    ->required()); ?>

            </div>
        </div>
        <?php if($user->isCustomerAdmin()): ?>
            <div class="col-md-6">
                <div class="form-group lable-style">
                    <?php echo e(html()->label(__('Birthday'))->for('date_of_birth')); ?>

                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fa fa-calendar"></i>
                        </span>
                        <input type="text" name="date_of_birth" id="date_of_birth" class="form-control" placeholder="Birthday" value="<?php echo e($profile->date_of_birth); ?>" maxlength="191" data-date-format="yyyy-mm-dd">
                    </div>
                </div>
            </div> 
            <div class="col-md-6" style="padding-right: 18px;">
                <div class="form-group">
                    <?php echo e(html()->label(__('validation.attributes.frontend.email'))->for('email')); ?>


                    <?php echo e(html()->email('email')
                        ->class('form-control common-form-control')
                        ->placeholder(__('validation.attributes.frontend.email'))
                        ->attribute('maxlength', 191)
                        ->attribute('readonly', true)
                        ->required()); ?>

                </div>
            </div>                           
            <div class="col-md-6">
                <div class="form-group">
                    <?php echo e(html()->label(__('Celebrates Holidays'))->for('religion')); ?>

                    <select name="religion[]" id="religion" class="form-control common-form-control select2" multiple>
                        <option value="">Please Select</option>
                        <?php 
                            $religion = !empty($profile->religion) ? json_decode($profile->religion,1) : [];
                        ?>
                        <?php $__currentLoopData = UserProfile::getReligionArrayLabel(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($value->name); ?>" <?= in_array($value->name, $religion) ? 'selected' : '' ?>><?php echo e($value->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <?php echo e(html()->label(__('Business Name'))->for('business_name')); ?>

                    <?php echo e(html()->text('business_name')
                        ->class('form-control common-form-control')
                        ->placeholder(__('Business Name'))
                        ->value($profile->business_name)
                        ->attribute('maxlength', 191)
                        ->attribute('readonly', true)); ?>

                </div>
            </div>
            <div class="col-md-6" style="padding-left: 18px;">
                <div class="form-group">
                    <?php echo e(html()->label(__('Address Line 1'))->for('address1')); ?>

                    <?php echo e(html()->text('address1')
                        ->class('form-control common-form-control')
                        ->placeholder(__('Address'))
                        ->value($profile->address1)
                        ->attribute('maxlength', 191)
                        ->attribute('readonly', true)); ?>

                </div>
            </div>                            
            <div class="col-md-6">
                <div class="form-group">
                    <?php echo e(html()->label(__('Address Line 2'))->for('address2')); ?>

                    <?php echo e(html()->text('address2')
                            ->class('form-control common-form-control')
                            ->placeholder(__('Address'))
                            ->value($profile->address2)
                            ->attribute('maxlength', 191)
                            ->attribute('readonly', true)); ?>

                </div>
            </div>
            <div class="col-md-6" style="padding-left: 18px;">
                <div class="form-group">
                    <?php echo e(html()->label(__('City'))->for('city')); ?>

                    <?php echo e(html()->text('city')
                        ->class('form-control common-form-control')
                        ->placeholder(__('city'))
                        ->value($profile->city)
                        ->attribute('maxlength', 191) 
                        ->attribute('readonly', true)); ?>

                </div>
            </div>                            
            <div class="col-md-6">
                <div class="form-group">
                    <?php echo e(html()->label(__('Province'))->for('state')); ?>

                        <?php echo e(html()->text('state')
                            ->class('form-control common-form-control')
                            ->placeholder(__('Province'))
                            ->value($profile->state)
                            ->attribute('maxlength', 191)
                            ->attribute('readonly', true)); ?>

                </div>
            </div>
            <div class="col-md-6" style="padding-left: 18px;">
                <div class="form-group">
                    <?php echo e(html()->label(__('Country'))->for('country')); ?>

                        <?php echo e(html()->text('country')
                            ->class('form-control')
                            ->placeholder(__('Country'))
                            ->value($profile->country)
                            ->attribute('readonly', true)
                            ->attribute('maxlength', 191)); ?>

                </div>
            </div>                            
            <div class="col-md-6">
                <div class="form-group">
                    <?php echo e(html()->label(__('Postal Code'))->for('zip_code')); ?>

                        <?php echo e(html()->text('zip_code')
                            ->class('form-control common-form-control')
                            ->placeholder(__('Postal Code'))
                            ->value($profile->zip_code)
                            ->attribute('maxlength', 191)
                            ->attribute('readonly', true)); ?>

                </div>
            </div>
            <div class="col-md-6" style="padding-left: 18px;">
                <div class="form-group">
                    <?php echo e(html()->label(__('Phone'))->for('phone')); ?>

                    <?php echo e(html()->text('phone2')
                        ->class('form-control common-form-control')
                        ->placeholder(__('(+1) XXX-XXX-XXXX'))
                        ->value($profile->phone ? formatPhone($profile->phone) : '')
                        ->attribute('maxlength', 17) 
                        ->attribute('readonly', true)); ?>

                </div>
            </div>                            
            <div class="col-md-6">
                <div class="form-group">
                    <?php echo e(html()->label(__('Fax'))->for('fax')); ?>

                    <?php echo e(html()->text('fax')
                        ->class('form-control common-form-control')
                        ->placeholder(__('(+1) XXX-XXX-XXXX'))
                        ->value($profile->fax ? formatPhone($profile->fax) : '')
                        ->attribute('maxlength', 17) 
                        ->attribute('readonly', true)); ?>

                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php echo e(html()->closeModelForm()); ?>

<?php if($user->isCustomerAdmin()): ?>
    <div class="operation-container">
        <span class="btn red btn_request_change" id="requestChangeBtn" onclick="requestChange()">Request Change</span>
        <span class="btn green btn_submit" id="submitBtn" style="display:none;" onclick="submitChange()">Submit</span>
        <span class="btn red btn_cancel" id="cancelBtn" style="display:none;" onclick="cancelChange()">Cancel</span>
    </div>
<?php endif; ?>

<?php /**PATH /var/www/html/lens-shapers/resources/views/frontend/user/account/tabs/edit.blade.php ENDPATH**/ ?>