<?php 
use App\Models\Backend\StockOrder;
?>


<?php $__env->startSection('title', 'Stock Order' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name()); ?>

<?php $__env->startSection('content'); ?>
<style>
    .rx-form-content select,
    .rx-form-content input{
        max-width: 300px;
    }
</style>
<div class="row">
    <div class="col-12">
        <img alt="stock-center-logo" height="100" src="<?php echo e(URL::asset('public/img/StockCenter.jpg')); ?>" style="margin-bottom: 20px">
    </div>
</div>
<?php echo e(html()->form('POST', route('frontend.store-stock-order'))->attribute('id','stock-order_form')->open()); ?>

<div class="row m-t-20">
    <div class="col-md-7 col-order-form-container" style="overflow: hidden scroll;">
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class=" icon-layers font-green"></i>
                    <span class="caption-subject font-green sbold uppercase">Stock Order</span><br>
                    <!-- <small style="padding-left: 20px;"><b>All prices on this page are Net/Net. No further discounts applicable.</b></small> -->
                </div>
                <div class="actions">
                    <?php if(auth()->user()->isCustomerAdmin()): ?>
                        <a class="btn blue btn-circle btn-sm" href="<?php echo e(route('frontend.files.others',custom_encode_path('uploads/stock_center_price_file.pdf','others'))); ?>" target="_blank" data-close-others="true" aria-expanded="false"> Download Price List
                            <i class="fa fa-external-link"></i> 
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="portlet-body form rx-form-content stock-sub-header">
                <input type="hidden" name="submit_type" id="submit_type" value="submitted">
                <input type="hidden" name="l_barcode" id="l_barcode" value="">
                <input type="hidden" name="r_barcode" id="r_barcode" value="">
                <input type="hidden" name="l_vendor" id="l_vendor" value="">
                <input type="hidden" name="l_cards" id="l_cards" value="">
                <input type="hidden" name="r_vendor" id="r_vendor" value="">
                <input type="hidden" name="r_cards" id="r_cards" value="">
                <div class="row">
                    <div class="col-md-6">
                        <label>Patient/Reference</label>
                        <input type="text" name="patient" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group text-center m-0" style="padding-top: 20px;">
                            <div class="mt-radio-inline">
                                <label class="mt-radio">
                                    <input type="radio" name="combinition" id="both-eyes" value="<?= StockOrder::BOTH_EYES ?>" checked> Both Eyes
                                    <span></span>
                                </label>
                                <label class="mt-radio">
                                    <input type="radio" name="combinition" id="right-only" value="<?= StockOrder::RIGHT_EYE ?>"> Right Only
                                    <span></span>
                                </label>
                                <label class="mt-radio">
                                    <input type="radio" name="combinition" id="left-only" value="<?= StockOrder::LEFT_EYE ?>"> Left Only
                                    <span></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="m-grid m-grid-demo m-0">
                    <div class="m-grid-row">
                       <div class="m-grid-col m-grid-col-bottom m-grid-col-md-5 right-container">
                            <h1 style="padding-left:10px" class="text-center">Right</h1>
                            <div class="form-body">
                                <div class="select-content">
                                    <label>Material</label>
                                    <select name="r_material" id="r-material-select" class="form-control combinition-select">
                                        <option value="">Please Select</option>
                                        <?php $__currentLoopData = $material; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($value->material); ?>"><?php echo e($value->material); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="select-content">
                                    <label>Colour</label>
                                    <select name="r_colour" id="r-colour-select" class="form-control combinition-select select-right-only" disabled>
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                                <div class="select-content">
                                    <label>Coating</label>
                                    <select name="r_coating" id="r-coating-select" class="form-control combinition-select select-right-only" disabled>
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                                <div class="select-content">
                                    <label>SPH</label>
                                    <select name="r_sph" id="r-sph-select" class="form-control combinition-select select-right-only" disabled>
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                                <div class="select-content">
                                    <label>CYL</label>
                                    <select name="r_cyl" id="r-cyl-select" class="form-control combinition-select select-right-only" disabled>
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                                <div class="select-content">
                                    <label>Quantity</label>
                                    <input id="r-quantity" name="r_quantity" type="number" min="1" value="1" class="form-control select-right-only" disabled>
                                </div>
                                <div class="select-content col-md-6">
                                    <label>Size</label>
                                    <div id="r-size"></div>
                                    <input type="hidden" id="r-size_input" name="r_size" class="select-right-only">
                                </div>
                                <div class="select-content col-md-6">
                                    <label>Price</label>
                                    <div id="r-price"></div>
                                    <input type="hidden" id="r-price_input" name="r_price" class="select-right-only">
                                </div>
                            </div>
                        </div>
                        <div class="m-grid-col m-grid-col-middle m-grid-col-center m-grid-col-md-2">
                            <div style="margin-bottom:10px">
                                <button type="button" date_copy="right-to-left" class="data-copy_button btn blue mt-ladda-btn mt-ladda-btn-style ladda-button btn-outline" data-style="slide-left" data-spinner-color="#333" style="width: initial !important;">
                                    <span class="ladda-label">Copy <i class="fa fa-arrow-right" aria-hidden="true"></i></span>
                                </button>
                            </div>
                            <div>
                                <button type="button" date_copy="left-to-right" class="data-copy_button btn blue mt-ladda-btn mt-ladda-btn-style ladda-button btn-outline" data-style="slide-left" data-spinner-color="#333" style="width: initial !important;">
                                    <span class="ladda-label">
                                        <i class="fa fa-arrow-left" aria-hidden="true"></i> Copy</span>
                                </button>
                            </div>
                        </div><div class="m-grid-col m-grid-col-top m-grid-col-md-5 left-container">
                            <h1 style="padding-left:10px" class="text-center">Left</h1>
                            <div class="form-body">
                                <div class="select-content">
                                    <label>Material</label>
                                    <select name="l_material" id="l-material-select" data-type="color" class="form-control combinition-select">
                                        <option value="">Please Select</option>
                                        <?php $__currentLoopData = $material; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($value->material); ?>"><?php echo e($value->material); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="select-content">
                                    <label>Colour</label>
                                    <select name="l_colour" id="l-colour-select" class="form-control select-left-only combinition-select" disabled>
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                                <div class="select-content">
                                    <label>Coating</label>
                                    <select name="l_coating" id="l-coating-select" class="form-control select-left-only combinition-select" disabled>
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                                <div class="select-content">
                                    <label>SPH</label>
                                    <select name="l_sph" id="l-sph-select" class="form-control select-left-only combinition-select" disabled>
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                                <div class="select-content">
                                    <label>CYL</label>
                                    <select name="l_cyl" id="l-cyl-select" class="form-control select-left-only combinition-select" disabled>
                                        <option value="">Please Select</option>
                                    </select>
                                </div>
                                <div class="select-content">
                                    <label>Quantity</label>
                                    <input id="l-quantity" name="l_quantity" type="number" min="1" value="1" class="form-control select-left-only" disabled>
                                </div>
                                <div class="select-content col-md-6">
                                    <label>Size</label>
                                    <div id="l-size"></div>
                                    <input type="hidden" id="l-size_input" name="l_size" class="select-left-only">
                                </div>
                                <div class="select-content col-md-6">
                                    <label>Price</label>
                                    <div id="l-price"></div>
                                    <input type="hidden" id="l-price_input" name="l_price" class="select-left-only">
                                </div>
                            </div>
                        </div>
                    </div>
                </div> 
            </div>
        </div>
    </div>
    <div class="col-md-5 stock-summary-container" style="padding-left:0;">
        <div class="portlet light bordered" style="padding: 0px;margin-top: 0px;">
            <div class="portlet-body rx-form-content">
                <div class="row summary-container">
                        <div class="col-12 stock-summary-content p-0">
                                <div class="row p-0 m-0">
                                    <div class="col-12 p-0">
                                        <h4 class="form-section order-summary bold">Order Summary</h4>
                                        <label class="">
                                            <b id="patient-field"></b>
                                        </label>
                                    </div>
                                </div>
                                <div class="summary-content-table">
                                    <div class="empty-cart-label" style="text-align: center; display: block;">
                                        Add an item on the left...
                                    </div>
                                    <div class="lens-order-table admin-view stock-section" style="display:none;">
                                        <div class="order-summary-table-header">
                                            <div class="lens-side-col stock-summary">Stock Lenses</div>
                                            <div class="lens-data-col">Sph</div>
                                            <div class="lens-data-col">Cyl</div>
                                            <div class="lens-qty-col-main">Qty</div>
                                            <div class="lens-price-col stock-summary ">Price</div>
                                        </div>
                                        <div class="table-row-stock" id="right-row">
                                            <div class="lens-side-col">
                                                <span class="lens-side">R</span>
                                                <span class="lens-spec-col">
                                                    <span id="r_material-field"></span>
                                                    <span id="r_colour-field"></span>
                                                    <span id="r_coating-field"></span>
                                                    <span id="r_size-field"></span>
                                                </span>
                                            </div>
                                            <div class="lens-data-col"><span id="r_sph-field"></span></div>
                                            <div class="lens-data-col"><span id="r_cyl-field"></span></div>
                                            <div class="lens-qty-col"><span id="r_quantity-field"></span></div>
                                            <div class="lens-price-col"><span class="price" id="r_price-field">0.00</span></div>
                                        </div>
                                        <div class="table-row-stock" id="left-row">
                                            <div class="lens-side-col">
                                                <span class="lens-side">L</span>
                                                <span class="lens-spec-col">
                                                    <span id="l_material-field"></span>
                                                    <span id="l_colour-field"></span>
                                                    <span id="l_coating-field"></span>
                                                    <span id="l_size-field"></span>
                                                </span>
                                            </div>
                                            <div class="lens-data-col"><span id="l_sph-field"></span></div>
                                            <div class="lens-data-col"><span id="l_cyl-field"></span></div>
                                            <div class="lens-qty-col"><span id="l_quantity-field"></span></div>
                                            <div class="lens-price-col"><span class="price" id="l_price-field">0.00</span></div>
                                        </div>
                                    </div>
                                            <div class="total-section total-price-container" style="display:none;">
                                                <div class="bold">Total:<span id="t_price-field">0.00</span></div>
                                            </div>
                                            <div class="total-section total-price-container"  style="display:none;">
                                                 <span>All prices on this page are Net/Net. No further discounts applicable.</span>
                                            </div>
                                </div>
                            </div>
                </div>
                <div class="row stock-btn-container-summary mt-5">
                    <div class="col-md-12 zero-col-padding display-inline-flex">
                        <div class="col-md-4 nopadding">
                            <div class="form-actions btn-custom-focus">
                                <?php echo e(form_cancel(route('frontend.user.orders'), __('buttons.general.cancel'))); ?>

                            </div>
                        </div>
                        <div class="col-md-4 nopadding">
                            <div class="form-actions text-center">
                                <?php echo e(form_cancel('javascript:void(0);','Reset','btn yellow mt-ladda-btn ladda-button btn-outline btn-reset')); ?>

                            </div>
                        </div>
                        <div class="col-md-4 nopadding">
                            <div class="form-actions aligned-stock-btn btn-custom-focus">
                                <button class="btn blue btn-submit" type="submit" disabled>Order Now</button>
                            </div>
                     </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo e(html()->form()->close()); ?>

<?php $__env->startPush('after-scripts'); ?>
<script>
    var rightPrice = 0;
    var leftPrice = 0;
    var orderType = 'both';
    var isPricesShow = "<?php echo e(auth()->user()->isOrderPricesInvoicesPermission()); ?>";

    $(function() {
        rxFormResize();
        if (!isPricesShow) {
            $('span.price').parent().hide();
            $('span#t_price-field').parent().hide();
            $('#l-price, #r-price').parent().hide();
        }
        // Ensure summary and price fields are hidden on initial load
        $('.empty-cart-label').show();
        $('.stock-section').hide();
        $('.total-section').hide();
        $('#r-price, #l-price, #r_price-field, #l_price-field, #t_price-field').hide();
        $('#r_price-field').closest('.col-1').hide();
        $('#l_price-field').closest('.col-1').hide();
        $('#t_price-field').closest('.bold').hide();

        // Initialize form state
        toggleSummaryVisibility();
        var url = '<?= route('frontend.stock-data') ?>';

        $('#stock-order_form').on('submit', function () {
            $(this).find('button[type="submit"]').prop('disabled', true).text('Submitting...');
        });

        // Function to toggle summary visibility
        function toggleSummaryVisibility() {
            var rMaterial = $('#r-material-select').val();
            var lMaterial = $('#l-material-select').val();
            var rCyl = $('#r-cyl-select').val();
            var lCyl = $('#l-cyl-select').val();

            // Determine if summary should be shown
            if ((orderType === 'both' && (rMaterial || lMaterial)) ||
                (orderType === 'right' && rMaterial) ||
                (orderType === 'left' && lMaterial)) {
                $('.empty-cart-label').hide();
                $('.stock-section').show();
                $('.total-section').show();
            } else {
                $('.empty-cart-label').show();
                $('.stock-section').hide();
                $('.total-section').hide();
            }

            // Show/hide price fields based on isPricesShow and valid data
            if (isPricesShow) {
                if (orderType === 'both' || orderType === 'right') {
                    if (rCyl && rightPrice > 0) {
                        $('#r-price, #r_price-field').show();
                        $('#r_price-field').closest('.col-1').show();
                    } else {
                        $('#r-price, #l-price, #r_price-field').hide();
                        $('#r_price-field').closest('.col-1').hide();
                    }
                }
                if (orderType === 'both' || orderType === 'left') {
                    if (lCyl && leftPrice > 0) {
                        $('#l-price, #l_price-field').show();
                        $('#l_price-field').closest('.col-1').show();
                    } else {
                        $('#l-price, #l_price-field').hide();
                        $('#l_price-field').closest('.col-1').hide();
                    }
                }
                if ((rCyl && rightPrice > 0) || (lCyl && leftPrice > 0)) {
                    $('#t_price-field').show();
                    $('#t_price-field').closest('.bold').show();
                } else {
                    $('#t_price-field').hide();
                    $('#t_price-field').closest('.bold').hide();
                }
            } else {
                $('#r-price, #l-price, #r_price-field, #l_price-field, #t_price-field').hide();
                $('#r_price-field').closest('.col-1').hide();
                $('#l_price-field').closest('.col-1').hide();
                $('#t_price-field').closest('.bold').hide();
            }

            updateSummary();
        }

        $(document).on('change keyup', 'input[name="patient"], .select-right-only, .select-left-only', function() {
            let text = $(this).val();
            let elementId = $(this).attr('name');
            
            if (elementId === 'r_quantity' || elementId === 'l_quantity') {
                let explode = elementId.split('_');
                let price = explode[0] === 'r' ? rightPrice : leftPrice;
                let totalPrice = (parseFloat(text) * price).toFixed(2);
                $('#' + explode[0] + '-price_input').val(totalPrice);
            }
            
            if ($('.stock-summary-content #' + elementId + '-field').length > 0) {
                if (elementId === 'r_size' || elementId === 'l_size') {
                    text += 'mm';
                } 
                $('.stock-summary-content #' + elementId + '-field').html(text);
                setSubmitCheck(orderType);
            }
            
            toggleSummaryVisibility();
        });

        $('#both-eyes, #right-only, #left-only').click(function () {
          
            if (this.id == 'right-only') {
                $('.select-left-only').each(function() {
                    $(this).val('').trigger('change.select2');
                }).prop('disabled', true);
                orderType = 'right';
                $('.data-copy_button').hide();
                if ($('#right-only').is(':checked')) {
                    $('.stock-summary-content #right-row').show();
                    $('.stock-summary-content #left-row').hide();
                    document.querySelector('#l-quantity').value = 1;
                    $('.select-left-only').prop('disabled', 'disabled');
                    $('#l-material-select').prop('disabled', 'disabled');
                    $('#r-material-select').prop('disabled', false);
                     $('#l-material-select').val(null);
                    $("#l-size").html('');
                    $("#l-price").html('');
                }
            } else if (this.id == 'left-only') {
                 $('.select-right-only').each(function() {
                    $(this).val('').trigger('change.select2');
                }).prop('disabled', true);
                orderType = 'left';
                $('.data-copy_button').hide();
                if ($('#left-only').is(':checked')) {
                    $('.stock-summary-content #left-row').show();
                    $('.stock-summary-content #right-row').hide();
                    $('.select-right-only').val(null);
                    $('#r-material-select').val(null);
                    document.querySelector('#r-quantity').value = 1;
                    $('.select-right-only').prop('disabled', 'disabled');
                    $('#r-material-select').prop('disabled', 'disabled');
                    $('#l-material-select').prop('disabled', false);
                     $('#r-material-select').val(null);
                    $("#r-size").html('');
                    $("#r-price").html('');
                }
            } else {
                $('.combinition-select').each(function() {
                    $(this).val('').trigger('change.select2');
                }).prop('disabled', true);
                orderType = 'both';
                $('.stock-summary-content #right-row').show();
                $('.stock-summary-content #left-row').show();
                $('.data-copy_button').show();
                $('#l-material-select').prop('disabled', false);
                $('#r-material-select').prop('disabled', false);
                $('.select-left-only').prop('disabled', true);
                $('.select-right-only').prop('disabled', true);
                $('.select-right-only').val(null);
                $('#r-material-select').val(null);
                $('.select-left-only').val(null);
                $('#l-material-select').val(null);
                document.querySelectorAll('#l-quantity, #r-quantity').forEach(input => input.value = 1);
                $("#l-size").html('');
                $("#l-price").html('');
                $("#r-size").html('');
                $("#r-price").html('');
            }
            setSubmitCheck(orderType);
            toggleSummaryVisibility();
        });

        function copyData(type, from, to) {
            var selectedOptions = $('.' + type + '-container select');
            selectedOptions.each(function() {
                var value = $(this).find("option:selected").val();
                if (value !== '') {
                    var id = $(this).prop('id').substring(1);
                    var $options = $("#" + from + id + " > option").clone();
                    $("#" + to + id).empty().append($options).prop("disabled", false).val(value);
                }
            });
            $('.' + type + '-container input').each(function() {
                var value = $(this).val();
                if (value !== '') {
                    var id = $(this).prop('id').substring(1);
                    $("#" + to + id).val(value);
                }
            });
            if (type === 'left') {
                rightPrice = leftPrice;
                let totalPrice = (parseFloat($('#r-quantity').val() || 1) * rightPrice).toFixed(2);
                $("#r-price_input").val(totalPrice);
            } else {
                leftPrice = rightPrice;
                let totalPrice = (parseFloat($('#l-quantity').val() || 1) * leftPrice).toFixed(2);
                $("#l-price_input").val(totalPrice);
            }
            if (type === 'left') {
                $('#r_material-field').text($('#l_material-field').text());
                $('#r_colour-field').text($('#l_colour-field').text());
                $('#r_coating-field').text($('#l_coating-field').text());
                $('#r_size-field').text($('#l_size-field').text());
                $('#r_sph-field').text($('#l_sph-field').text());
                $('#r_cyl-field').text($('#l_cyl-field').text());
                $('#r_quantity-field').text($('#l_quantity-field').text());
            } else {
                $('#l_material-field').text($('#r_material-field').text());
                $('#l_colour-field').text($('#r_colour-field').text());
                $('#l_coating-field').text($('#r_coating-field').text());
                $('#l_size-field').text($('#r_size-field').text());
                $('#l_sph-field').text($('#r_sph-field').text());
                $('#l_cyl-field').text($('#r_cyl-field').text());
                $('#l_quantity-field').text($('#r_quantity-field').text());
            }
            $('#' + to + '-cyl-select').trigger('change');
            toggleSummaryVisibility();
        }

        $('.data-copy_button').on('click', function() {
            $(this).attr('date_copy') == 'left-to-right' ? copyData('left', 'l', 'r') : copyData('right', 'r', 'l');
        });

        // New: Handle material selection for summary (issue 1)
        $('#r-material-select, #l-material-select').on('change', function() {
            let side = $(this).attr('id').startsWith('r-') ? 'r' : 'l';
            let value = $(this).val();
            if (value) {
                $(`#${side}_material-field`).html(value);
            } else {
                $(`#${side}_material-field`).html('');
            }
            toggleSummaryVisibility();
        });

        $(".combinition-select").on('change', function(e) {
            var select_type_id = $(this).attr('id');
            let flag = false;
            switch (select_type_id) {
                case 'r-material-select':
                    var material = $(this).children("option:selected").val();
                    var type = 'colour';
                    getRightCombinitions(type, material);
                    flag = true;
                    break;
                case 'r-colour-select':
                    var material = $("#r-material-select").children("option:selected").val();
                    var colour = $(this).children("option:selected").val();
                    var type = 'coating';
                    getRightCombinitions(type, material, colour);
                    flag = true;
                    break;
                case 'r-coating-select':
                    var material = $("#r-material-select").children("option:selected").val();
                    var colour = $("#r-colour-select").children("option:selected").val();
                    var coating = $(this).children("option:selected").val();
                    var type = 'sph';
                    getRightCombinitions(type, material, colour, coating);
                    flag = true;
                    break;
                case 'r-sph-select':
                    var material = $('#r-material-select').children("option:selected").val();
                    var colour = $('#r-colour-select').children("option:selected").val();
                    var coating = $('#r-coating-select').children("option:selected").val();
                    var sph = $(this).children("option:selected").val();
                    var type = 'cyl';
                    getRightCombinitions(type, material, colour, coating, sph);
                    flag = true;
                    break;
                case 'r-cyl-select':
                    var material = $('#r-material-select').children("option:selected").val();
                    var colour = $('#r-colour-select').children("option:selected").val();
                    var coating = $('#r-coating-select').children("option:selected").val();
                    var sph = $('#r-sph-select').children("option:selected").val();
                    var cyl = $(this).children("option:selected").val();
                    var type = 'size';
                    getRightCombinitions(type, material, colour, coating, sph, cyl);
                    flag = true;
                    break;
                case 'l-material-select':
                    var material = $(this).children("option:selected").val();
                    var type = 'colour';
                    getLeftCombinitions(type, material);
                    flag = true;
                    break;
                case 'l-colour-select':
                    var material = $("#l-material-select").children("option:selected").val();
                    var colour = $(this).children("option:selected").val();
                    var type = 'coating';
                    getLeftCombinitions(type, material, colour);
                    flag = true;
                    break;
                case 'l-coating-select':
                    var material = $("#l-material-select").children("option:selected").val();
                    var colour = $("#l-colour-select").children("option:selected").val();
                    var coating = $(this).children("option:selected").val();
                    var type = 'sph';
                    getLeftCombinitions(type, material, colour, coating);
                    flag = true;
                    break;
                case 'l-sph-select':
                    var material = $('#l-material-select').children("option:selected").val();
                    var colour = $('#l-colour-select').children("option:selected").val();
                    var coating = $('#l-coating-select').children("option:selected").val();
                    var sph = $(this).children("option:selected").val();
                    var type = 'cyl';
                    getLeftCombinitions(type, material, colour, coating, sph);
                    flag = true;
                    break;
                case 'l-cyl-select':
                    var material = $('#l-material-select').children("option:selected").val();
                    var colour = $('#l-colour-select').children("option:selected").val();
                    var coating = $('#l-coating-select').children("option:selected").val();
                    var sph = $('#l-sph-select').children("option:selected").val();
                    var cyl = $(this).children("option:selected").val();
                    var type = 'size';
                    getLeftCombinitions(type, material, colour, coating, sph, cyl);
                    flag = true;
                    break;
            }
            if (flag && $(this).val() == '') {
                if (select_type_id.startsWith('r-')) {
                    $("#r-size").html('');
                    $("#r-price").html('');
                } else {
                    $("#l-size").html('');
                    $("#l-price").html('');
                }
                toggleSummaryVisibility();
            }
        });

        $(".btn-reset").on('click', function(e) {
            // Store the current radio button selection
            var selectedEye = $('input[name="combinition"]:checked').val();

            // Reset the entire form
            $('#stock-order_form').trigger("reset");
            
            // Restore the selected radio button
            $('input[name="combinition"][value="' + selectedEye + '"]').prop('checked', true);
            
            // Reset all select dropdowns (for Select2)
            $('.combinition-select').each(function() {
                $(this).val('').trigger('change.select2');
            }).prop('disabled', true);
            
            // Enable material dropdowns based on current selection
            if (orderType === 'both') {
                $('#l-material-select, #r-material-select').prop('disabled', false);
            } else if (orderType === 'right') {
                $('#r-material-select').prop('disabled', false);
                $('#l-material-select').prop('disabled', true);
            } else if (orderType === 'left') {
                $('#l-material-select').prop('disabled', false);
                $('#r-material-select').prop('disabled', true);
            }
            
            // Reset quantity fields to 1 but keep them enabled/disabled based on current state
            $('#r-quantity, #l-quantity').val(1);
            if (orderType === 'both') {
                $('#r-quantity, #l-quantity').prop('disabled', true);
            } else if (orderType === 'right') {
                $('#r-quantity').prop('disabled', true);
                $('#l-quantity').prop('disabled', true);
            } else if (orderType === 'left') {
                $('#l-quantity').prop('disabled', true);
                $('#r-quantity').prop('disabled', true);
            }
            
            // Clear size and price displays
            $("#l-size, #r-size, #l-price, #r-price").html('');
            
            // Clear hidden fields
            $("#l-size_input, #r-size_input, #l-price_input, #r-price_input").val('');
            $("#l_barcode, #r_barcode, #l_vendor, #r_vendor, #l_cards, #r_cards").val('');
            
            // Reset prices
            rightPrice = 0;
            leftPrice = 0;
            
            // Reset summary display
            $('.empty-cart-label').show();
            $('.stock-section').hide();
            $('.total-section').hide();
            
            // Clear all summary fields
            $('.stock-summary-content span[id$="-field"]').html('');

            $('#patient-field').text('');

            // Update summary
            updateSummary();
        });

        function getRightCombinitions(type, material = null, colour = null, coating = null, sph = null, cyl = null) {
            $.ajax({
                url: url,
                type: "GET",
                data: {
                    material: material,
                    colour: colour,
                    coating: coating,
                    sph: sph,
                    cyl: cyl,
                    type: type,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(data) {
                    if (data.length > 0) {
                        let element;
                        let shouldOpenSelect2 = false;

                        if (data[0].hasOwnProperty('colour')) {

                            element = $("#r-colour-select");
                            element.empty().append('<option value="">Please Select</option>').prop('disabled', false);
                            $.each(data, function(key, value) {
                                element.append('<option value="' + value.colour + '">' + value.colour + '</option>');
                            });
                            shouldOpenSelect2 = true;
                            
                        } else if (data[0].hasOwnProperty('coating')) {
                            element = $("#r-coating-select");
                            element.empty().append('<option value="">Please Select</option>').prop('disabled', false);
                            $.each(data, function(key, value) {
                                element.append('<option value="' + value.coating + '">' + value.coating + '</option>');
                            });
                            shouldOpenSelect2 = true;

                        } else if (data[0].hasOwnProperty('sph')) {
                            element = $("#r-sph-select");
                            element.empty().append('<option value="">Please Select</option>').prop('disabled', false);
                            $.each(data, function(key, value) {
                                value.sph = value.sph.toFixed(2);
                                if (value.sph > 0) value.sph = '+' + value.sph;
                                element.append('<option value="' + value.sph + '">' + value.sph + '</option>');
                            });
                           // Automatically select "0.00" if available
                            if (element.find('option[value="0.00"]').length > 0) {
                                element.val("0.00").trigger('open'); // Set value and trigger change
                                shouldOpenSelect2 = true; // Prevent Select2 from opening
                            }
                            // Initialize or reinitialize Select2
                            if (element.hasClass('select2-hidden-accessible')) {
                                element.select2('destroy');
                            }
                            element.select2();

                        } else if (data[0].hasOwnProperty('cyl')) {
                            element = $("#r-cyl-select");
                            element.empty().append('<option value="">Please Select</option>').prop('disabled', false);
                            $.each(data, function(key, value) {
                                let cylFormatted = value.cyl.toFixed(2);
                                element.append('<option value="' + cylFormatted + '">' + cylFormatted + '</option>');
                            });
                           shouldOpenSelect2 = true;

                        } else if (data[0].hasOwnProperty('size')) {
                            rightPrice = parseFloat(data[0].price / 2).toFixed(2);
                            $("#r-size").html('');
                            $("#r-price").html('');
                            if (orderType === 'both' || orderType === 'right') {
                                $('#r-quantity').prop('disabled', false);
                            }
                            $("#r-size").append('<output class="badge bg-info">' + data[0].size + 'mm</output>');
                            let unitPriceFormatted = parseFloat(rightPrice).toFixed(2);
                            $("#r-price").append('<output class="badge bg-success">$' + unitPriceFormatted + '</output>');
                            let totalPrice = (parseFloat($('#r-quantity').val() || 1) * parseFloat(rightPrice)).toFixed(2);
                            $("#r-price_input").val(totalPrice); // Hidden input stores raw number
                            $("#r-size_input").val(data[0].size);
                            $("#r_barcode").val(data[0].barcode);
                            $("#r_vendor").val(data[0].vendor);
                            $("#r_cards").val(data[0].cards);
                        }

                        // Open Select2 if needed
                        if (shouldOpenSelect2 && element.length > 0) {
                            if (element.hasClass('select2-hidden-accessible')) {
                                element.select2('destroy');
                            }
                            element.select2().select2('open');
                        }
                        verifyAllData('right');
                        toggleSummaryVisibility();
                    }
                }
            });
        }
        function getLeftCombinitions(type, material = null, colour = null, coating = null, sph = null, cyl = null) {
            $.ajax({
                url: url,
                type: "GET",
                data: {
                    material: material,
                    colour: colour,
                    coating: coating,
                    sph: sph,
                    cyl: cyl,
                    type: type,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(data) {
                    if (data.length > 0) {
                        let element;
                        let shouldOpenSelect2 = false;
                        
                        if (data[0].hasOwnProperty('colour')) {
                            element = $("#l-colour-select");
                            element.empty().append('<option value="">Please Select</option>').prop('disabled', false);
                            $.each(data, function(key, value) {
                                element.append('<option value="' + value.colour + '">' + value.colour + '</option>');
                            });
                            shouldOpenSelect2 = true;
                            
                        } else if (data[0].hasOwnProperty('coating')) {
                            element = $("#l-coating-select");
                            element.empty().append('<option value="">Please Select</option>').prop('disabled', false);
                            $.each(data, function(key, value) {
                                element.append('<option value="' + value.coating + '">' + value.coating + '</option>');
                            });
                            shouldOpenSelect2 = true;
                            
                        } else if (data[0].hasOwnProperty('sph')) {
                            element = $("#l-sph-select");
                            element.empty().append('<option value="">Please Select</option>').prop('disabled', false);
                            $.each(data, function(key, value) {
                                value.sph = value.sph.toFixed(2);
                                if (value.sph > 0) value.sph = '+' + value.sph;
                                element.append('<option value="' + value.sph + '">' + value.sph + '</option>');
                            });
                            // Automatically select "0.00" if available
                            if (element.find('option[value="0.00"]').length > 0) {
                                element.val("0.00").trigger('open'); // Set value and trigger change
                                shouldOpenSelect2 = true; // Prevent Select2 from opening
                            }
                            // Initialize or reinitialize Select2
                            if (element.hasClass('select2-hidden-accessible')) {
                                element.select2('destroy');
                            }
                            element.select2();
                            
                        } else if (data[0].hasOwnProperty('cyl')) {
                            element = $("#l-cyl-select");
                            element.empty().append('<option value="">Please Select</option>').prop('disabled', false);
                            $.each(data, function(key, value) {
                                let cylFormatted = value.cyl.toFixed(2);
                                element.append('<option value="' + cylFormatted + '">' + cylFormatted + '</option>');
                            });
                            shouldOpenSelect2 = true;
                            
                        } else if (data[0].hasOwnProperty('size')) {
                            leftPrice = parseFloat(data[0].price / 2).toFixed(2);
                            if (orderType === 'both' || orderType === 'left') {
                                $('#l-quantity').prop('disabled', false);
                            }
                            $("#l-size").html('');
                            $("#l-price").html('');
                            $("#l-size").append('<output class="badge bg-info">' + data[0].size + 'mm</output>');
                            let unitPriceFormatted = parseFloat(leftPrice).toFixed(2);
                            $("#l-price").append('<output class="badge bg-success">$' + unitPriceFormatted + '</output>');
                            let totalPrice = (parseFloat($('#l-quantity').val() || 1) * parseFloat(leftPrice)).toFixed(2);
                            $("#l-price_input").val(totalPrice); // Hidden input stores raw number
                            $("#l-size_input").val(data[0].size);
                            $("#l_barcode").val(data[0].barcode);
                            $("#l_vendor").val(data[0].vendor);
                            $("#l_cards").val(data[0].cards);
                        }
                        
                        if (shouldOpenSelect2 && element.length > 0) {
                            if (element.hasClass('select2-hidden-accessible')) {
                                element.select2('destroy');
                            }
                            element.select2().select2('open');
                        }
                        
                        verifyAllData('left');
                        toggleSummaryVisibility();
                    }
                }
            });
        }

        function setSubmitCheck(orderType) {
            $('.btn-submit').prop('disabled', true);
            if (orderType == 'both') {
                if ($('#l-cyl-select').val() != '' && $('#r-cyl-select').val() != '') {
                    $('.btn-submit').prop('disabled', false);
                }
            } else if (orderType == 'right') {
                if ($('#r-cyl-select').val() != '') {
                    $('.btn-submit').prop('disabled', false);
                }
            } else if (orderType == 'left') {
                if ($('#l-cyl-select').val() != '') {
                    $('.btn-submit').prop('disabled', false);
                }
            }
        }

        function updateSummary() {
            let rPrice = 0, lPrice = 0;
            
            // Update patient field
            let patientText = $('input[name="patient"]').val();
            if (patientText) {
                $('#patient-field').html(patientText);
            }
            
            // Update right side fields
            if (orderType === 'both' || orderType === 'right') {
                $('.select-right-only').each(function() {
                    let fieldName = $(this).attr('name');
                    let value = $(this).val();
                    
                    // Only update quantity field if cyl is selected
                    if (fieldName === 'r_quantity' && $('#r-cyl-select').val() === '') {
                        return;
                    }
                    
                    if (value) {
                        if (fieldName === 'r_size') {
                            value += 'mm';
                        } else if (fieldName === 'r_price') {
                            let quantity = $('#r-quantity').val() || 1;
                            value = (quantity * rightPrice).toFixed(2);
                            $(this).val(value); // Hidden input stores raw number
                            rPrice = parseFloat(value);
                            $('#r_price-field').html(value);
                        }
                        $('#' + fieldName + '-field').html(value);
                        $('#r_price-field').html('$' + value);
                    } else {
                        $('#' + fieldName + '-field').html('');
                    }
                });
            }
            
            // Update left side fields
            if (orderType === 'both' || orderType === 'left') {
                $('.select-left-only').each(function() {
                    let fieldName = $(this).attr('name');
                    let value = $(this).val();
                    
                    // Only update quantity field if cyl is selected
                    if (fieldName === 'l_quantity' && $('#l-cyl-select').val() === '') {
                        return;
                    }
                    
                    if (value) {
                        if (fieldName === 'l_size') {
                            value += 'mm';
                        } else if (fieldName === 'l_price') {
                            let quantity = $('#l-quantity').val() || 1;
                            value = (quantity * leftPrice).toFixed(2);
                            $(this).val(value); // Hidden input stores raw number
                            lPrice = parseFloat(value);
                            $('#l_price-field').html(value);
                        }
                        
                        $('#' + fieldName + '-field').html(value);
                        $('#l_price-field').html('$' + value);
                    } else {
                        $('#' + fieldName + '-field').html('');
                    }
                });
            }

            // Handle price display
            if (rPrice === 0) {
                $('#r_price-field').closest('.col-1').hide();
            } else {
                $('#r_price-field').closest('.col-1').show();
            }
            if (lPrice === 0) {
                $('#l_price-field').closest('.col-1').hide();
            } else {
                $('#l_price-field').closest('.col-1').show();
            }

            let t_price = (rPrice + lPrice).toFixed(2);
            if (parseFloat(t_price) === 0) {
                $('#t_price-field').closest('.bold').hide();
            } else {
                $('#t_price-field').closest('.bold').show();
                $('#t_price-field').html(' $' + t_price); // Add $ sign
            }
        }

        function verifyAllData(type) {
            $('.' + type + '-container select').each(function(i, obj) {
                if ($(this).val() == '') {
                    if (type == 'right') {
                        $("#r-size").html('');
                        $("#r-price").html('');
                    } else {
                        $("#l-size").html('');
                        $("#l-price").html('');
                    }
                    return false;
                }
            });
        }

        function rxFormResize() {
            var windowHeight = $(window).height() - 265;
            $('.col-order-form-container').css('height', windowHeight + 'px');
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.split', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/lens-shapers/resources/views/frontend/auth/orders/create/stock-lens-order.blade.php ENDPATH**/ ?>