<?php echo e(html()->modelForm($logged_in_user, 'POST', route('frontend.user.profile.updateApi'))->class('form-horizontal change_avatar')->attribute('enctype', 'multipart/form-data')->open()); ?>

<?php echo method_field('POST'); ?>
<input type="hidden" name="steps" value="avatar">
<input type="hidden" name="avatar_type" value="storage" checked  />
<div class="form-group col">
    <div class="col-md-12">
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <?php if($logged_in_user->isCustomerAdmin()): ?>
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-picture font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> Add your business logo here </span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div class="portlet-body">
                <?php echo e(html()->file('avatar_location')->class('default-dropify picture')->attribute('data-allowed-file-extensions','png jpg jpeg')->attribute('data-show-loader','true')->attribute('data-max-file-size','20M')); ?>

            </div>
            <?php else: ?>              
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-picture font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> Business logo </span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div class="portlet-body text-center">
                <img src="<?php echo e($logged_in_user->getCustomerAdmin()->user_picture); ?>">
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php echo e(html()->closeModelForm()); ?>

<?php $__env->startPush('after-scripts'); ?>
<script type="text/javascript">
    var imageUrl = "<?= $logged_in_user->user_picture ?>";
    $(function() {
        var drEvent = $('.picture').dropify({
            defaultFile: imageUrl,
        });
        drEvent.on('dropify.beforeClear', function(event, element){
            if(confirm("Do you really want to delete?")){
                updatePicture(null);
                return true;
            }else{
                return false;
            }
        });
        drEvent.on('dropify.fileReady', function(event, bool){
            if(bool){
                updatePicture(event.currentTarget);
            }
        });
    });
    function updatePicture(target){
        url = $('.change_avatar').attr('action');
        var formData= new FormData();
        var form_data = $('.change_avatar' ).serializeArray();
        $.each(form_data, function (key, input) {
            formData.append(input.name, input.value);
        });
        if(target != null){
            formData.append('avatar_location', $(target)[0].files[0]);
        }
        $.ajax({
            url: url,
            type: "POST",
            data:formData,
            processData: false,
            contentType: false,
            success: function(data){
                if(data.status){
                    $('.profile-btn .avatar').attr('src',data.image);
                    $('.profile-btn .avatar').show();
                    $('.profile-nav img').attr('src',data.image);
                    toastr.success(data.message);
                }
                else
                    toastr.error(data.message);
            },
        });
    }
</script>
<?php $__env->stopPush(); ?><?php /**PATH /var/www/html/lens-shapers/resources/views/frontend/user/account/tabs/profile.blade.php ENDPATH**/ ?>