<?php
    use App\Models\Backend\PhoneLog;
?>
<style>
    .notification-grid {
        margin: auto;
        width: 100%;
        max-width: 100%;
        position: relative;
        display: flex;
        flex-direction: column;
    }

    .notification-unread {
        font-weight: bold;
    }

    .order-notification-table {
        position: relative;
        flex: 1;
        display: flex;
        flex-direction: column;
        overflow: hidden;
    }

    .order-notification-table table {
        width: 100%;
    }

    .order-notification-table thead {
        position: sticky;
        top: 0;
        background: white;
        z-index: 10;
        box-shadow: 0 2px 2px -1px rgba(0, 0, 0, 0.1);
    }

    .table-wrapper {
        overflow-y: auto;
        max-height: calc(91vh - 120px);
    }

    .pagination {
        position: sticky;
        bottom: 0;
        background: white;
        z-index: 10;
    }

    .notification-tooltip {
        position: relative;
        display: inline-block;
        cursor: pointer;
    }

    .notification-tooltip .notification-tooltiptext {
        visibility: hidden;
        width: 100px;
        background-color: lightslategrey;
        color: #fff;
        text-align: center;
        border-radius: 5px;
        padding: 0px 0;
        position: absolute;
        z-index: 1;
        top: auto;
        bottom: 100%;
        margin-top: 0;
        margin-bottom: 0px;
        font-size: 12px;
        left: -45px;
    }

    .notification-tooltip .notification-tooltiptext::after {
        content: "";
        position: absolute;
        bottom: -10px;
        left: 50%;
        transform: translateX(-50%);
        border-width: 5px;
        border-style: solid;
        border-color: lightslategrey transparent transparent transparent;
    }

    .notification-tooltip:hover .notification-tooltiptext {
        visibility: visible;
        opacity: 1;
    }


    .notification-table {
        display: table;
    }

    .notification-table thead, .notification-table tbody, .notification-table tr {
        display: table;
        width: 100%;
        table-layout: fixed;
    }

    .notification-table td, .notification-table th {
        display: table-cell;
    }

    .notification-icon {
        display: flex;
        align-items: center;
    }

    .notification-icon.grayscale {
        filter: grayscale(100%);
        opacity: 0.8;
        transition: filter 0.3s ease, opacity 0.3s ease;
    }

    .notification-icon.grayscale ~ td {
        color: #6c757d !important;
    }
    .notification-item {
        cursor: pointer;
    }

    .notification-icon .label {
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 20px;
        height: 20px;
    }

    .notification-icon .badge {
        display: inline-flex;
        align-items: center;
        gap: 2px;
        padding: 4px 8px;
        white-space: nowrap;
    }

    .notification-icon .fa {
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }

    .notification-table tbody tr td {
        padding-bottom: 10px;
    }

    .notification-icon.grayscale {
    filter: grayscale(100%);
    opacity: 0.8;
    transition: filter 0.3s ease, opacity 0.3s ease;
}

.notification-icon.grayscale ~ td {
    color: #6c757d !important;
}
.notification-table tbody tr td {
        padding-bottom: 10px;
    }
    
</style>
<div class="notification-grid" data-notification-type="<?php echo e($portalType); ?>">
    <div class="row justify-content-center">
        <div class="col-lg-12">
            <div class="portlet-body list-table order-notification-table" id='notification-container' data-notification-type="<?php echo e($portalType); ?>">
                <div class="table-responsive">
                    <div class="table-wrapper">
                        <table class="table table-striped table-sm table-hover w-auto notification-table">
                        <thead>
                            <tr>
                                <th width="10%"></th>
                                <th width="10%">Order</th>
                                <th width="5%">Tray</th>
                                <th width="5%">Invoice</th>
                                <th width="20%">Patient Reference</th>
                                <?php if($type == 'backend'): ?>
                                    <th width="20%">Account</th>
                                <?php endif; ?>
                                <th width="10%">Sender</th>
                                <th width="15%">Sent</th>
                                <th width="5%"></th>
                            </tr>
                        </thead>
                        <tbody id="notification-tableBody">
                            <?php $__currentLoopData = $response; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="notification-item <?php echo e($notification['has_read'] ? 'notification-read' : 'notification-unread'); ?>" data-attr-id= "<?php echo e($notification['id']); ?>" data-attr-order-id = "<?php echo e($notification['order_id']); ?>" data-attr-log-id = "<?php echo e($notification['plog_id']); ?>" data-attr-user-id = "<?php echo e($notification['user_id']); ?>" data-attr-type = "<?php echo e($notification['type']); ?>" >
                                    <td width="10%">
                                        <div class="notification-icon <?php if($notification['has_read']): ?> grayscale <?php endif; ?>">
                                            <?php if($notification['has_read']): ?>
                                                <div class="label label-sm label-success">
                                                    <i class="fa fa-check" style="font-size: 10px;"></i>
                                                </div>
                                            <?php else: ?>
                                                <div class="label label-sm label-danger">
                                                    <i class="fa fa-bell-o" style="font-size: 10px;"></i>
                                                </div>
                                            <?php endif; ?>
                                            <span style="margin-left: 10px; margin-top: -2px;">
                                                <span><?php echo PhoneLog::getNotifyIcon($notification['type']); ?></span>
                                            </span>
                                        </div>
                                    </td>
                                    <td width="10%"><?php echo e($notification['order_id_method']); ?></td>
                                    <td width="5%"><?php echo e($notification['tray']); ?></td>
                                    <td width="5%"><?php echo e($notification['invoice_no']); ?></td>
                                    <td width="20%"><?php echo e($notification['patient'] ?? $notification['patient']); ?></td>
                                    <?php if($type == 'backend'): ?>
                                        <td width="20%"><?php echo e($notification['account']); ?></td>
                                    <?php endif; ?>
                                    <td width="10%"><?php echo e($notification['sender_name'] ?? 'Unknown'); ?></td>
                                    <td width="15%"><?php echo e($notification['created_at']); ?> </td>
                                    <td width="5%">
                                        <?php if($notification['has_read']): ?>
                                            <div class="notification-tooltip" data-type="unread"><i class="fa fa-envelope-open-o" style="font-size: 10px;"></i>
                                                <span class="notification-tooltiptext">Mark as unread</span>
                                            </div>
                                        <?php else: ?>
                                            <div class="notification-tooltip" data-type="read"><i class="fa fa-envelope-o" style="font-size: 10px;"></i>
                                                <span class="notification-tooltiptext">Mark as read</span>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        </table>
                    </div>
                </div>
                <div class="d-flex justify-content-center">
                    <?php echo e($notifications->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /var/www/html/lens-shapers/resources/views/partials/notifications.blade.php ENDPATH**/ ?>