<input type="hidden" name="invoice_order_no" id="invoice_order_no" value="<?php echo e($order->invoice_no); ?>">
<?php if($order->type != 'rx'): ?>
    <div class="print-btn-container">
        <?php if($isCustomerAdmin): ?>
            <button class="btn blue print_order-btn" data-url="<?php echo e(route('frontend.user.orders.print', $order)); ?>"><i class="fas fa-print"></i> Print</button>
        <?php else: ?>
            <?php if(Auth::user()->hasRole('administrator')): ?>
                <div class="labzilla-order-btn">
                    <button class="btn blue float-right lab-order-model" type="submit">Labzilla Call</button>
                    <button class="btn green float-right lab-order-submit" type="submit">Send to Labzilla</button>
                </div>
            <?php endif; ?>
            <button class="btn red print_order-btn" data-url="<?php echo e(route('admin.order.print', $order)); ?>">Print Local</button>
            <button class="btn blue print_order-btn" data-url="<?php echo e(route('admin.order.upload-print', $order)); ?>">Print</button>
        <?php endif; ?>
    </div>
<?php else: ?>
    <div class="print-btn-container">
        <?php if($order->isSaved()): ?>
            <a class="btn red" href="<?php echo e(route('frontend.user.orders.destroy',$order)); ?>"><i class="fa fa-trash"></i> Delete</a>
            <a class="btn blue" href="<?php echo e(route('frontend.user.new-rx-lens-order')); ?>?edit=<?php echo e($order->id); ?>"><i class="fa fa-pencil"></i> Edit</a>
        <?php else: ?>
            <?php if($isCustomerAdmin): ?>
                <button class="btn blue print_order-btn" data-url="<?php echo e(route('frontend.user.orders.print',$order)); ?>"><i class="fas fa-print"></i> Print</button>
                <?php if(!$order->isOffline() && !$order->isLegacy()): ?>
                    <a class="btn red" href="<?php echo e(route('frontend.user.new-rx-lens-order')); ?>?reuse=<?php echo e($order->id); ?>" target="_blank"><i class="fas fa-recycle"></i> Reuse</a>
                    <?php if($order->isWebOrder()): ?>
                        <button class="btn green redo_order-btn" data-id="<?php echo e($order->id); ?>"><i class="fas fa-redo"></i> Start Redo</button>
                    <?php endif; ?>
                <?php else: ?>
                    <?php if(!auth()->user()->isCustomerStaff()): ?>
                        <span data-toggle="tooltip" title="Not available for this order">
                        <button class="btn red" disabled>
                            <i class="fas fa-recycle"></i> Reuse
                        </button>
                        </span>

                        <span data-toggle="tooltip" title="Not available for this order">
                        <button class="btn green" disabled>
                            <i class="fas fa-redo"></i> Start Redo
                        </button>
                        </span>
                    <?php endif; ?>
                <?php endif; ?>
            <?php else: ?>
                <?php if(Auth::user()->hasRole('administrator')): ?>
                    <div class="labzilla-order-btn">
                        <button class="btn blue float-right lab-order-model" type="submit">Labzilla Call</button>
                        <button class="btn green float-right lab-order-submit" type="submit">Send to Labzilla</button>
                    </div>
                <?php endif; ?>
                <button class="btn red print_order-btn" data-url="<?php echo e(route('admin.order.print', $order)); ?>">Print Local</button>
                <button class="btn blue print_order-btn" data-url="<?php echo e(route('admin.order.upload-print', $order)); ?>">Print</button>
            <?php endif; ?>
        <?php endif; ?>
    </div>
<?php endif; ?>
<?php /**PATH /var/www/html/lens-shapers/resources/views/partials/actions/printbtn.blade.php ENDPATH**/ ?>