import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
    plugins: [
        laravel({
            input: ['resources/css/app.css', 'resources/js/app.js'],
            refresh: true,
        }),
    ],
    server: {
        host: 'lens-shapers',
        port: 5180,
        allowedHosts: [
            'lens-shapers',
        ],
        watch: {
            ignored: ['**/node_modules/**', '**/storage/**', '**/vendor/**', '**/public/**', '**/resources/lang/**'],
        },
    },
});
